/*
 * MX Platform API
 * The MX Platform API is a powerful, fully-featured API designed to make aggregating and enhancing financial data easy and reliable. It can seamlessly connect your app or website to tens of thousands of financial institutions.
 *
 * The version of the OpenAPI document: 0.1.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.mx.client.mx_platform_api;

import com.mx.client.ApiCallback;
import com.mx.client.ApiClient;
import com.mx.client.ApiException;
import com.mx.client.ApiResponse;
import com.mx.client.Configuration;
import com.mx.client.Pair;
import com.mx.client.ProgressRequestBody;
import com.mx.client.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import com.mx.client.model.AccountNumbersResponseBody;
import com.mx.client.model.AccountOwnersResponseBody;
import com.mx.client.model.AccountResponseBody;
import com.mx.client.model.AccountUpdateRequestBody;
import com.mx.client.model.AccountsResponseBody;
import com.mx.client.model.CategoriesResponseBody;
import com.mx.client.model.CategoryCreateRequestBody;
import com.mx.client.model.CategoryResponseBody;
import com.mx.client.model.CategoryUpdateRequestBody;
import com.mx.client.model.ChallengesResponseBody;
import com.mx.client.model.ConnectWidgetRequestBody;
import com.mx.client.model.ConnectWidgetResponseBody;
import com.mx.client.model.CredentialsResponseBody;
import com.mx.client.model.EnhanceTransactionsRequestBody;
import com.mx.client.model.EnhanceTransactionsResponseBody;
import java.io.File;
import com.mx.client.model.HoldingResponseBody;
import com.mx.client.model.HoldingsResponseBody;
import com.mx.client.model.InstitutionResponseBody;
import com.mx.client.model.InstitutionsResponseBody;
import com.mx.client.model.ManagedAccountCreateRequestBody;
import com.mx.client.model.ManagedAccountUpdateRequestBody;
import com.mx.client.model.ManagedMemberCreateRequestBody;
import com.mx.client.model.ManagedMemberUpdateRequestBody;
import com.mx.client.model.ManagedTransactionCreateRequestBody;
import com.mx.client.model.ManagedTransactionUpdateRequestBody;
import com.mx.client.model.MemberCreateRequestBody;
import com.mx.client.model.MemberResponseBody;
import com.mx.client.model.MemberResumeRequestBody;
import com.mx.client.model.MemberStatusResponseBody;
import com.mx.client.model.MemberUpdateRequestBody;
import com.mx.client.model.MembersResponseBody;
import com.mx.client.model.MerchantLocationResponseBody;
import com.mx.client.model.MerchantResponseBody;
import com.mx.client.model.MerchantsResponseBody;
import com.mx.client.model.OAuthWindowResponseBody;
import com.mx.client.model.StatementResponseBody;
import com.mx.client.model.StatementsResponseBody;
import com.mx.client.model.TagCreateRequestBody;
import com.mx.client.model.TagResponseBody;
import com.mx.client.model.TagUpdateRequestBody;
import com.mx.client.model.TaggingCreateRequestBody;
import com.mx.client.model.TaggingResponseBody;
import com.mx.client.model.TaggingUpdateRequestBody;
import com.mx.client.model.TaggingsResponseBody;
import com.mx.client.model.TagsResponseBody;
import com.mx.client.model.TransactionResponseBody;
import com.mx.client.model.TransactionRuleCreateRequestBody;
import com.mx.client.model.TransactionRuleResponseBody;
import com.mx.client.model.TransactionRuleUpdateRequestBody;
import com.mx.client.model.TransactionRulesResponseBody;
import com.mx.client.model.TransactionUpdateRequestBody;
import com.mx.client.model.TransactionsResponseBody;
import com.mx.client.model.UserCreateRequestBody;
import com.mx.client.model.UserResponseBody;
import com.mx.client.model.UserUpdateRequestBody;
import com.mx.client.model.UsersResponseBody;
import com.mx.client.model.WidgetRequestBody;
import com.mx.client.model.WidgetResponseBody;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MxPlatformApi {
    private ApiClient localVarApiClient;

    public MxPlatformApi() {
        this(Configuration.getDefaultApiClient());
    }

    public MxPlatformApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for aggregateMember
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call aggregateMemberCall(String memberGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/members/{member_guid}/aggregate"
            .replaceAll("\\{" + "member_guid" + "\\}", localVarApiClient.escapeString(memberGuid.toString()))
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call aggregateMemberValidateBeforeCall(String memberGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling aggregateMember(Async)");
        }
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling aggregateMember(Async)");
        }
        

        okhttp3.Call localVarCall = aggregateMemberCall(memberGuid, userGuid, _callback);
        return localVarCall;

    }

    /**
     * Aggregate member
     * Calling this endpoint initiates an aggregation event for the member. This brings in the latest account and transaction data from the connected institution. If this data has recently been updated, MX may not initiate an aggregation event.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return MemberResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public MemberResponseBody aggregateMember(String memberGuid, String userGuid) throws ApiException {
        ApiResponse<MemberResponseBody> localVarResp = aggregateMemberWithHttpInfo(memberGuid, userGuid);
        return localVarResp.getData();
    }

    /**
     * Aggregate member
     * Calling this endpoint initiates an aggregation event for the member. This brings in the latest account and transaction data from the connected institution. If this data has recently been updated, MX may not initiate an aggregation event.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return ApiResponse&lt;MemberResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MemberResponseBody> aggregateMemberWithHttpInfo(String memberGuid, String userGuid) throws ApiException {
        okhttp3.Call localVarCall = aggregateMemberValidateBeforeCall(memberGuid, userGuid, null);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Aggregate member (asynchronously)
     * Calling this endpoint initiates an aggregation event for the member. This brings in the latest account and transaction data from the connected institution. If this data has recently been updated, MX may not initiate an aggregation event.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call aggregateMemberAsync(String memberGuid, String userGuid, final ApiCallback<MemberResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = aggregateMemberValidateBeforeCall(memberGuid, userGuid, _callback);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for checkBalances
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call checkBalancesCall(String memberGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/members/{member_guid}/check_balance"
            .replaceAll("\\{" + "member_guid" + "\\}", localVarApiClient.escapeString(memberGuid.toString()))
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call checkBalancesValidateBeforeCall(String memberGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling checkBalances(Async)");
        }
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling checkBalances(Async)");
        }
        

        okhttp3.Call localVarCall = checkBalancesCall(memberGuid, userGuid, _callback);
        return localVarCall;

    }

    /**
     * Check balances
     * This endpoint operates much like the aggregate member endpoint except that it gathers only account balance information; it does not gather any transaction data.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return MemberResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public MemberResponseBody checkBalances(String memberGuid, String userGuid) throws ApiException {
        ApiResponse<MemberResponseBody> localVarResp = checkBalancesWithHttpInfo(memberGuid, userGuid);
        return localVarResp.getData();
    }

    /**
     * Check balances
     * This endpoint operates much like the aggregate member endpoint except that it gathers only account balance information; it does not gather any transaction data.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return ApiResponse&lt;MemberResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MemberResponseBody> checkBalancesWithHttpInfo(String memberGuid, String userGuid) throws ApiException {
        okhttp3.Call localVarCall = checkBalancesValidateBeforeCall(memberGuid, userGuid, null);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Check balances (asynchronously)
     * This endpoint operates much like the aggregate member endpoint except that it gathers only account balance information; it does not gather any transaction data.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call checkBalancesAsync(String memberGuid, String userGuid, final ApiCallback<MemberResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = checkBalancesValidateBeforeCall(memberGuid, userGuid, _callback);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for createCategory
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param categoryCreateRequestBody Custom category object to be created (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createCategoryCall(String userGuid, CategoryCreateRequestBody categoryCreateRequestBody, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = categoryCreateRequestBody;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/categories"
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createCategoryValidateBeforeCall(String userGuid, CategoryCreateRequestBody categoryCreateRequestBody, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling createCategory(Async)");
        }
        
        // verify the required parameter 'categoryCreateRequestBody' is set
        if (categoryCreateRequestBody == null) {
            throw new ApiException("Missing the required parameter 'categoryCreateRequestBody' when calling createCategory(Async)");
        }
        

        okhttp3.Call localVarCall = createCategoryCall(userGuid, categoryCreateRequestBody, _callback);
        return localVarCall;

    }

    /**
     * Create category
     * Use this endpoint to create a new custom category for a specific &#x60;user&#x60;.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param categoryCreateRequestBody Custom category object to be created (required)
     * @return CategoryResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public CategoryResponseBody createCategory(String userGuid, CategoryCreateRequestBody categoryCreateRequestBody) throws ApiException {
        ApiResponse<CategoryResponseBody> localVarResp = createCategoryWithHttpInfo(userGuid, categoryCreateRequestBody);
        return localVarResp.getData();
    }

    /**
     * Create category
     * Use this endpoint to create a new custom category for a specific &#x60;user&#x60;.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param categoryCreateRequestBody Custom category object to be created (required)
     * @return ApiResponse&lt;CategoryResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CategoryResponseBody> createCategoryWithHttpInfo(String userGuid, CategoryCreateRequestBody categoryCreateRequestBody) throws ApiException {
        okhttp3.Call localVarCall = createCategoryValidateBeforeCall(userGuid, categoryCreateRequestBody, null);
        Type localVarReturnType = new TypeToken<CategoryResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create category (asynchronously)
     * Use this endpoint to create a new custom category for a specific &#x60;user&#x60;.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param categoryCreateRequestBody Custom category object to be created (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createCategoryAsync(String userGuid, CategoryCreateRequestBody categoryCreateRequestBody, final ApiCallback<CategoryResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = createCategoryValidateBeforeCall(userGuid, categoryCreateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<CategoryResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for createManagedAccount
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param managedAccountCreateRequestBody Managed account to be created. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createManagedAccountCall(String userGuid, String memberGuid, ManagedAccountCreateRequestBody managedAccountCreateRequestBody, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = managedAccountCreateRequestBody;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/managed_members/{member_guid}/accounts"
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()))
            .replaceAll("\\{" + "member_guid" + "\\}", localVarApiClient.escapeString(memberGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createManagedAccountValidateBeforeCall(String userGuid, String memberGuid, ManagedAccountCreateRequestBody managedAccountCreateRequestBody, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling createManagedAccount(Async)");
        }
        
        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling createManagedAccount(Async)");
        }
        
        // verify the required parameter 'managedAccountCreateRequestBody' is set
        if (managedAccountCreateRequestBody == null) {
            throw new ApiException("Missing the required parameter 'managedAccountCreateRequestBody' when calling createManagedAccount(Async)");
        }
        

        okhttp3.Call localVarCall = createManagedAccountCall(userGuid, memberGuid, managedAccountCreateRequestBody, _callback);
        return localVarCall;

    }

    /**
     * Create managed account
     * Use this endpoint to create a partner-managed account.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param managedAccountCreateRequestBody Managed account to be created. (required)
     * @return AccountResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public AccountResponseBody createManagedAccount(String userGuid, String memberGuid, ManagedAccountCreateRequestBody managedAccountCreateRequestBody) throws ApiException {
        ApiResponse<AccountResponseBody> localVarResp = createManagedAccountWithHttpInfo(userGuid, memberGuid, managedAccountCreateRequestBody);
        return localVarResp.getData();
    }

    /**
     * Create managed account
     * Use this endpoint to create a partner-managed account.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param managedAccountCreateRequestBody Managed account to be created. (required)
     * @return ApiResponse&lt;AccountResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<AccountResponseBody> createManagedAccountWithHttpInfo(String userGuid, String memberGuid, ManagedAccountCreateRequestBody managedAccountCreateRequestBody) throws ApiException {
        okhttp3.Call localVarCall = createManagedAccountValidateBeforeCall(userGuid, memberGuid, managedAccountCreateRequestBody, null);
        Type localVarReturnType = new TypeToken<AccountResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create managed account (asynchronously)
     * Use this endpoint to create a partner-managed account.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param managedAccountCreateRequestBody Managed account to be created. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createManagedAccountAsync(String userGuid, String memberGuid, ManagedAccountCreateRequestBody managedAccountCreateRequestBody, final ApiCallback<AccountResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = createManagedAccountValidateBeforeCall(userGuid, memberGuid, managedAccountCreateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<AccountResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for createManagedMember
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param managedMemberCreateRequestBody Managed member to be created. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createManagedMemberCall(String userGuid, ManagedMemberCreateRequestBody managedMemberCreateRequestBody, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = managedMemberCreateRequestBody;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/managed_members"
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createManagedMemberValidateBeforeCall(String userGuid, ManagedMemberCreateRequestBody managedMemberCreateRequestBody, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling createManagedMember(Async)");
        }
        
        // verify the required parameter 'managedMemberCreateRequestBody' is set
        if (managedMemberCreateRequestBody == null) {
            throw new ApiException("Missing the required parameter 'managedMemberCreateRequestBody' when calling createManagedMember(Async)");
        }
        

        okhttp3.Call localVarCall = createManagedMemberCall(userGuid, managedMemberCreateRequestBody, _callback);
        return localVarCall;

    }

    /**
     * Create managed member
     * Use this endpoint to create a new partner-managed &#x60;member&#x60;.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param managedMemberCreateRequestBody Managed member to be created. (required)
     * @return MemberResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public MemberResponseBody createManagedMember(String userGuid, ManagedMemberCreateRequestBody managedMemberCreateRequestBody) throws ApiException {
        ApiResponse<MemberResponseBody> localVarResp = createManagedMemberWithHttpInfo(userGuid, managedMemberCreateRequestBody);
        return localVarResp.getData();
    }

    /**
     * Create managed member
     * Use this endpoint to create a new partner-managed &#x60;member&#x60;.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param managedMemberCreateRequestBody Managed member to be created. (required)
     * @return ApiResponse&lt;MemberResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MemberResponseBody> createManagedMemberWithHttpInfo(String userGuid, ManagedMemberCreateRequestBody managedMemberCreateRequestBody) throws ApiException {
        okhttp3.Call localVarCall = createManagedMemberValidateBeforeCall(userGuid, managedMemberCreateRequestBody, null);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create managed member (asynchronously)
     * Use this endpoint to create a new partner-managed &#x60;member&#x60;.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param managedMemberCreateRequestBody Managed member to be created. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createManagedMemberAsync(String userGuid, ManagedMemberCreateRequestBody managedMemberCreateRequestBody, final ApiCallback<MemberResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = createManagedMemberValidateBeforeCall(userGuid, managedMemberCreateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for createManagedTransaction
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param managedTransactionCreateRequestBody Managed transaction to be created. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createManagedTransactionCall(String userGuid, String memberGuid, ManagedTransactionCreateRequestBody managedTransactionCreateRequestBody, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = managedTransactionCreateRequestBody;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/managed_members/{member_guid}/transactions"
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()))
            .replaceAll("\\{" + "member_guid" + "\\}", localVarApiClient.escapeString(memberGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createManagedTransactionValidateBeforeCall(String userGuid, String memberGuid, ManagedTransactionCreateRequestBody managedTransactionCreateRequestBody, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling createManagedTransaction(Async)");
        }
        
        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling createManagedTransaction(Async)");
        }
        
        // verify the required parameter 'managedTransactionCreateRequestBody' is set
        if (managedTransactionCreateRequestBody == null) {
            throw new ApiException("Missing the required parameter 'managedTransactionCreateRequestBody' when calling createManagedTransaction(Async)");
        }
        

        okhttp3.Call localVarCall = createManagedTransactionCall(userGuid, memberGuid, managedTransactionCreateRequestBody, _callback);
        return localVarCall;

    }

    /**
     * Create managed transaction
     * Use this endpoint to create a new partner-managed &#x60;transaction&#x60;.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param managedTransactionCreateRequestBody Managed transaction to be created. (required)
     * @return TransactionResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public TransactionResponseBody createManagedTransaction(String userGuid, String memberGuid, ManagedTransactionCreateRequestBody managedTransactionCreateRequestBody) throws ApiException {
        ApiResponse<TransactionResponseBody> localVarResp = createManagedTransactionWithHttpInfo(userGuid, memberGuid, managedTransactionCreateRequestBody);
        return localVarResp.getData();
    }

    /**
     * Create managed transaction
     * Use this endpoint to create a new partner-managed &#x60;transaction&#x60;.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param managedTransactionCreateRequestBody Managed transaction to be created. (required)
     * @return ApiResponse&lt;TransactionResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TransactionResponseBody> createManagedTransactionWithHttpInfo(String userGuid, String memberGuid, ManagedTransactionCreateRequestBody managedTransactionCreateRequestBody) throws ApiException {
        okhttp3.Call localVarCall = createManagedTransactionValidateBeforeCall(userGuid, memberGuid, managedTransactionCreateRequestBody, null);
        Type localVarReturnType = new TypeToken<TransactionResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create managed transaction (asynchronously)
     * Use this endpoint to create a new partner-managed &#x60;transaction&#x60;.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param managedTransactionCreateRequestBody Managed transaction to be created. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createManagedTransactionAsync(String userGuid, String memberGuid, ManagedTransactionCreateRequestBody managedTransactionCreateRequestBody, final ApiCallback<TransactionResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = createManagedTransactionValidateBeforeCall(userGuid, memberGuid, managedTransactionCreateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<TransactionResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for createMember
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberCreateRequestBody Member object to be created with optional parameters (id and metadata) and required parameters (credentials and institution_code) (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createMemberCall(String userGuid, MemberCreateRequestBody memberCreateRequestBody, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = memberCreateRequestBody;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/members"
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createMemberValidateBeforeCall(String userGuid, MemberCreateRequestBody memberCreateRequestBody, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling createMember(Async)");
        }
        
        // verify the required parameter 'memberCreateRequestBody' is set
        if (memberCreateRequestBody == null) {
            throw new ApiException("Missing the required parameter 'memberCreateRequestBody' when calling createMember(Async)");
        }
        

        okhttp3.Call localVarCall = createMemberCall(userGuid, memberCreateRequestBody, _callback);
        return localVarCall;

    }

    /**
     * Create member
     * This endpoint allows you to create a new member. Members are created with the required parameters credentials and institution_code, and the optional parameters id and metadata. When creating a member, youll need to include the correct type of credential required by the financial institution and provided by the user. You can find out which credential type is required with the &#x60;/institutions/{institution_code}/credentials&#x60; endpoint. If successful, the MX Platform API will respond with the newly-created member object. Once you successfully create a member, MX will immediately validate the provided credentials and attempt to aggregate data for accounts and transactions.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberCreateRequestBody Member object to be created with optional parameters (id and metadata) and required parameters (credentials and institution_code) (required)
     * @return MemberResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public MemberResponseBody createMember(String userGuid, MemberCreateRequestBody memberCreateRequestBody) throws ApiException {
        ApiResponse<MemberResponseBody> localVarResp = createMemberWithHttpInfo(userGuid, memberCreateRequestBody);
        return localVarResp.getData();
    }

    /**
     * Create member
     * This endpoint allows you to create a new member. Members are created with the required parameters credentials and institution_code, and the optional parameters id and metadata. When creating a member, youll need to include the correct type of credential required by the financial institution and provided by the user. You can find out which credential type is required with the &#x60;/institutions/{institution_code}/credentials&#x60; endpoint. If successful, the MX Platform API will respond with the newly-created member object. Once you successfully create a member, MX will immediately validate the provided credentials and attempt to aggregate data for accounts and transactions.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberCreateRequestBody Member object to be created with optional parameters (id and metadata) and required parameters (credentials and institution_code) (required)
     * @return ApiResponse&lt;MemberResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MemberResponseBody> createMemberWithHttpInfo(String userGuid, MemberCreateRequestBody memberCreateRequestBody) throws ApiException {
        okhttp3.Call localVarCall = createMemberValidateBeforeCall(userGuid, memberCreateRequestBody, null);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create member (asynchronously)
     * This endpoint allows you to create a new member. Members are created with the required parameters credentials and institution_code, and the optional parameters id and metadata. When creating a member, youll need to include the correct type of credential required by the financial institution and provided by the user. You can find out which credential type is required with the &#x60;/institutions/{institution_code}/credentials&#x60; endpoint. If successful, the MX Platform API will respond with the newly-created member object. Once you successfully create a member, MX will immediately validate the provided credentials and attempt to aggregate data for accounts and transactions.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberCreateRequestBody Member object to be created with optional parameters (id and metadata) and required parameters (credentials and institution_code) (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createMemberAsync(String userGuid, MemberCreateRequestBody memberCreateRequestBody, final ApiCallback<MemberResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = createMemberValidateBeforeCall(userGuid, memberCreateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for createTag
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param tagCreateRequestBody Tag object to be created with required parameters (tag_guid) (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createTagCall(String userGuid, TagCreateRequestBody tagCreateRequestBody, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = tagCreateRequestBody;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/tags"
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createTagValidateBeforeCall(String userGuid, TagCreateRequestBody tagCreateRequestBody, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling createTag(Async)");
        }
        
        // verify the required parameter 'tagCreateRequestBody' is set
        if (tagCreateRequestBody == null) {
            throw new ApiException("Missing the required parameter 'tagCreateRequestBody' when calling createTag(Async)");
        }
        

        okhttp3.Call localVarCall = createTagCall(userGuid, tagCreateRequestBody, _callback);
        return localVarCall;

    }

    /**
     * Create tag
     * Use this endpoint to create a new custom tag.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param tagCreateRequestBody Tag object to be created with required parameters (tag_guid) (required)
     * @return TagResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public TagResponseBody createTag(String userGuid, TagCreateRequestBody tagCreateRequestBody) throws ApiException {
        ApiResponse<TagResponseBody> localVarResp = createTagWithHttpInfo(userGuid, tagCreateRequestBody);
        return localVarResp.getData();
    }

    /**
     * Create tag
     * Use this endpoint to create a new custom tag.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param tagCreateRequestBody Tag object to be created with required parameters (tag_guid) (required)
     * @return ApiResponse&lt;TagResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TagResponseBody> createTagWithHttpInfo(String userGuid, TagCreateRequestBody tagCreateRequestBody) throws ApiException {
        okhttp3.Call localVarCall = createTagValidateBeforeCall(userGuid, tagCreateRequestBody, null);
        Type localVarReturnType = new TypeToken<TagResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create tag (asynchronously)
     * Use this endpoint to create a new custom tag.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param tagCreateRequestBody Tag object to be created with required parameters (tag_guid) (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createTagAsync(String userGuid, TagCreateRequestBody tagCreateRequestBody, final ApiCallback<TagResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = createTagValidateBeforeCall(userGuid, tagCreateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<TagResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for createTagging
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param taggingCreateRequestBody Tagging object to be created with required parameters (tag_guid and transaction_guid) (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createTaggingCall(String userGuid, TaggingCreateRequestBody taggingCreateRequestBody, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = taggingCreateRequestBody;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/taggings"
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createTaggingValidateBeforeCall(String userGuid, TaggingCreateRequestBody taggingCreateRequestBody, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling createTagging(Async)");
        }
        
        // verify the required parameter 'taggingCreateRequestBody' is set
        if (taggingCreateRequestBody == null) {
            throw new ApiException("Missing the required parameter 'taggingCreateRequestBody' when calling createTagging(Async)");
        }
        

        okhttp3.Call localVarCall = createTaggingCall(userGuid, taggingCreateRequestBody, _callback);
        return localVarCall;

    }

    /**
     * Create tagging
     * Use this endpoint to create a new association between a tag and a particular transaction, according to their unique GUIDs.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param taggingCreateRequestBody Tagging object to be created with required parameters (tag_guid and transaction_guid) (required)
     * @return TaggingResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public TaggingResponseBody createTagging(String userGuid, TaggingCreateRequestBody taggingCreateRequestBody) throws ApiException {
        ApiResponse<TaggingResponseBody> localVarResp = createTaggingWithHttpInfo(userGuid, taggingCreateRequestBody);
        return localVarResp.getData();
    }

    /**
     * Create tagging
     * Use this endpoint to create a new association between a tag and a particular transaction, according to their unique GUIDs.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param taggingCreateRequestBody Tagging object to be created with required parameters (tag_guid and transaction_guid) (required)
     * @return ApiResponse&lt;TaggingResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TaggingResponseBody> createTaggingWithHttpInfo(String userGuid, TaggingCreateRequestBody taggingCreateRequestBody) throws ApiException {
        okhttp3.Call localVarCall = createTaggingValidateBeforeCall(userGuid, taggingCreateRequestBody, null);
        Type localVarReturnType = new TypeToken<TaggingResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create tagging (asynchronously)
     * Use this endpoint to create a new association between a tag and a particular transaction, according to their unique GUIDs.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param taggingCreateRequestBody Tagging object to be created with required parameters (tag_guid and transaction_guid) (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createTaggingAsync(String userGuid, TaggingCreateRequestBody taggingCreateRequestBody, final ApiCallback<TaggingResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = createTaggingValidateBeforeCall(userGuid, taggingCreateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<TaggingResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for createTransactionRule
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param transactionRuleCreateRequestBody TransactionRule object to be created with optional parameters (description) and required parameters (category_guid and match_description) (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createTransactionRuleCall(String userGuid, TransactionRuleCreateRequestBody transactionRuleCreateRequestBody, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = transactionRuleCreateRequestBody;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/transaction_rules"
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createTransactionRuleValidateBeforeCall(String userGuid, TransactionRuleCreateRequestBody transactionRuleCreateRequestBody, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling createTransactionRule(Async)");
        }
        
        // verify the required parameter 'transactionRuleCreateRequestBody' is set
        if (transactionRuleCreateRequestBody == null) {
            throw new ApiException("Missing the required parameter 'transactionRuleCreateRequestBody' when calling createTransactionRule(Async)");
        }
        

        okhttp3.Call localVarCall = createTransactionRuleCall(userGuid, transactionRuleCreateRequestBody, _callback);
        return localVarCall;

    }

    /**
     * Create transaction rule
     * Use this endpoint to create a new transaction rule. The newly-created &#x60;transaction_rule&#x60; object will be returned if successful.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param transactionRuleCreateRequestBody TransactionRule object to be created with optional parameters (description) and required parameters (category_guid and match_description) (required)
     * @return TransactionRuleResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public TransactionRuleResponseBody createTransactionRule(String userGuid, TransactionRuleCreateRequestBody transactionRuleCreateRequestBody) throws ApiException {
        ApiResponse<TransactionRuleResponseBody> localVarResp = createTransactionRuleWithHttpInfo(userGuid, transactionRuleCreateRequestBody);
        return localVarResp.getData();
    }

    /**
     * Create transaction rule
     * Use this endpoint to create a new transaction rule. The newly-created &#x60;transaction_rule&#x60; object will be returned if successful.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param transactionRuleCreateRequestBody TransactionRule object to be created with optional parameters (description) and required parameters (category_guid and match_description) (required)
     * @return ApiResponse&lt;TransactionRuleResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TransactionRuleResponseBody> createTransactionRuleWithHttpInfo(String userGuid, TransactionRuleCreateRequestBody transactionRuleCreateRequestBody) throws ApiException {
        okhttp3.Call localVarCall = createTransactionRuleValidateBeforeCall(userGuid, transactionRuleCreateRequestBody, null);
        Type localVarReturnType = new TypeToken<TransactionRuleResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create transaction rule (asynchronously)
     * Use this endpoint to create a new transaction rule. The newly-created &#x60;transaction_rule&#x60; object will be returned if successful.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param transactionRuleCreateRequestBody TransactionRule object to be created with optional parameters (description) and required parameters (category_guid and match_description) (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createTransactionRuleAsync(String userGuid, TransactionRuleCreateRequestBody transactionRuleCreateRequestBody, final ApiCallback<TransactionRuleResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = createTransactionRuleValidateBeforeCall(userGuid, transactionRuleCreateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<TransactionRuleResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for createUser
     * @param userCreateRequestBody User object to be created. (None of these parameters are required, but the user object cannot be empty) (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createUserCall(UserCreateRequestBody userCreateRequestBody, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = userCreateRequestBody;

        // create path and map variables
        String localVarPath = "/users";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createUserValidateBeforeCall(UserCreateRequestBody userCreateRequestBody, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'userCreateRequestBody' is set
        if (userCreateRequestBody == null) {
            throw new ApiException("Missing the required parameter 'userCreateRequestBody' when calling createUser(Async)");
        }
        

        okhttp3.Call localVarCall = createUserCall(userCreateRequestBody, _callback);
        return localVarCall;

    }

    /**
     * Create user
     * Call this endpoint to create a new user. The MX Platform API will respond with the newly-created user object if successful. This endpoint accepts several parameters - id, metadata, and is_disabled. Disabling a user means that accounts and transactions associated with it will not be updated in the background by MX. It will also restrict access to that users data until they are no longer disabled. Users who are disabled for the entirety of an MX Platform API billing period will not be factored into that months bill.
     * @param userCreateRequestBody User object to be created. (None of these parameters are required, but the user object cannot be empty) (required)
     * @return UserResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public UserResponseBody createUser(UserCreateRequestBody userCreateRequestBody) throws ApiException {
        ApiResponse<UserResponseBody> localVarResp = createUserWithHttpInfo(userCreateRequestBody);
        return localVarResp.getData();
    }

    /**
     * Create user
     * Call this endpoint to create a new user. The MX Platform API will respond with the newly-created user object if successful. This endpoint accepts several parameters - id, metadata, and is_disabled. Disabling a user means that accounts and transactions associated with it will not be updated in the background by MX. It will also restrict access to that users data until they are no longer disabled. Users who are disabled for the entirety of an MX Platform API billing period will not be factored into that months bill.
     * @param userCreateRequestBody User object to be created. (None of these parameters are required, but the user object cannot be empty) (required)
     * @return ApiResponse&lt;UserResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<UserResponseBody> createUserWithHttpInfo(UserCreateRequestBody userCreateRequestBody) throws ApiException {
        okhttp3.Call localVarCall = createUserValidateBeforeCall(userCreateRequestBody, null);
        Type localVarReturnType = new TypeToken<UserResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create user (asynchronously)
     * Call this endpoint to create a new user. The MX Platform API will respond with the newly-created user object if successful. This endpoint accepts several parameters - id, metadata, and is_disabled. Disabling a user means that accounts and transactions associated with it will not be updated in the background by MX. It will also restrict access to that users data until they are no longer disabled. Users who are disabled for the entirety of an MX Platform API billing period will not be factored into that months bill.
     * @param userCreateRequestBody User object to be created. (None of these parameters are required, but the user object cannot be empty) (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createUserAsync(UserCreateRequestBody userCreateRequestBody, final ApiCallback<UserResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = createUserValidateBeforeCall(userCreateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<UserResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteCategory
     * @param categoryGuid The unique id for a &#x60;category&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteCategoryCall(String categoryGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/categories/{category_guid}"
            .replaceAll("\\{" + "category_guid" + "\\}", localVarApiClient.escapeString(categoryGuid.toString()))
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteCategoryValidateBeforeCall(String categoryGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'categoryGuid' is set
        if (categoryGuid == null) {
            throw new ApiException("Missing the required parameter 'categoryGuid' when calling deleteCategory(Async)");
        }
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling deleteCategory(Async)");
        }
        

        okhttp3.Call localVarCall = deleteCategoryCall(categoryGuid, userGuid, _callback);
        return localVarCall;

    }

    /**
     * Delete category
     * Use this endpoint to delete a specific custom category according to its unique GUID. The API will respond with an empty object and a status of &#x60;204 No Content&#x60;.
     * @param categoryGuid The unique id for a &#x60;category&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public void deleteCategory(String categoryGuid, String userGuid) throws ApiException {
        deleteCategoryWithHttpInfo(categoryGuid, userGuid);
    }

    /**
     * Delete category
     * Use this endpoint to delete a specific custom category according to its unique GUID. The API will respond with an empty object and a status of &#x60;204 No Content&#x60;.
     * @param categoryGuid The unique id for a &#x60;category&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteCategoryWithHttpInfo(String categoryGuid, String userGuid) throws ApiException {
        okhttp3.Call localVarCall = deleteCategoryValidateBeforeCall(categoryGuid, userGuid, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete category (asynchronously)
     * Use this endpoint to delete a specific custom category according to its unique GUID. The API will respond with an empty object and a status of &#x60;204 No Content&#x60;.
     * @param categoryGuid The unique id for a &#x60;category&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteCategoryAsync(String categoryGuid, String userGuid, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteCategoryValidateBeforeCall(categoryGuid, userGuid, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteManagedAccount
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteManagedAccountCall(String memberGuid, String userGuid, String accountGuid, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/managed_members/{member_guid}/accounts/{account_guid}"
            .replaceAll("\\{" + "member_guid" + "\\}", localVarApiClient.escapeString(memberGuid.toString()))
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()))
            .replaceAll("\\{" + "account_guid" + "\\}", localVarApiClient.escapeString(accountGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteManagedAccountValidateBeforeCall(String memberGuid, String userGuid, String accountGuid, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling deleteManagedAccount(Async)");
        }
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling deleteManagedAccount(Async)");
        }
        
        // verify the required parameter 'accountGuid' is set
        if (accountGuid == null) {
            throw new ApiException("Missing the required parameter 'accountGuid' when calling deleteManagedAccount(Async)");
        }
        

        okhttp3.Call localVarCall = deleteManagedAccountCall(memberGuid, userGuid, accountGuid, _callback);
        return localVarCall;

    }

    /**
     * Delete managed account
     * Use this endpoint to delete a partner-managed account according to its unique GUID. If successful, the API will respond with a status of &#x60;204 No Content&#x60;.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public void deleteManagedAccount(String memberGuid, String userGuid, String accountGuid) throws ApiException {
        deleteManagedAccountWithHttpInfo(memberGuid, userGuid, accountGuid);
    }

    /**
     * Delete managed account
     * Use this endpoint to delete a partner-managed account according to its unique GUID. If successful, the API will respond with a status of &#x60;204 No Content&#x60;.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteManagedAccountWithHttpInfo(String memberGuid, String userGuid, String accountGuid) throws ApiException {
        okhttp3.Call localVarCall = deleteManagedAccountValidateBeforeCall(memberGuid, userGuid, accountGuid, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete managed account (asynchronously)
     * Use this endpoint to delete a partner-managed account according to its unique GUID. If successful, the API will respond with a status of &#x60;204 No Content&#x60;.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteManagedAccountAsync(String memberGuid, String userGuid, String accountGuid, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteManagedAccountValidateBeforeCall(memberGuid, userGuid, accountGuid, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteManagedMember
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteManagedMemberCall(String memberGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/managed_members/{member_guid}"
            .replaceAll("\\{" + "member_guid" + "\\}", localVarApiClient.escapeString(memberGuid.toString()))
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteManagedMemberValidateBeforeCall(String memberGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling deleteManagedMember(Async)");
        }
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling deleteManagedMember(Async)");
        }
        

        okhttp3.Call localVarCall = deleteManagedMemberCall(memberGuid, userGuid, _callback);
        return localVarCall;

    }

    /**
     * Delete managed member
     * Use this endpoint to delete the specified partner-managed &#x60;member&#x60;. The endpoint will respond with a status of &#x60;204 No Content&#x60; without a resource.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public void deleteManagedMember(String memberGuid, String userGuid) throws ApiException {
        deleteManagedMemberWithHttpInfo(memberGuid, userGuid);
    }

    /**
     * Delete managed member
     * Use this endpoint to delete the specified partner-managed &#x60;member&#x60;. The endpoint will respond with a status of &#x60;204 No Content&#x60; without a resource.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteManagedMemberWithHttpInfo(String memberGuid, String userGuid) throws ApiException {
        okhttp3.Call localVarCall = deleteManagedMemberValidateBeforeCall(memberGuid, userGuid, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete managed member (asynchronously)
     * Use this endpoint to delete the specified partner-managed &#x60;member&#x60;. The endpoint will respond with a status of &#x60;204 No Content&#x60; without a resource.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteManagedMemberAsync(String memberGuid, String userGuid, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteManagedMemberValidateBeforeCall(memberGuid, userGuid, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteManagedTransaction
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param transactionGuid The unique id for a &#x60;transaction&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteManagedTransactionCall(String memberGuid, String userGuid, String transactionGuid, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/managed_members/{member_guid}/transactions/{transaction_guid}"
            .replaceAll("\\{" + "member_guid" + "\\}", localVarApiClient.escapeString(memberGuid.toString()))
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()))
            .replaceAll("\\{" + "transaction_guid" + "\\}", localVarApiClient.escapeString(transactionGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteManagedTransactionValidateBeforeCall(String memberGuid, String userGuid, String transactionGuid, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling deleteManagedTransaction(Async)");
        }
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling deleteManagedTransaction(Async)");
        }
        
        // verify the required parameter 'transactionGuid' is set
        if (transactionGuid == null) {
            throw new ApiException("Missing the required parameter 'transactionGuid' when calling deleteManagedTransaction(Async)");
        }
        

        okhttp3.Call localVarCall = deleteManagedTransactionCall(memberGuid, userGuid, transactionGuid, _callback);
        return localVarCall;

    }

    /**
     * Delete managed transaction
     * Use this endpoint to delete the specified partner-managed &#x60;transaction&#x60;. The endpoint will respond with a status of &#x60;204 No Content&#x60; without a resource.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param transactionGuid The unique id for a &#x60;transaction&#x60;. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public void deleteManagedTransaction(String memberGuid, String userGuid, String transactionGuid) throws ApiException {
        deleteManagedTransactionWithHttpInfo(memberGuid, userGuid, transactionGuid);
    }

    /**
     * Delete managed transaction
     * Use this endpoint to delete the specified partner-managed &#x60;transaction&#x60;. The endpoint will respond with a status of &#x60;204 No Content&#x60; without a resource.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param transactionGuid The unique id for a &#x60;transaction&#x60;. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteManagedTransactionWithHttpInfo(String memberGuid, String userGuid, String transactionGuid) throws ApiException {
        okhttp3.Call localVarCall = deleteManagedTransactionValidateBeforeCall(memberGuid, userGuid, transactionGuid, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete managed transaction (asynchronously)
     * Use this endpoint to delete the specified partner-managed &#x60;transaction&#x60;. The endpoint will respond with a status of &#x60;204 No Content&#x60; without a resource.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param transactionGuid The unique id for a &#x60;transaction&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteManagedTransactionAsync(String memberGuid, String userGuid, String transactionGuid, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteManagedTransactionValidateBeforeCall(memberGuid, userGuid, transactionGuid, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteMember
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteMemberCall(String memberGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/members/{member_guid}"
            .replaceAll("\\{" + "member_guid" + "\\}", localVarApiClient.escapeString(memberGuid.toString()))
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteMemberValidateBeforeCall(String memberGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling deleteMember(Async)");
        }
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling deleteMember(Async)");
        }
        

        okhttp3.Call localVarCall = deleteMemberCall(memberGuid, userGuid, _callback);
        return localVarCall;

    }

    /**
     * Delete member
     * Accessing this endpoint will permanently delete a member.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public void deleteMember(String memberGuid, String userGuid) throws ApiException {
        deleteMemberWithHttpInfo(memberGuid, userGuid);
    }

    /**
     * Delete member
     * Accessing this endpoint will permanently delete a member.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteMemberWithHttpInfo(String memberGuid, String userGuid) throws ApiException {
        okhttp3.Call localVarCall = deleteMemberValidateBeforeCall(memberGuid, userGuid, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete member (asynchronously)
     * Accessing this endpoint will permanently delete a member.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteMemberAsync(String memberGuid, String userGuid, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteMemberValidateBeforeCall(memberGuid, userGuid, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteTag
     * @param tagGuid The unique id for a &#x60;tag&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteTagCall(String tagGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/tags/{tag_guid}"
            .replaceAll("\\{" + "tag_guid" + "\\}", localVarApiClient.escapeString(tagGuid.toString()))
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteTagValidateBeforeCall(String tagGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'tagGuid' is set
        if (tagGuid == null) {
            throw new ApiException("Missing the required parameter 'tagGuid' when calling deleteTag(Async)");
        }
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling deleteTag(Async)");
        }
        

        okhttp3.Call localVarCall = deleteTagCall(tagGuid, userGuid, _callback);
        return localVarCall;

    }

    /**
     * Delete tag
     * Use this endpoint to permanently delete a specific tag based on its unique GUID. If successful, the API will respond with status of &#x60;204 No Content&#x60;.
     * @param tagGuid The unique id for a &#x60;tag&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public void deleteTag(String tagGuid, String userGuid) throws ApiException {
        deleteTagWithHttpInfo(tagGuid, userGuid);
    }

    /**
     * Delete tag
     * Use this endpoint to permanently delete a specific tag based on its unique GUID. If successful, the API will respond with status of &#x60;204 No Content&#x60;.
     * @param tagGuid The unique id for a &#x60;tag&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteTagWithHttpInfo(String tagGuid, String userGuid) throws ApiException {
        okhttp3.Call localVarCall = deleteTagValidateBeforeCall(tagGuid, userGuid, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete tag (asynchronously)
     * Use this endpoint to permanently delete a specific tag based on its unique GUID. If successful, the API will respond with status of &#x60;204 No Content&#x60;.
     * @param tagGuid The unique id for a &#x60;tag&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteTagAsync(String tagGuid, String userGuid, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteTagValidateBeforeCall(tagGuid, userGuid, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteTagging
     * @param taggingGuid The unique id for a &#x60;tagging&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteTaggingCall(String taggingGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/taggings/{tagging_guid}"
            .replaceAll("\\{" + "tagging_guid" + "\\}", localVarApiClient.escapeString(taggingGuid.toString()))
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteTaggingValidateBeforeCall(String taggingGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'taggingGuid' is set
        if (taggingGuid == null) {
            throw new ApiException("Missing the required parameter 'taggingGuid' when calling deleteTagging(Async)");
        }
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling deleteTagging(Async)");
        }
        

        okhttp3.Call localVarCall = deleteTaggingCall(taggingGuid, userGuid, _callback);
        return localVarCall;

    }

    /**
     * Delete tagging
     * Use this endpoint to delete a tagging according to its unique GUID. If successful, the API will respond with an empty body and a status of 204 NO Content.
     * @param taggingGuid The unique id for a &#x60;tagging&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public void deleteTagging(String taggingGuid, String userGuid) throws ApiException {
        deleteTaggingWithHttpInfo(taggingGuid, userGuid);
    }

    /**
     * Delete tagging
     * Use this endpoint to delete a tagging according to its unique GUID. If successful, the API will respond with an empty body and a status of 204 NO Content.
     * @param taggingGuid The unique id for a &#x60;tagging&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteTaggingWithHttpInfo(String taggingGuid, String userGuid) throws ApiException {
        okhttp3.Call localVarCall = deleteTaggingValidateBeforeCall(taggingGuid, userGuid, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete tagging (asynchronously)
     * Use this endpoint to delete a tagging according to its unique GUID. If successful, the API will respond with an empty body and a status of 204 NO Content.
     * @param taggingGuid The unique id for a &#x60;tagging&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteTaggingAsync(String taggingGuid, String userGuid, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteTaggingValidateBeforeCall(taggingGuid, userGuid, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteTransactionRule
     * @param transactionRuleGuid The unique id for a &#x60;transaction_rule&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteTransactionRuleCall(String transactionRuleGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/transaction_rules/{transaction_rule_guid}"
            .replaceAll("\\{" + "transaction_rule_guid" + "\\}", localVarApiClient.escapeString(transactionRuleGuid.toString()))
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteTransactionRuleValidateBeforeCall(String transactionRuleGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'transactionRuleGuid' is set
        if (transactionRuleGuid == null) {
            throw new ApiException("Missing the required parameter 'transactionRuleGuid' when calling deleteTransactionRule(Async)");
        }
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling deleteTransactionRule(Async)");
        }
        

        okhttp3.Call localVarCall = deleteTransactionRuleCall(transactionRuleGuid, userGuid, _callback);
        return localVarCall;

    }

    /**
     * Delete transaction rule
     * Use this endpoint to permanently delete a transaction rule based on its unique GUID.
     * @param transactionRuleGuid The unique id for a &#x60;transaction_rule&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public void deleteTransactionRule(String transactionRuleGuid, String userGuid) throws ApiException {
        deleteTransactionRuleWithHttpInfo(transactionRuleGuid, userGuid);
    }

    /**
     * Delete transaction rule
     * Use this endpoint to permanently delete a transaction rule based on its unique GUID.
     * @param transactionRuleGuid The unique id for a &#x60;transaction_rule&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteTransactionRuleWithHttpInfo(String transactionRuleGuid, String userGuid) throws ApiException {
        okhttp3.Call localVarCall = deleteTransactionRuleValidateBeforeCall(transactionRuleGuid, userGuid, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete transaction rule (asynchronously)
     * Use this endpoint to permanently delete a transaction rule based on its unique GUID.
     * @param transactionRuleGuid The unique id for a &#x60;transaction_rule&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteTransactionRuleAsync(String transactionRuleGuid, String userGuid, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteTransactionRuleValidateBeforeCall(transactionRuleGuid, userGuid, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteUser
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteUserCall(String userGuid, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}"
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteUserValidateBeforeCall(String userGuid, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling deleteUser(Async)");
        }
        

        okhttp3.Call localVarCall = deleteUserCall(userGuid, _callback);
        return localVarCall;

    }

    /**
     * Delete user
     * Use this endpoint to delete the specified &#x60;user&#x60;. The response will have a status of &#x60;204 No Content&#x60; without an object.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public void deleteUser(String userGuid) throws ApiException {
        deleteUserWithHttpInfo(userGuid);
    }

    /**
     * Delete user
     * Use this endpoint to delete the specified &#x60;user&#x60;. The response will have a status of &#x60;204 No Content&#x60; without an object.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteUserWithHttpInfo(String userGuid) throws ApiException {
        okhttp3.Call localVarCall = deleteUserValidateBeforeCall(userGuid, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete user (asynchronously)
     * Use this endpoint to delete the specified &#x60;user&#x60;. The response will have a status of &#x60;204 No Content&#x60; without an object.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteUserAsync(String userGuid, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteUserValidateBeforeCall(userGuid, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for downloadStatementPDF
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param statementGuid The unique id for a &#x60;statement&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call downloadStatementPDFCall(String memberGuid, String statementGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/members/{member_guid}/statements/{statement_guid}.pdf"
            .replaceAll("\\{" + "member_guid" + "\\}", localVarApiClient.escapeString(memberGuid.toString()))
            .replaceAll("\\{" + "statement_guid" + "\\}", localVarApiClient.escapeString(statementGuid.toString()))
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+pdf"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call downloadStatementPDFValidateBeforeCall(String memberGuid, String statementGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling downloadStatementPDF(Async)");
        }
        
        // verify the required parameter 'statementGuid' is set
        if (statementGuid == null) {
            throw new ApiException("Missing the required parameter 'statementGuid' when calling downloadStatementPDF(Async)");
        }
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling downloadStatementPDF(Async)");
        }
        

        okhttp3.Call localVarCall = downloadStatementPDFCall(memberGuid, statementGuid, userGuid, _callback);
        return localVarCall;

    }

    /**
     * Download statement pdf
     * Use this endpoint to download a specified statement PDF.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param statementGuid The unique id for a &#x60;statement&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public File downloadStatementPDF(String memberGuid, String statementGuid, String userGuid) throws ApiException {
        ApiResponse<File> localVarResp = downloadStatementPDFWithHttpInfo(memberGuid, statementGuid, userGuid);
        return localVarResp.getData();
    }

    /**
     * Download statement pdf
     * Use this endpoint to download a specified statement PDF.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param statementGuid The unique id for a &#x60;statement&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<File> downloadStatementPDFWithHttpInfo(String memberGuid, String statementGuid, String userGuid) throws ApiException {
        okhttp3.Call localVarCall = downloadStatementPDFValidateBeforeCall(memberGuid, statementGuid, userGuid, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Download statement pdf (asynchronously)
     * Use this endpoint to download a specified statement PDF.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param statementGuid The unique id for a &#x60;statement&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call downloadStatementPDFAsync(String memberGuid, String statementGuid, String userGuid, final ApiCallback<File> _callback) throws ApiException {

        okhttp3.Call localVarCall = downloadStatementPDFValidateBeforeCall(memberGuid, statementGuid, userGuid, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for enhanceTransactions
     * @param enhanceTransactionsRequestBody Transaction object to be enhanced (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call enhanceTransactionsCall(EnhanceTransactionsRequestBody enhanceTransactionsRequestBody, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = enhanceTransactionsRequestBody;

        // create path and map variables
        String localVarPath = "/transactions/enhance";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call enhanceTransactionsValidateBeforeCall(EnhanceTransactionsRequestBody enhanceTransactionsRequestBody, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'enhanceTransactionsRequestBody' is set
        if (enhanceTransactionsRequestBody == null) {
            throw new ApiException("Missing the required parameter 'enhanceTransactionsRequestBody' when calling enhanceTransactions(Async)");
        }
        

        okhttp3.Call localVarCall = enhanceTransactionsCall(enhanceTransactionsRequestBody, _callback);
        return localVarCall;

    }

    /**
     * Enhance transactions
     * Use this endpoint to categorize, cleanse, and classify transactions. These transactions are not persisted or stored on the MX platform.
     * @param enhanceTransactionsRequestBody Transaction object to be enhanced (required)
     * @return EnhanceTransactionsResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public EnhanceTransactionsResponseBody enhanceTransactions(EnhanceTransactionsRequestBody enhanceTransactionsRequestBody) throws ApiException {
        ApiResponse<EnhanceTransactionsResponseBody> localVarResp = enhanceTransactionsWithHttpInfo(enhanceTransactionsRequestBody);
        return localVarResp.getData();
    }

    /**
     * Enhance transactions
     * Use this endpoint to categorize, cleanse, and classify transactions. These transactions are not persisted or stored on the MX platform.
     * @param enhanceTransactionsRequestBody Transaction object to be enhanced (required)
     * @return ApiResponse&lt;EnhanceTransactionsResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<EnhanceTransactionsResponseBody> enhanceTransactionsWithHttpInfo(EnhanceTransactionsRequestBody enhanceTransactionsRequestBody) throws ApiException {
        okhttp3.Call localVarCall = enhanceTransactionsValidateBeforeCall(enhanceTransactionsRequestBody, null);
        Type localVarReturnType = new TypeToken<EnhanceTransactionsResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Enhance transactions (asynchronously)
     * Use this endpoint to categorize, cleanse, and classify transactions. These transactions are not persisted or stored on the MX platform.
     * @param enhanceTransactionsRequestBody Transaction object to be enhanced (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call enhanceTransactionsAsync(EnhanceTransactionsRequestBody enhanceTransactionsRequestBody, final ApiCallback<EnhanceTransactionsResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = enhanceTransactionsValidateBeforeCall(enhanceTransactionsRequestBody, _callback);
        Type localVarReturnType = new TypeToken<EnhanceTransactionsResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for extendHistory
     * @param memberGuid The unique identifier for a &#x60;member&#x60;. (required)
     * @param userGuid The unique identifier for a &#x60;user&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call extendHistoryCall(String memberGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/members/{member_guid}/extend_history"
            .replaceAll("\\{" + "member_guid" + "\\}", localVarApiClient.escapeString(memberGuid.toString()))
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call extendHistoryValidateBeforeCall(String memberGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling extendHistory(Async)");
        }
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling extendHistory(Async)");
        }
        

        okhttp3.Call localVarCall = extendHistoryCall(memberGuid, userGuid, _callback);
        return localVarCall;

    }

    /**
     * Extend history
     * Some institutions allow developers to access an extended transaction history with up to 24 months of data associated with a particular member. The process for fetching and then reading this extended transaction history is much like standard aggregation, and it may trigger multi-factor authentication.
     * @param memberGuid The unique identifier for a &#x60;member&#x60;. (required)
     * @param userGuid The unique identifier for a &#x60;user&#x60;. (required)
     * @return MemberResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public MemberResponseBody extendHistory(String memberGuid, String userGuid) throws ApiException {
        ApiResponse<MemberResponseBody> localVarResp = extendHistoryWithHttpInfo(memberGuid, userGuid);
        return localVarResp.getData();
    }

    /**
     * Extend history
     * Some institutions allow developers to access an extended transaction history with up to 24 months of data associated with a particular member. The process for fetching and then reading this extended transaction history is much like standard aggregation, and it may trigger multi-factor authentication.
     * @param memberGuid The unique identifier for a &#x60;member&#x60;. (required)
     * @param userGuid The unique identifier for a &#x60;user&#x60;. (required)
     * @return ApiResponse&lt;MemberResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MemberResponseBody> extendHistoryWithHttpInfo(String memberGuid, String userGuid) throws ApiException {
        okhttp3.Call localVarCall = extendHistoryValidateBeforeCall(memberGuid, userGuid, null);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Extend history (asynchronously)
     * Some institutions allow developers to access an extended transaction history with up to 24 months of data associated with a particular member. The process for fetching and then reading this extended transaction history is much like standard aggregation, and it may trigger multi-factor authentication.
     * @param memberGuid The unique identifier for a &#x60;member&#x60;. (required)
     * @param userGuid The unique identifier for a &#x60;user&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call extendHistoryAsync(String memberGuid, String userGuid, final ApiCallback<MemberResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = extendHistoryValidateBeforeCall(memberGuid, userGuid, _callback);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for fetchStatements
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call fetchStatementsCall(String memberGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/members/{member_guid}/fetch_statements"
            .replaceAll("\\{" + "member_guid" + "\\}", localVarApiClient.escapeString(memberGuid.toString()))
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call fetchStatementsValidateBeforeCall(String memberGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling fetchStatements(Async)");
        }
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling fetchStatements(Async)");
        }
        

        okhttp3.Call localVarCall = fetchStatementsCall(memberGuid, userGuid, _callback);
        return localVarCall;

    }

    /**
     * Fetch statements
     * Use this endpoint to fetch the statements associated with a particular member.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return MemberResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public MemberResponseBody fetchStatements(String memberGuid, String userGuid) throws ApiException {
        ApiResponse<MemberResponseBody> localVarResp = fetchStatementsWithHttpInfo(memberGuid, userGuid);
        return localVarResp.getData();
    }

    /**
     * Fetch statements
     * Use this endpoint to fetch the statements associated with a particular member.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return ApiResponse&lt;MemberResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MemberResponseBody> fetchStatementsWithHttpInfo(String memberGuid, String userGuid) throws ApiException {
        okhttp3.Call localVarCall = fetchStatementsValidateBeforeCall(memberGuid, userGuid, null);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Fetch statements (asynchronously)
     * Use this endpoint to fetch the statements associated with a particular member.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call fetchStatementsAsync(String memberGuid, String userGuid, final ApiCallback<MemberResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = fetchStatementsValidateBeforeCall(memberGuid, userGuid, _callback);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for identifyMember
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call identifyMemberCall(String memberGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/members/{member_guid}/identify"
            .replaceAll("\\{" + "member_guid" + "\\}", localVarApiClient.escapeString(memberGuid.toString()))
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call identifyMemberValidateBeforeCall(String memberGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling identifyMember(Async)");
        }
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling identifyMember(Async)");
        }
        

        okhttp3.Call localVarCall = identifyMemberCall(memberGuid, userGuid, _callback);
        return localVarCall;

    }

    /**
     * Identify member
     * The identify endpoint begins an identification process for an already-existing member.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return MemberResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public MemberResponseBody identifyMember(String memberGuid, String userGuid) throws ApiException {
        ApiResponse<MemberResponseBody> localVarResp = identifyMemberWithHttpInfo(memberGuid, userGuid);
        return localVarResp.getData();
    }

    /**
     * Identify member
     * The identify endpoint begins an identification process for an already-existing member.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return ApiResponse&lt;MemberResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MemberResponseBody> identifyMemberWithHttpInfo(String memberGuid, String userGuid) throws ApiException {
        okhttp3.Call localVarCall = identifyMemberValidateBeforeCall(memberGuid, userGuid, null);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Identify member (asynchronously)
     * The identify endpoint begins an identification process for an already-existing member.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call identifyMemberAsync(String memberGuid, String userGuid, final ApiCallback<MemberResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = identifyMemberValidateBeforeCall(memberGuid, userGuid, _callback);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listAccountNumbersByAccount
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listAccountNumbersByAccountCall(String accountGuid, String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/accounts/{account_guid}/account_numbers"
            .replaceAll("\\{" + "account_guid" + "\\}", localVarApiClient.escapeString(accountGuid.toString()))
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listAccountNumbersByAccountValidateBeforeCall(String accountGuid, String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'accountGuid' is set
        if (accountGuid == null) {
            throw new ApiException("Missing the required parameter 'accountGuid' when calling listAccountNumbersByAccount(Async)");
        }
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listAccountNumbersByAccount(Async)");
        }
        

        okhttp3.Call localVarCall = listAccountNumbersByAccountCall(accountGuid, userGuid, page, recordsPerPage, _callback);
        return localVarCall;

    }

    /**
     * List account numbers by account
     * This endpoint returns a list of account numbers associated with the specified &#x60;account&#x60;.
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return AccountNumbersResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public AccountNumbersResponseBody listAccountNumbersByAccount(String accountGuid, String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<AccountNumbersResponseBody> localVarResp = listAccountNumbersByAccountWithHttpInfo(accountGuid, userGuid, page, recordsPerPage);
        return localVarResp.getData();
    }

    /**
     * List account numbers by account
     * This endpoint returns a list of account numbers associated with the specified &#x60;account&#x60;.
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return ApiResponse&lt;AccountNumbersResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<AccountNumbersResponseBody> listAccountNumbersByAccountWithHttpInfo(String accountGuid, String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        okhttp3.Call localVarCall = listAccountNumbersByAccountValidateBeforeCall(accountGuid, userGuid, page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<AccountNumbersResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List account numbers by account (asynchronously)
     * This endpoint returns a list of account numbers associated with the specified &#x60;account&#x60;.
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listAccountNumbersByAccountAsync(String accountGuid, String userGuid, Integer page, Integer recordsPerPage, final ApiCallback<AccountNumbersResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listAccountNumbersByAccountValidateBeforeCall(accountGuid, userGuid, page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<AccountNumbersResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listAccountNumbersByMember
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listAccountNumbersByMemberCall(String memberGuid, String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/members/{member_guid}/account_numbers"
            .replaceAll("\\{" + "member_guid" + "\\}", localVarApiClient.escapeString(memberGuid.toString()))
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listAccountNumbersByMemberValidateBeforeCall(String memberGuid, String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling listAccountNumbersByMember(Async)");
        }
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listAccountNumbersByMember(Async)");
        }
        

        okhttp3.Call localVarCall = listAccountNumbersByMemberCall(memberGuid, userGuid, page, recordsPerPage, _callback);
        return localVarCall;

    }

    /**
     * List account numbers by member
     * This endpoint returns a list of account numbers associated with the specified &#x60;member&#x60;.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return AccountNumbersResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public AccountNumbersResponseBody listAccountNumbersByMember(String memberGuid, String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<AccountNumbersResponseBody> localVarResp = listAccountNumbersByMemberWithHttpInfo(memberGuid, userGuid, page, recordsPerPage);
        return localVarResp.getData();
    }

    /**
     * List account numbers by member
     * This endpoint returns a list of account numbers associated with the specified &#x60;member&#x60;.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return ApiResponse&lt;AccountNumbersResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<AccountNumbersResponseBody> listAccountNumbersByMemberWithHttpInfo(String memberGuid, String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        okhttp3.Call localVarCall = listAccountNumbersByMemberValidateBeforeCall(memberGuid, userGuid, page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<AccountNumbersResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List account numbers by member (asynchronously)
     * This endpoint returns a list of account numbers associated with the specified &#x60;member&#x60;.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listAccountNumbersByMemberAsync(String memberGuid, String userGuid, Integer page, Integer recordsPerPage, final ApiCallback<AccountNumbersResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listAccountNumbersByMemberValidateBeforeCall(memberGuid, userGuid, page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<AccountNumbersResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listAccountOwnersByMember
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listAccountOwnersByMemberCall(String memberGuid, String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/members/{member_guid}/account_owners"
            .replaceAll("\\{" + "member_guid" + "\\}", localVarApiClient.escapeString(memberGuid.toString()))
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listAccountOwnersByMemberValidateBeforeCall(String memberGuid, String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling listAccountOwnersByMember(Async)");
        }
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listAccountOwnersByMember(Async)");
        }
        

        okhttp3.Call localVarCall = listAccountOwnersByMemberCall(memberGuid, userGuid, page, recordsPerPage, _callback);
        return localVarCall;

    }

    /**
     * List account owners by member
     * This endpoint returns an array with information about every account associated with a particular member.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return AccountOwnersResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public AccountOwnersResponseBody listAccountOwnersByMember(String memberGuid, String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<AccountOwnersResponseBody> localVarResp = listAccountOwnersByMemberWithHttpInfo(memberGuid, userGuid, page, recordsPerPage);
        return localVarResp.getData();
    }

    /**
     * List account owners by member
     * This endpoint returns an array with information about every account associated with a particular member.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return ApiResponse&lt;AccountOwnersResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<AccountOwnersResponseBody> listAccountOwnersByMemberWithHttpInfo(String memberGuid, String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        okhttp3.Call localVarCall = listAccountOwnersByMemberValidateBeforeCall(memberGuid, userGuid, page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<AccountOwnersResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List account owners by member (asynchronously)
     * This endpoint returns an array with information about every account associated with a particular member.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listAccountOwnersByMemberAsync(String memberGuid, String userGuid, Integer page, Integer recordsPerPage, final ApiCallback<AccountOwnersResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listAccountOwnersByMemberValidateBeforeCall(memberGuid, userGuid, page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<AccountOwnersResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listCategories
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listCategoriesCall(String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/categories"
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listCategoriesValidateBeforeCall(String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listCategories(Async)");
        }
        

        okhttp3.Call localVarCall = listCategoriesCall(userGuid, page, recordsPerPage, _callback);
        return localVarCall;

    }

    /**
     * List categories
     * Use this endpoint to list all categories associated with a &#x60;user&#x60;, including both default and custom categories.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return CategoriesResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public CategoriesResponseBody listCategories(String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<CategoriesResponseBody> localVarResp = listCategoriesWithHttpInfo(userGuid, page, recordsPerPage);
        return localVarResp.getData();
    }

    /**
     * List categories
     * Use this endpoint to list all categories associated with a &#x60;user&#x60;, including both default and custom categories.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return ApiResponse&lt;CategoriesResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CategoriesResponseBody> listCategoriesWithHttpInfo(String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        okhttp3.Call localVarCall = listCategoriesValidateBeforeCall(userGuid, page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<CategoriesResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List categories (asynchronously)
     * Use this endpoint to list all categories associated with a &#x60;user&#x60;, including both default and custom categories.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listCategoriesAsync(String userGuid, Integer page, Integer recordsPerPage, final ApiCallback<CategoriesResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listCategoriesValidateBeforeCall(userGuid, page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<CategoriesResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listDefaultCategories
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listDefaultCategoriesCall(Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/categories/default";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listDefaultCategoriesValidateBeforeCall(Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = listDefaultCategoriesCall(page, recordsPerPage, _callback);
        return localVarCall;

    }

    /**
     * List default categories
     * Use this endpoint to retrieve a list of all the default categories and subcategories offered within the MX Platform API. In other words, each item in the returned list will have its &#x60;is_default&#x60; field set to &#x60;true&#x60;. There are currently 119 default categories and subcategories. Both the _list default categories_ and _list default categories by user_ endpoints return the same results. The different routes are provided for convenience.
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return CategoriesResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public CategoriesResponseBody listDefaultCategories(Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<CategoriesResponseBody> localVarResp = listDefaultCategoriesWithHttpInfo(page, recordsPerPage);
        return localVarResp.getData();
    }

    /**
     * List default categories
     * Use this endpoint to retrieve a list of all the default categories and subcategories offered within the MX Platform API. In other words, each item in the returned list will have its &#x60;is_default&#x60; field set to &#x60;true&#x60;. There are currently 119 default categories and subcategories. Both the _list default categories_ and _list default categories by user_ endpoints return the same results. The different routes are provided for convenience.
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return ApiResponse&lt;CategoriesResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CategoriesResponseBody> listDefaultCategoriesWithHttpInfo(Integer page, Integer recordsPerPage) throws ApiException {
        okhttp3.Call localVarCall = listDefaultCategoriesValidateBeforeCall(page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<CategoriesResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List default categories (asynchronously)
     * Use this endpoint to retrieve a list of all the default categories and subcategories offered within the MX Platform API. In other words, each item in the returned list will have its &#x60;is_default&#x60; field set to &#x60;true&#x60;. There are currently 119 default categories and subcategories. Both the _list default categories_ and _list default categories by user_ endpoints return the same results. The different routes are provided for convenience.
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listDefaultCategoriesAsync(Integer page, Integer recordsPerPage, final ApiCallback<CategoriesResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listDefaultCategoriesValidateBeforeCall(page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<CategoriesResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listDefaultCategoriesByUser
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listDefaultCategoriesByUserCall(String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/categories/default"
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listDefaultCategoriesByUserValidateBeforeCall(String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listDefaultCategoriesByUser(Async)");
        }
        

        okhttp3.Call localVarCall = listDefaultCategoriesByUserCall(userGuid, page, recordsPerPage, _callback);
        return localVarCall;

    }

    /**
     * List default categories by user
     * Use this endpoint to retrieve a list of all the default categories and subcategories, scoped by user, offered within the MX Platform API. In other words, each item in the returned list will have its &#x60;is_default&#x60; field set to &#x60;true&#x60;. There are currently 119 default categories and subcategories. Both the _list default categories_ and _list default categories by user_ endpoints return the same results. The different routes are provided for convenience.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return CategoriesResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public CategoriesResponseBody listDefaultCategoriesByUser(String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<CategoriesResponseBody> localVarResp = listDefaultCategoriesByUserWithHttpInfo(userGuid, page, recordsPerPage);
        return localVarResp.getData();
    }

    /**
     * List default categories by user
     * Use this endpoint to retrieve a list of all the default categories and subcategories, scoped by user, offered within the MX Platform API. In other words, each item in the returned list will have its &#x60;is_default&#x60; field set to &#x60;true&#x60;. There are currently 119 default categories and subcategories. Both the _list default categories_ and _list default categories by user_ endpoints return the same results. The different routes are provided for convenience.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return ApiResponse&lt;CategoriesResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CategoriesResponseBody> listDefaultCategoriesByUserWithHttpInfo(String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        okhttp3.Call localVarCall = listDefaultCategoriesByUserValidateBeforeCall(userGuid, page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<CategoriesResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List default categories by user (asynchronously)
     * Use this endpoint to retrieve a list of all the default categories and subcategories, scoped by user, offered within the MX Platform API. In other words, each item in the returned list will have its &#x60;is_default&#x60; field set to &#x60;true&#x60;. There are currently 119 default categories and subcategories. Both the _list default categories_ and _list default categories by user_ endpoints return the same results. The different routes are provided for convenience.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listDefaultCategoriesByUserAsync(String userGuid, Integer page, Integer recordsPerPage, final ApiCallback<CategoriesResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listDefaultCategoriesByUserValidateBeforeCall(userGuid, page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<CategoriesResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listFavoriteInstitutions
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listFavoriteInstitutionsCall(Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/institutions/favorites";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listFavoriteInstitutionsValidateBeforeCall(Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = listFavoriteInstitutionsCall(page, recordsPerPage, _callback);
        return localVarCall;

    }

    /**
     * List favorite institutions
     * This endpoint returns a paginated list containing institutions that have been set as the partner’s favorites, sorted by popularity. Please contact MX to set a list of favorites.
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return InstitutionsResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public InstitutionsResponseBody listFavoriteInstitutions(Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<InstitutionsResponseBody> localVarResp = listFavoriteInstitutionsWithHttpInfo(page, recordsPerPage);
        return localVarResp.getData();
    }

    /**
     * List favorite institutions
     * This endpoint returns a paginated list containing institutions that have been set as the partner’s favorites, sorted by popularity. Please contact MX to set a list of favorites.
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return ApiResponse&lt;InstitutionsResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<InstitutionsResponseBody> listFavoriteInstitutionsWithHttpInfo(Integer page, Integer recordsPerPage) throws ApiException {
        okhttp3.Call localVarCall = listFavoriteInstitutionsValidateBeforeCall(page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<InstitutionsResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List favorite institutions (asynchronously)
     * This endpoint returns a paginated list containing institutions that have been set as the partner’s favorites, sorted by popularity. Please contact MX to set a list of favorites.
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listFavoriteInstitutionsAsync(Integer page, Integer recordsPerPage, final ApiCallback<InstitutionsResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listFavoriteInstitutionsValidateBeforeCall(page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<InstitutionsResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listHoldings
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param fromDate Filter holdings from this date. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param toDate Filter holdings to this date. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listHoldingsCall(String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/holdings"
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (fromDate != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("from_date", fromDate));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        if (toDate != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("to_date", toDate));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listHoldingsValidateBeforeCall(String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listHoldings(Async)");
        }
        

        okhttp3.Call localVarCall = listHoldingsCall(userGuid, fromDate, page, recordsPerPage, toDate, _callback);
        return localVarCall;

    }

    /**
     * List holdings
     * This endpoint returns all holdings associated with the specified &#x60;user&#x60; across all accounts and members.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param fromDate Filter holdings from this date. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param toDate Filter holdings to this date. (optional)
     * @return HoldingsResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public HoldingsResponseBody listHoldings(String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate) throws ApiException {
        ApiResponse<HoldingsResponseBody> localVarResp = listHoldingsWithHttpInfo(userGuid, fromDate, page, recordsPerPage, toDate);
        return localVarResp.getData();
    }

    /**
     * List holdings
     * This endpoint returns all holdings associated with the specified &#x60;user&#x60; across all accounts and members.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param fromDate Filter holdings from this date. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param toDate Filter holdings to this date. (optional)
     * @return ApiResponse&lt;HoldingsResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<HoldingsResponseBody> listHoldingsWithHttpInfo(String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate) throws ApiException {
        okhttp3.Call localVarCall = listHoldingsValidateBeforeCall(userGuid, fromDate, page, recordsPerPage, toDate, null);
        Type localVarReturnType = new TypeToken<HoldingsResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List holdings (asynchronously)
     * This endpoint returns all holdings associated with the specified &#x60;user&#x60; across all accounts and members.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param fromDate Filter holdings from this date. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param toDate Filter holdings to this date. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listHoldingsAsync(String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate, final ApiCallback<HoldingsResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listHoldingsValidateBeforeCall(userGuid, fromDate, page, recordsPerPage, toDate, _callback);
        Type localVarReturnType = new TypeToken<HoldingsResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listHoldingsByMember
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param fromDate Filter holdings from this date. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param toDate Filter holdings to this date. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listHoldingsByMemberCall(String memberGuid, String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/members/{member_guid}/holdings"
            .replaceAll("\\{" + "member_guid" + "\\}", localVarApiClient.escapeString(memberGuid.toString()))
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (fromDate != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("from_date", fromDate));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        if (toDate != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("to_date", toDate));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listHoldingsByMemberValidateBeforeCall(String memberGuid, String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling listHoldingsByMember(Async)");
        }
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listHoldingsByMember(Async)");
        }
        

        okhttp3.Call localVarCall = listHoldingsByMemberCall(memberGuid, userGuid, fromDate, page, recordsPerPage, toDate, _callback);
        return localVarCall;

    }

    /**
     * List holdings by member
     * This endpoint returns all holdings associated with the specified &#x60;member&#x60; across all accounts.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param fromDate Filter holdings from this date. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param toDate Filter holdings to this date. (optional)
     * @return HoldingsResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public HoldingsResponseBody listHoldingsByMember(String memberGuid, String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate) throws ApiException {
        ApiResponse<HoldingsResponseBody> localVarResp = listHoldingsByMemberWithHttpInfo(memberGuid, userGuid, fromDate, page, recordsPerPage, toDate);
        return localVarResp.getData();
    }

    /**
     * List holdings by member
     * This endpoint returns all holdings associated with the specified &#x60;member&#x60; across all accounts.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param fromDate Filter holdings from this date. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param toDate Filter holdings to this date. (optional)
     * @return ApiResponse&lt;HoldingsResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<HoldingsResponseBody> listHoldingsByMemberWithHttpInfo(String memberGuid, String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate) throws ApiException {
        okhttp3.Call localVarCall = listHoldingsByMemberValidateBeforeCall(memberGuid, userGuid, fromDate, page, recordsPerPage, toDate, null);
        Type localVarReturnType = new TypeToken<HoldingsResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List holdings by member (asynchronously)
     * This endpoint returns all holdings associated with the specified &#x60;member&#x60; across all accounts.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param fromDate Filter holdings from this date. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param toDate Filter holdings to this date. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listHoldingsByMemberAsync(String memberGuid, String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate, final ApiCallback<HoldingsResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listHoldingsByMemberValidateBeforeCall(memberGuid, userGuid, fromDate, page, recordsPerPage, toDate, _callback);
        Type localVarReturnType = new TypeToken<HoldingsResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listInstitutionCredentials
     * @param institutionCode The institution_code of the institution. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listInstitutionCredentialsCall(String institutionCode, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/institutions/{institution_code}/credentials"
            .replaceAll("\\{" + "institution_code" + "\\}", localVarApiClient.escapeString(institutionCode.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listInstitutionCredentialsValidateBeforeCall(String institutionCode, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'institutionCode' is set
        if (institutionCode == null) {
            throw new ApiException("Missing the required parameter 'institutionCode' when calling listInstitutionCredentials(Async)");
        }
        

        okhttp3.Call localVarCall = listInstitutionCredentialsCall(institutionCode, page, recordsPerPage, _callback);
        return localVarCall;

    }

    /**
     * List institution credentials
     * Use this endpoint to see which credentials will be needed to create a member for a specific institution.
     * @param institutionCode The institution_code of the institution. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return CredentialsResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public CredentialsResponseBody listInstitutionCredentials(String institutionCode, Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<CredentialsResponseBody> localVarResp = listInstitutionCredentialsWithHttpInfo(institutionCode, page, recordsPerPage);
        return localVarResp.getData();
    }

    /**
     * List institution credentials
     * Use this endpoint to see which credentials will be needed to create a member for a specific institution.
     * @param institutionCode The institution_code of the institution. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return ApiResponse&lt;CredentialsResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CredentialsResponseBody> listInstitutionCredentialsWithHttpInfo(String institutionCode, Integer page, Integer recordsPerPage) throws ApiException {
        okhttp3.Call localVarCall = listInstitutionCredentialsValidateBeforeCall(institutionCode, page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<CredentialsResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List institution credentials (asynchronously)
     * Use this endpoint to see which credentials will be needed to create a member for a specific institution.
     * @param institutionCode The institution_code of the institution. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listInstitutionCredentialsAsync(String institutionCode, Integer page, Integer recordsPerPage, final ApiCallback<CredentialsResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listInstitutionCredentialsValidateBeforeCall(institutionCode, page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<CredentialsResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listInstitutions
     * @param name This will list only institutions in which the appended string appears. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param supportsAccountIdentification Filter only institutions which support account identification. (optional)
     * @param supportsAccountStatement Filter only institutions which support account statements. (optional)
     * @param supportsAccountVerification Filter only institutions which support account verification. (optional)
     * @param supportsTransactionHistory Filter only institutions which support extended transaction history. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listInstitutionsCall(String name, Integer page, Integer recordsPerPage, Boolean supportsAccountIdentification, Boolean supportsAccountStatement, Boolean supportsAccountVerification, Boolean supportsTransactionHistory, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/institutions";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (name != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("name", name));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        if (supportsAccountIdentification != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("supports_account_identification", supportsAccountIdentification));
        }

        if (supportsAccountStatement != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("supports_account_statement", supportsAccountStatement));
        }

        if (supportsAccountVerification != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("supports_account_verification", supportsAccountVerification));
        }

        if (supportsTransactionHistory != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("supports_transaction_history", supportsTransactionHistory));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listInstitutionsValidateBeforeCall(String name, Integer page, Integer recordsPerPage, Boolean supportsAccountIdentification, Boolean supportsAccountStatement, Boolean supportsAccountVerification, Boolean supportsTransactionHistory, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = listInstitutionsCall(name, page, recordsPerPage, supportsAccountIdentification, supportsAccountStatement, supportsAccountVerification, supportsTransactionHistory, _callback);
        return localVarCall;

    }

    /**
     * List institutions
     * This endpoint returns a list of institutions based on the specified search term or parameter.
     * @param name This will list only institutions in which the appended string appears. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param supportsAccountIdentification Filter only institutions which support account identification. (optional)
     * @param supportsAccountStatement Filter only institutions which support account statements. (optional)
     * @param supportsAccountVerification Filter only institutions which support account verification. (optional)
     * @param supportsTransactionHistory Filter only institutions which support extended transaction history. (optional)
     * @return InstitutionsResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public InstitutionsResponseBody listInstitutions(String name, Integer page, Integer recordsPerPage, Boolean supportsAccountIdentification, Boolean supportsAccountStatement, Boolean supportsAccountVerification, Boolean supportsTransactionHistory) throws ApiException {
        ApiResponse<InstitutionsResponseBody> localVarResp = listInstitutionsWithHttpInfo(name, page, recordsPerPage, supportsAccountIdentification, supportsAccountStatement, supportsAccountVerification, supportsTransactionHistory);
        return localVarResp.getData();
    }

    /**
     * List institutions
     * This endpoint returns a list of institutions based on the specified search term or parameter.
     * @param name This will list only institutions in which the appended string appears. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param supportsAccountIdentification Filter only institutions which support account identification. (optional)
     * @param supportsAccountStatement Filter only institutions which support account statements. (optional)
     * @param supportsAccountVerification Filter only institutions which support account verification. (optional)
     * @param supportsTransactionHistory Filter only institutions which support extended transaction history. (optional)
     * @return ApiResponse&lt;InstitutionsResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<InstitutionsResponseBody> listInstitutionsWithHttpInfo(String name, Integer page, Integer recordsPerPage, Boolean supportsAccountIdentification, Boolean supportsAccountStatement, Boolean supportsAccountVerification, Boolean supportsTransactionHistory) throws ApiException {
        okhttp3.Call localVarCall = listInstitutionsValidateBeforeCall(name, page, recordsPerPage, supportsAccountIdentification, supportsAccountStatement, supportsAccountVerification, supportsTransactionHistory, null);
        Type localVarReturnType = new TypeToken<InstitutionsResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List institutions (asynchronously)
     * This endpoint returns a list of institutions based on the specified search term or parameter.
     * @param name This will list only institutions in which the appended string appears. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param supportsAccountIdentification Filter only institutions which support account identification. (optional)
     * @param supportsAccountStatement Filter only institutions which support account statements. (optional)
     * @param supportsAccountVerification Filter only institutions which support account verification. (optional)
     * @param supportsTransactionHistory Filter only institutions which support extended transaction history. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listInstitutionsAsync(String name, Integer page, Integer recordsPerPage, Boolean supportsAccountIdentification, Boolean supportsAccountStatement, Boolean supportsAccountVerification, Boolean supportsTransactionHistory, final ApiCallback<InstitutionsResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listInstitutionsValidateBeforeCall(name, page, recordsPerPage, supportsAccountIdentification, supportsAccountStatement, supportsAccountVerification, supportsTransactionHistory, _callback);
        Type localVarReturnType = new TypeToken<InstitutionsResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listManagedAccounts
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listManagedAccountsCall(String userGuid, String memberGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/managed_members/{member_guid}/accounts"
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()))
            .replaceAll("\\{" + "member_guid" + "\\}", localVarApiClient.escapeString(memberGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listManagedAccountsValidateBeforeCall(String userGuid, String memberGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listManagedAccounts(Async)");
        }
        
        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling listManagedAccounts(Async)");
        }
        

        okhttp3.Call localVarCall = listManagedAccountsCall(userGuid, memberGuid, page, recordsPerPage, _callback);
        return localVarCall;

    }

    /**
     * List managed accounts
     * Use this endpoint to retrieve a list of all the partner-managed accounts associated with the given partner-manage member.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return AccountsResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public AccountsResponseBody listManagedAccounts(String userGuid, String memberGuid, Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<AccountsResponseBody> localVarResp = listManagedAccountsWithHttpInfo(userGuid, memberGuid, page, recordsPerPage);
        return localVarResp.getData();
    }

    /**
     * List managed accounts
     * Use this endpoint to retrieve a list of all the partner-managed accounts associated with the given partner-manage member.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return ApiResponse&lt;AccountsResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<AccountsResponseBody> listManagedAccountsWithHttpInfo(String userGuid, String memberGuid, Integer page, Integer recordsPerPage) throws ApiException {
        okhttp3.Call localVarCall = listManagedAccountsValidateBeforeCall(userGuid, memberGuid, page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<AccountsResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List managed accounts (asynchronously)
     * Use this endpoint to retrieve a list of all the partner-managed accounts associated with the given partner-manage member.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listManagedAccountsAsync(String userGuid, String memberGuid, Integer page, Integer recordsPerPage, final ApiCallback<AccountsResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listManagedAccountsValidateBeforeCall(userGuid, memberGuid, page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<AccountsResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listManagedInstitutions
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listManagedInstitutionsCall(Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/managed_institutions";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listManagedInstitutionsValidateBeforeCall(Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = listManagedInstitutionsCall(page, recordsPerPage, _callback);
        return localVarCall;

    }

    /**
     * List managed institutions
     * This endpoint returns a list of institutions which can be used to create partner-managed members.
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return InstitutionsResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public InstitutionsResponseBody listManagedInstitutions(Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<InstitutionsResponseBody> localVarResp = listManagedInstitutionsWithHttpInfo(page, recordsPerPage);
        return localVarResp.getData();
    }

    /**
     * List managed institutions
     * This endpoint returns a list of institutions which can be used to create partner-managed members.
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return ApiResponse&lt;InstitutionsResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<InstitutionsResponseBody> listManagedInstitutionsWithHttpInfo(Integer page, Integer recordsPerPage) throws ApiException {
        okhttp3.Call localVarCall = listManagedInstitutionsValidateBeforeCall(page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<InstitutionsResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List managed institutions (asynchronously)
     * This endpoint returns a list of institutions which can be used to create partner-managed members.
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listManagedInstitutionsAsync(Integer page, Integer recordsPerPage, final ApiCallback<InstitutionsResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listManagedInstitutionsValidateBeforeCall(page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<InstitutionsResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listManagedMembers
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listManagedMembersCall(String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/managed_members"
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listManagedMembersValidateBeforeCall(String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listManagedMembers(Async)");
        }
        

        okhttp3.Call localVarCall = listManagedMembersCall(userGuid, page, recordsPerPage, _callback);
        return localVarCall;

    }

    /**
     * List managed members
     * This endpoint returns a list of all the partner-managed members associated with the specified &#x60;user&#x60;.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return MembersResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public MembersResponseBody listManagedMembers(String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<MembersResponseBody> localVarResp = listManagedMembersWithHttpInfo(userGuid, page, recordsPerPage);
        return localVarResp.getData();
    }

    /**
     * List managed members
     * This endpoint returns a list of all the partner-managed members associated with the specified &#x60;user&#x60;.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return ApiResponse&lt;MembersResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MembersResponseBody> listManagedMembersWithHttpInfo(String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        okhttp3.Call localVarCall = listManagedMembersValidateBeforeCall(userGuid, page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<MembersResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List managed members (asynchronously)
     * This endpoint returns a list of all the partner-managed members associated with the specified &#x60;user&#x60;.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listManagedMembersAsync(String userGuid, Integer page, Integer recordsPerPage, final ApiCallback<MembersResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listManagedMembersValidateBeforeCall(userGuid, page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<MembersResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listManagedTransactions
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listManagedTransactionsCall(String userGuid, String memberGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/managed_members/{member_guid}/transactions"
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()))
            .replaceAll("\\{" + "member_guid" + "\\}", localVarApiClient.escapeString(memberGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listManagedTransactionsValidateBeforeCall(String userGuid, String memberGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listManagedTransactions(Async)");
        }
        
        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling listManagedTransactions(Async)");
        }
        

        okhttp3.Call localVarCall = listManagedTransactionsCall(userGuid, memberGuid, page, recordsPerPage, _callback);
        return localVarCall;

    }

    /**
     * List managed transactions
     * This endpoint returns a list of all the partner-managed transactions associated with the specified &#x60;account&#x60;, scoped through a &#x60;user&#x60; and a &#x60;member&#x60;.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return TransactionsResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public TransactionsResponseBody listManagedTransactions(String userGuid, String memberGuid, Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<TransactionsResponseBody> localVarResp = listManagedTransactionsWithHttpInfo(userGuid, memberGuid, page, recordsPerPage);
        return localVarResp.getData();
    }

    /**
     * List managed transactions
     * This endpoint returns a list of all the partner-managed transactions associated with the specified &#x60;account&#x60;, scoped through a &#x60;user&#x60; and a &#x60;member&#x60;.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return ApiResponse&lt;TransactionsResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TransactionsResponseBody> listManagedTransactionsWithHttpInfo(String userGuid, String memberGuid, Integer page, Integer recordsPerPage) throws ApiException {
        okhttp3.Call localVarCall = listManagedTransactionsValidateBeforeCall(userGuid, memberGuid, page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<TransactionsResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List managed transactions (asynchronously)
     * This endpoint returns a list of all the partner-managed transactions associated with the specified &#x60;account&#x60;, scoped through a &#x60;user&#x60; and a &#x60;member&#x60;.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listManagedTransactionsAsync(String userGuid, String memberGuid, Integer page, Integer recordsPerPage, final ApiCallback<TransactionsResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listManagedTransactionsValidateBeforeCall(userGuid, memberGuid, page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<TransactionsResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listMemberChallenges
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listMemberChallengesCall(String memberGuid, String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/members/{member_guid}/challenges"
            .replaceAll("\\{" + "member_guid" + "\\}", localVarApiClient.escapeString(memberGuid.toString()))
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listMemberChallengesValidateBeforeCall(String memberGuid, String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling listMemberChallenges(Async)");
        }
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listMemberChallenges(Async)");
        }
        

        okhttp3.Call localVarCall = listMemberChallengesCall(memberGuid, userGuid, page, recordsPerPage, _callback);
        return localVarCall;

    }

    /**
     * List member challenges
     * Use this endpoint for information on what multi-factor authentication challenges need to be answered in order to aggregate a member. If the aggregation is not challenged, i.e., the member does not have a connection status of &#x60;CHALLENGED&#x60;, then code &#x60;204 No Content&#x60; will be returned. If the aggregation has been challenged, i.e., the member does have a connection status of &#x60;CHALLENGED&#x60;, then code &#x60;200 OK&#x60; will be returned - along with the corresponding credentials.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return ChallengesResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ChallengesResponseBody listMemberChallenges(String memberGuid, String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<ChallengesResponseBody> localVarResp = listMemberChallengesWithHttpInfo(memberGuid, userGuid, page, recordsPerPage);
        return localVarResp.getData();
    }

    /**
     * List member challenges
     * Use this endpoint for information on what multi-factor authentication challenges need to be answered in order to aggregate a member. If the aggregation is not challenged, i.e., the member does not have a connection status of &#x60;CHALLENGED&#x60;, then code &#x60;204 No Content&#x60; will be returned. If the aggregation has been challenged, i.e., the member does have a connection status of &#x60;CHALLENGED&#x60;, then code &#x60;200 OK&#x60; will be returned - along with the corresponding credentials.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return ApiResponse&lt;ChallengesResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ChallengesResponseBody> listMemberChallengesWithHttpInfo(String memberGuid, String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        okhttp3.Call localVarCall = listMemberChallengesValidateBeforeCall(memberGuid, userGuid, page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<ChallengesResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List member challenges (asynchronously)
     * Use this endpoint for information on what multi-factor authentication challenges need to be answered in order to aggregate a member. If the aggregation is not challenged, i.e., the member does not have a connection status of &#x60;CHALLENGED&#x60;, then code &#x60;204 No Content&#x60; will be returned. If the aggregation has been challenged, i.e., the member does have a connection status of &#x60;CHALLENGED&#x60;, then code &#x60;200 OK&#x60; will be returned - along with the corresponding credentials.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listMemberChallengesAsync(String memberGuid, String userGuid, Integer page, Integer recordsPerPage, final ApiCallback<ChallengesResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listMemberChallengesValidateBeforeCall(memberGuid, userGuid, page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<ChallengesResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listMemberCredentials
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listMemberCredentialsCall(String memberGuid, String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/members/{member_guid}/credentials"
            .replaceAll("\\{" + "member_guid" + "\\}", localVarApiClient.escapeString(memberGuid.toString()))
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listMemberCredentialsValidateBeforeCall(String memberGuid, String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling listMemberCredentials(Async)");
        }
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listMemberCredentials(Async)");
        }
        

        okhttp3.Call localVarCall = listMemberCredentialsCall(memberGuid, userGuid, page, recordsPerPage, _callback);
        return localVarCall;

    }

    /**
     * List member credentials
     * This endpoint returns an array which contains information on every non-MFA credential associated with a specific member.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return CredentialsResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public CredentialsResponseBody listMemberCredentials(String memberGuid, String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<CredentialsResponseBody> localVarResp = listMemberCredentialsWithHttpInfo(memberGuid, userGuid, page, recordsPerPage);
        return localVarResp.getData();
    }

    /**
     * List member credentials
     * This endpoint returns an array which contains information on every non-MFA credential associated with a specific member.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return ApiResponse&lt;CredentialsResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CredentialsResponseBody> listMemberCredentialsWithHttpInfo(String memberGuid, String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        okhttp3.Call localVarCall = listMemberCredentialsValidateBeforeCall(memberGuid, userGuid, page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<CredentialsResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List member credentials (asynchronously)
     * This endpoint returns an array which contains information on every non-MFA credential associated with a specific member.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listMemberCredentialsAsync(String memberGuid, String userGuid, Integer page, Integer recordsPerPage, final ApiCallback<CredentialsResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listMemberCredentialsValidateBeforeCall(memberGuid, userGuid, page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<CredentialsResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listMembers
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listMembersCall(String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/members"
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listMembersValidateBeforeCall(String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listMembers(Async)");
        }
        

        okhttp3.Call localVarCall = listMembersCall(userGuid, page, recordsPerPage, _callback);
        return localVarCall;

    }

    /**
     * List members
     * This endpoint returns an array which contains information on every member associated with a specific user.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return MembersResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public MembersResponseBody listMembers(String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<MembersResponseBody> localVarResp = listMembersWithHttpInfo(userGuid, page, recordsPerPage);
        return localVarResp.getData();
    }

    /**
     * List members
     * This endpoint returns an array which contains information on every member associated with a specific user.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return ApiResponse&lt;MembersResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MembersResponseBody> listMembersWithHttpInfo(String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        okhttp3.Call localVarCall = listMembersValidateBeforeCall(userGuid, page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<MembersResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List members (asynchronously)
     * This endpoint returns an array which contains information on every member associated with a specific user.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listMembersAsync(String userGuid, Integer page, Integer recordsPerPage, final ApiCallback<MembersResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listMembersValidateBeforeCall(userGuid, page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<MembersResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listMerchants
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listMerchantsCall(Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/merchants";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listMerchantsValidateBeforeCall(Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = listMerchantsCall(page, recordsPerPage, _callback);
        return localVarCall;

    }

    /**
     * List merchants
     * This endpoint returns a paginated list of all the merchants in the MX system.
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return MerchantsResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public MerchantsResponseBody listMerchants(Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<MerchantsResponseBody> localVarResp = listMerchantsWithHttpInfo(page, recordsPerPage);
        return localVarResp.getData();
    }

    /**
     * List merchants
     * This endpoint returns a paginated list of all the merchants in the MX system.
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return ApiResponse&lt;MerchantsResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MerchantsResponseBody> listMerchantsWithHttpInfo(Integer page, Integer recordsPerPage) throws ApiException {
        okhttp3.Call localVarCall = listMerchantsValidateBeforeCall(page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<MerchantsResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List merchants (asynchronously)
     * This endpoint returns a paginated list of all the merchants in the MX system.
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listMerchantsAsync(Integer page, Integer recordsPerPage, final ApiCallback<MerchantsResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listMerchantsValidateBeforeCall(page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<MerchantsResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listStatementsByMember
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listStatementsByMemberCall(String memberGuid, String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/members/{member_guid}/statements"
            .replaceAll("\\{" + "member_guid" + "\\}", localVarApiClient.escapeString(memberGuid.toString()))
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listStatementsByMemberValidateBeforeCall(String memberGuid, String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling listStatementsByMember(Async)");
        }
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listStatementsByMember(Async)");
        }
        

        okhttp3.Call localVarCall = listStatementsByMemberCall(memberGuid, userGuid, page, recordsPerPage, _callback);
        return localVarCall;

    }

    /**
     * List statements by member
     * Use this endpoint to get an array of available statements.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return StatementsResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public StatementsResponseBody listStatementsByMember(String memberGuid, String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<StatementsResponseBody> localVarResp = listStatementsByMemberWithHttpInfo(memberGuid, userGuid, page, recordsPerPage);
        return localVarResp.getData();
    }

    /**
     * List statements by member
     * Use this endpoint to get an array of available statements.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return ApiResponse&lt;StatementsResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<StatementsResponseBody> listStatementsByMemberWithHttpInfo(String memberGuid, String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        okhttp3.Call localVarCall = listStatementsByMemberValidateBeforeCall(memberGuid, userGuid, page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<StatementsResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List statements by member (asynchronously)
     * Use this endpoint to get an array of available statements.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listStatementsByMemberAsync(String memberGuid, String userGuid, Integer page, Integer recordsPerPage, final ApiCallback<StatementsResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listStatementsByMemberValidateBeforeCall(memberGuid, userGuid, page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<StatementsResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listTaggings
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listTaggingsCall(String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/taggings"
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listTaggingsValidateBeforeCall(String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listTaggings(Async)");
        }
        

        okhttp3.Call localVarCall = listTaggingsCall(userGuid, page, recordsPerPage, _callback);
        return localVarCall;

    }

    /**
     * List taggings
     * Use this endpoint to retrieve a list of all the taggings associated with a specific user.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return TaggingsResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public TaggingsResponseBody listTaggings(String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<TaggingsResponseBody> localVarResp = listTaggingsWithHttpInfo(userGuid, page, recordsPerPage);
        return localVarResp.getData();
    }

    /**
     * List taggings
     * Use this endpoint to retrieve a list of all the taggings associated with a specific user.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return ApiResponse&lt;TaggingsResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TaggingsResponseBody> listTaggingsWithHttpInfo(String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        okhttp3.Call localVarCall = listTaggingsValidateBeforeCall(userGuid, page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<TaggingsResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List taggings (asynchronously)
     * Use this endpoint to retrieve a list of all the taggings associated with a specific user.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listTaggingsAsync(String userGuid, Integer page, Integer recordsPerPage, final ApiCallback<TaggingsResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listTaggingsValidateBeforeCall(userGuid, page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<TaggingsResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listTags
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listTagsCall(String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/tags"
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listTagsValidateBeforeCall(String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listTags(Async)");
        }
        

        okhttp3.Call localVarCall = listTagsCall(userGuid, page, recordsPerPage, _callback);
        return localVarCall;

    }

    /**
     * List tags
     * Use this endpoint to list all tags associated with the specified &#x60;user&#x60;. Each user includes the &#x60;Business&#x60; tag by default.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return TagsResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public TagsResponseBody listTags(String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<TagsResponseBody> localVarResp = listTagsWithHttpInfo(userGuid, page, recordsPerPage);
        return localVarResp.getData();
    }

    /**
     * List tags
     * Use this endpoint to list all tags associated with the specified &#x60;user&#x60;. Each user includes the &#x60;Business&#x60; tag by default.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return ApiResponse&lt;TagsResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TagsResponseBody> listTagsWithHttpInfo(String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        okhttp3.Call localVarCall = listTagsValidateBeforeCall(userGuid, page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<TagsResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List tags (asynchronously)
     * Use this endpoint to list all tags associated with the specified &#x60;user&#x60;. Each user includes the &#x60;Business&#x60; tag by default.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listTagsAsync(String userGuid, Integer page, Integer recordsPerPage, final ApiCallback<TagsResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listTagsValidateBeforeCall(userGuid, page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<TagsResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listTransactionRules
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listTransactionRulesCall(String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/transaction_rules"
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listTransactionRulesValidateBeforeCall(String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listTransactionRules(Async)");
        }
        

        okhttp3.Call localVarCall = listTransactionRulesCall(userGuid, page, recordsPerPage, _callback);
        return localVarCall;

    }

    /**
     * List transaction rules
     * Use this endpoint to read the attributes of all existing transaction rules belonging to the user.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return TransactionRulesResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public TransactionRulesResponseBody listTransactionRules(String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<TransactionRulesResponseBody> localVarResp = listTransactionRulesWithHttpInfo(userGuid, page, recordsPerPage);
        return localVarResp.getData();
    }

    /**
     * List transaction rules
     * Use this endpoint to read the attributes of all existing transaction rules belonging to the user.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return ApiResponse&lt;TransactionRulesResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TransactionRulesResponseBody> listTransactionRulesWithHttpInfo(String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        okhttp3.Call localVarCall = listTransactionRulesValidateBeforeCall(userGuid, page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<TransactionRulesResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List transaction rules (asynchronously)
     * Use this endpoint to read the attributes of all existing transaction rules belonging to the user.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listTransactionRulesAsync(String userGuid, Integer page, Integer recordsPerPage, final ApiCallback<TransactionRulesResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listTransactionRulesValidateBeforeCall(userGuid, page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<TransactionRulesResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listTransactions
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param fromDate Filter transactions from this date. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param toDate Filter transactions to this date. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listTransactionsCall(String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/transactions"
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (fromDate != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("from_date", fromDate));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        if (toDate != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("to_date", toDate));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listTransactionsValidateBeforeCall(String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listTransactions(Async)");
        }
        

        okhttp3.Call localVarCall = listTransactionsCall(userGuid, fromDate, page, recordsPerPage, toDate, _callback);
        return localVarCall;

    }

    /**
     * List transactions
     * Requests to this endpoint return a list of transactions associated with the specified &#x60;user&#x60;, accross all members and accounts associated with that &#x60;user&#x60;.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param fromDate Filter transactions from this date. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param toDate Filter transactions to this date. (optional)
     * @return TransactionsResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public TransactionsResponseBody listTransactions(String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate) throws ApiException {
        ApiResponse<TransactionsResponseBody> localVarResp = listTransactionsWithHttpInfo(userGuid, fromDate, page, recordsPerPage, toDate);
        return localVarResp.getData();
    }

    /**
     * List transactions
     * Requests to this endpoint return a list of transactions associated with the specified &#x60;user&#x60;, accross all members and accounts associated with that &#x60;user&#x60;.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param fromDate Filter transactions from this date. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param toDate Filter transactions to this date. (optional)
     * @return ApiResponse&lt;TransactionsResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TransactionsResponseBody> listTransactionsWithHttpInfo(String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate) throws ApiException {
        okhttp3.Call localVarCall = listTransactionsValidateBeforeCall(userGuid, fromDate, page, recordsPerPage, toDate, null);
        Type localVarReturnType = new TypeToken<TransactionsResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List transactions (asynchronously)
     * Requests to this endpoint return a list of transactions associated with the specified &#x60;user&#x60;, accross all members and accounts associated with that &#x60;user&#x60;.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param fromDate Filter transactions from this date. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param toDate Filter transactions to this date. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listTransactionsAsync(String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate, final ApiCallback<TransactionsResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listTransactionsValidateBeforeCall(userGuid, fromDate, page, recordsPerPage, toDate, _callback);
        Type localVarReturnType = new TypeToken<TransactionsResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listTransactionsByAccount
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param fromDate Filter transactions from this date. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param toDate Filter transactions to this date. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listTransactionsByAccountCall(String accountGuid, String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/accounts/{account_guid}/transactions"
            .replaceAll("\\{" + "account_guid" + "\\}", localVarApiClient.escapeString(accountGuid.toString()))
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (fromDate != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("from_date", fromDate));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        if (toDate != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("to_date", toDate));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listTransactionsByAccountValidateBeforeCall(String accountGuid, String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'accountGuid' is set
        if (accountGuid == null) {
            throw new ApiException("Missing the required parameter 'accountGuid' when calling listTransactionsByAccount(Async)");
        }
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listTransactionsByAccount(Async)");
        }
        

        okhttp3.Call localVarCall = listTransactionsByAccountCall(accountGuid, userGuid, fromDate, page, recordsPerPage, toDate, _callback);
        return localVarCall;

    }

    /**
     * List transactions by account
     * This endpoint returns a list of the last 90 days of transactions associated with the specified account.
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param fromDate Filter transactions from this date. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param toDate Filter transactions to this date. (optional)
     * @return TransactionsResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public TransactionsResponseBody listTransactionsByAccount(String accountGuid, String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate) throws ApiException {
        ApiResponse<TransactionsResponseBody> localVarResp = listTransactionsByAccountWithHttpInfo(accountGuid, userGuid, fromDate, page, recordsPerPage, toDate);
        return localVarResp.getData();
    }

    /**
     * List transactions by account
     * This endpoint returns a list of the last 90 days of transactions associated with the specified account.
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param fromDate Filter transactions from this date. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param toDate Filter transactions to this date. (optional)
     * @return ApiResponse&lt;TransactionsResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TransactionsResponseBody> listTransactionsByAccountWithHttpInfo(String accountGuid, String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate) throws ApiException {
        okhttp3.Call localVarCall = listTransactionsByAccountValidateBeforeCall(accountGuid, userGuid, fromDate, page, recordsPerPage, toDate, null);
        Type localVarReturnType = new TypeToken<TransactionsResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List transactions by account (asynchronously)
     * This endpoint returns a list of the last 90 days of transactions associated with the specified account.
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param fromDate Filter transactions from this date. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param toDate Filter transactions to this date. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listTransactionsByAccountAsync(String accountGuid, String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate, final ApiCallback<TransactionsResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listTransactionsByAccountValidateBeforeCall(accountGuid, userGuid, fromDate, page, recordsPerPage, toDate, _callback);
        Type localVarReturnType = new TypeToken<TransactionsResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listTransactionsByMember
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param fromDate Filter transactions from this date. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param toDate Filter transactions to this date. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listTransactionsByMemberCall(String memberGuid, String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/members/{member_guid}/transactions"
            .replaceAll("\\{" + "member_guid" + "\\}", localVarApiClient.escapeString(memberGuid.toString()))
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (fromDate != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("from_date", fromDate));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        if (toDate != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("to_date", toDate));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listTransactionsByMemberValidateBeforeCall(String memberGuid, String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling listTransactionsByMember(Async)");
        }
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listTransactionsByMember(Async)");
        }
        

        okhttp3.Call localVarCall = listTransactionsByMemberCall(memberGuid, userGuid, fromDate, page, recordsPerPage, toDate, _callback);
        return localVarCall;

    }

    /**
     * List transactions by member
     * Requests to this endpoint return a list of transactions associated with the specified &#x60;member&#x60;, accross all accounts associated with that &#x60;member&#x60;.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param fromDate Filter transactions from this date. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param toDate Filter transactions to this date. (optional)
     * @return TransactionsResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public TransactionsResponseBody listTransactionsByMember(String memberGuid, String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate) throws ApiException {
        ApiResponse<TransactionsResponseBody> localVarResp = listTransactionsByMemberWithHttpInfo(memberGuid, userGuid, fromDate, page, recordsPerPage, toDate);
        return localVarResp.getData();
    }

    /**
     * List transactions by member
     * Requests to this endpoint return a list of transactions associated with the specified &#x60;member&#x60;, accross all accounts associated with that &#x60;member&#x60;.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param fromDate Filter transactions from this date. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param toDate Filter transactions to this date. (optional)
     * @return ApiResponse&lt;TransactionsResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TransactionsResponseBody> listTransactionsByMemberWithHttpInfo(String memberGuid, String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate) throws ApiException {
        okhttp3.Call localVarCall = listTransactionsByMemberValidateBeforeCall(memberGuid, userGuid, fromDate, page, recordsPerPage, toDate, null);
        Type localVarReturnType = new TypeToken<TransactionsResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List transactions by member (asynchronously)
     * Requests to this endpoint return a list of transactions associated with the specified &#x60;member&#x60;, accross all accounts associated with that &#x60;member&#x60;.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param fromDate Filter transactions from this date. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param toDate Filter transactions to this date. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listTransactionsByMemberAsync(String memberGuid, String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate, final ApiCallback<TransactionsResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listTransactionsByMemberValidateBeforeCall(memberGuid, userGuid, fromDate, page, recordsPerPage, toDate, _callback);
        Type localVarReturnType = new TypeToken<TransactionsResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listTransactionsByTag
     * @param tagGuid The unique id for a &#x60;tag&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param fromDate Filter transactions from this date. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param toDate Filter transactions to this date. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listTransactionsByTagCall(String tagGuid, String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/tags/{tag_guid}/transactions"
            .replaceAll("\\{" + "tag_guid" + "\\}", localVarApiClient.escapeString(tagGuid.toString()))
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (fromDate != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("from_date", fromDate));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        if (toDate != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("to_date", toDate));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listTransactionsByTagValidateBeforeCall(String tagGuid, String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'tagGuid' is set
        if (tagGuid == null) {
            throw new ApiException("Missing the required parameter 'tagGuid' when calling listTransactionsByTag(Async)");
        }
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listTransactionsByTag(Async)");
        }
        

        okhttp3.Call localVarCall = listTransactionsByTagCall(tagGuid, userGuid, fromDate, page, recordsPerPage, toDate, _callback);
        return localVarCall;

    }

    /**
     * List transactions by tag
     * Use this endpoint to get a list of all transactions associated with a particular tag according to the tag’s unique GUID. In other words, a list of all transactions that have been assigned to a particular tag using the create a tagging endpoint.
     * @param tagGuid The unique id for a &#x60;tag&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param fromDate Filter transactions from this date. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param toDate Filter transactions to this date. (optional)
     * @return TransactionsResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public TransactionsResponseBody listTransactionsByTag(String tagGuid, String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate) throws ApiException {
        ApiResponse<TransactionsResponseBody> localVarResp = listTransactionsByTagWithHttpInfo(tagGuid, userGuid, fromDate, page, recordsPerPage, toDate);
        return localVarResp.getData();
    }

    /**
     * List transactions by tag
     * Use this endpoint to get a list of all transactions associated with a particular tag according to the tag’s unique GUID. In other words, a list of all transactions that have been assigned to a particular tag using the create a tagging endpoint.
     * @param tagGuid The unique id for a &#x60;tag&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param fromDate Filter transactions from this date. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param toDate Filter transactions to this date. (optional)
     * @return ApiResponse&lt;TransactionsResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TransactionsResponseBody> listTransactionsByTagWithHttpInfo(String tagGuid, String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate) throws ApiException {
        okhttp3.Call localVarCall = listTransactionsByTagValidateBeforeCall(tagGuid, userGuid, fromDate, page, recordsPerPage, toDate, null);
        Type localVarReturnType = new TypeToken<TransactionsResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List transactions by tag (asynchronously)
     * Use this endpoint to get a list of all transactions associated with a particular tag according to the tag’s unique GUID. In other words, a list of all transactions that have been assigned to a particular tag using the create a tagging endpoint.
     * @param tagGuid The unique id for a &#x60;tag&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param fromDate Filter transactions from this date. (optional)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param toDate Filter transactions to this date. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listTransactionsByTagAsync(String tagGuid, String userGuid, String fromDate, Integer page, Integer recordsPerPage, String toDate, final ApiCallback<TransactionsResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listTransactionsByTagValidateBeforeCall(tagGuid, userGuid, fromDate, page, recordsPerPage, toDate, _callback);
        Type localVarReturnType = new TypeToken<TransactionsResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listUserAccounts
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listUserAccountsCall(String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/accounts"
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listUserAccountsValidateBeforeCall(String userGuid, Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling listUserAccounts(Async)");
        }
        

        okhttp3.Call localVarCall = listUserAccountsCall(userGuid, page, recordsPerPage, _callback);
        return localVarCall;

    }

    /**
     * List accounts
     * This endpoint returns a list of all the accounts associated with the specified &#x60;user&#x60;.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return AccountsResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public AccountsResponseBody listUserAccounts(String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<AccountsResponseBody> localVarResp = listUserAccountsWithHttpInfo(userGuid, page, recordsPerPage);
        return localVarResp.getData();
    }

    /**
     * List accounts
     * This endpoint returns a list of all the accounts associated with the specified &#x60;user&#x60;.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return ApiResponse&lt;AccountsResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<AccountsResponseBody> listUserAccountsWithHttpInfo(String userGuid, Integer page, Integer recordsPerPage) throws ApiException {
        okhttp3.Call localVarCall = listUserAccountsValidateBeforeCall(userGuid, page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<AccountsResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List accounts (asynchronously)
     * This endpoint returns a list of all the accounts associated with the specified &#x60;user&#x60;.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listUserAccountsAsync(String userGuid, Integer page, Integer recordsPerPage, final ApiCallback<AccountsResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listUserAccountsValidateBeforeCall(userGuid, page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<AccountsResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listUsers
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listUsersCall(Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (recordsPerPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("records_per_page", recordsPerPage));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listUsersValidateBeforeCall(Integer page, Integer recordsPerPage, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = listUsersCall(page, recordsPerPage, _callback);
        return localVarCall;

    }

    /**
     * List users
     * Use this endpoint to list every user you&#39;ve created in the MX Platform API.
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return UsersResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public UsersResponseBody listUsers(Integer page, Integer recordsPerPage) throws ApiException {
        ApiResponse<UsersResponseBody> localVarResp = listUsersWithHttpInfo(page, recordsPerPage);
        return localVarResp.getData();
    }

    /**
     * List users
     * Use this endpoint to list every user you&#39;ve created in the MX Platform API.
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @return ApiResponse&lt;UsersResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<UsersResponseBody> listUsersWithHttpInfo(Integer page, Integer recordsPerPage) throws ApiException {
        okhttp3.Call localVarCall = listUsersValidateBeforeCall(page, recordsPerPage, null);
        Type localVarReturnType = new TypeToken<UsersResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List users (asynchronously)
     * Use this endpoint to list every user you&#39;ve created in the MX Platform API.
     * @param page Specify current page. (optional)
     * @param recordsPerPage Specify records per page. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listUsersAsync(Integer page, Integer recordsPerPage, final ApiCallback<UsersResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = listUsersValidateBeforeCall(page, recordsPerPage, _callback);
        Type localVarReturnType = new TypeToken<UsersResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for readAccount
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readAccountCall(String accountGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/accounts/{account_guid}"
            .replaceAll("\\{" + "account_guid" + "\\}", localVarApiClient.escapeString(accountGuid.toString()))
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call readAccountValidateBeforeCall(String accountGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'accountGuid' is set
        if (accountGuid == null) {
            throw new ApiException("Missing the required parameter 'accountGuid' when calling readAccount(Async)");
        }
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling readAccount(Async)");
        }
        

        okhttp3.Call localVarCall = readAccountCall(accountGuid, userGuid, _callback);
        return localVarCall;

    }

    /**
     * Read account
     * This endpoint returns the specified &#x60;account&#x60; resource.
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return AccountResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public AccountResponseBody readAccount(String accountGuid, String userGuid) throws ApiException {
        ApiResponse<AccountResponseBody> localVarResp = readAccountWithHttpInfo(accountGuid, userGuid);
        return localVarResp.getData();
    }

    /**
     * Read account
     * This endpoint returns the specified &#x60;account&#x60; resource.
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return ApiResponse&lt;AccountResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<AccountResponseBody> readAccountWithHttpInfo(String accountGuid, String userGuid) throws ApiException {
        okhttp3.Call localVarCall = readAccountValidateBeforeCall(accountGuid, userGuid, null);
        Type localVarReturnType = new TypeToken<AccountResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Read account (asynchronously)
     * This endpoint returns the specified &#x60;account&#x60; resource.
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readAccountAsync(String accountGuid, String userGuid, final ApiCallback<AccountResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = readAccountValidateBeforeCall(accountGuid, userGuid, _callback);
        Type localVarReturnType = new TypeToken<AccountResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for readCategory
     * @param categoryGuid The unique id for a &#x60;category&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readCategoryCall(String categoryGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/categories/{category_guid}"
            .replaceAll("\\{" + "category_guid" + "\\}", localVarApiClient.escapeString(categoryGuid.toString()))
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call readCategoryValidateBeforeCall(String categoryGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'categoryGuid' is set
        if (categoryGuid == null) {
            throw new ApiException("Missing the required parameter 'categoryGuid' when calling readCategory(Async)");
        }
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling readCategory(Async)");
        }
        

        okhttp3.Call localVarCall = readCategoryCall(categoryGuid, userGuid, _callback);
        return localVarCall;

    }

    /**
     * Read a custom category
     * Use this endpoint to read the attributes of either a default category or a custom category.
     * @param categoryGuid The unique id for a &#x60;category&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return CategoryResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public CategoryResponseBody readCategory(String categoryGuid, String userGuid) throws ApiException {
        ApiResponse<CategoryResponseBody> localVarResp = readCategoryWithHttpInfo(categoryGuid, userGuid);
        return localVarResp.getData();
    }

    /**
     * Read a custom category
     * Use this endpoint to read the attributes of either a default category or a custom category.
     * @param categoryGuid The unique id for a &#x60;category&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return ApiResponse&lt;CategoryResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CategoryResponseBody> readCategoryWithHttpInfo(String categoryGuid, String userGuid) throws ApiException {
        okhttp3.Call localVarCall = readCategoryValidateBeforeCall(categoryGuid, userGuid, null);
        Type localVarReturnType = new TypeToken<CategoryResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Read a custom category (asynchronously)
     * Use this endpoint to read the attributes of either a default category or a custom category.
     * @param categoryGuid The unique id for a &#x60;category&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readCategoryAsync(String categoryGuid, String userGuid, final ApiCallback<CategoryResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = readCategoryValidateBeforeCall(categoryGuid, userGuid, _callback);
        Type localVarReturnType = new TypeToken<CategoryResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for readDefaultCategory
     * @param categoryGuid The unique id for a &#x60;category&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readDefaultCategoryCall(String categoryGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/categories/{category_guid}"
            .replaceAll("\\{" + "category_guid" + "\\}", localVarApiClient.escapeString(categoryGuid.toString()))
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call readDefaultCategoryValidateBeforeCall(String categoryGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'categoryGuid' is set
        if (categoryGuid == null) {
            throw new ApiException("Missing the required parameter 'categoryGuid' when calling readDefaultCategory(Async)");
        }
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling readDefaultCategory(Async)");
        }
        

        okhttp3.Call localVarCall = readDefaultCategoryCall(categoryGuid, userGuid, _callback);
        return localVarCall;

    }

    /**
     * Read a default category
     * Use this endpoint to read the attributes of a default category.
     * @param categoryGuid The unique id for a &#x60;category&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return CategoryResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public CategoryResponseBody readDefaultCategory(String categoryGuid, String userGuid) throws ApiException {
        ApiResponse<CategoryResponseBody> localVarResp = readDefaultCategoryWithHttpInfo(categoryGuid, userGuid);
        return localVarResp.getData();
    }

    /**
     * Read a default category
     * Use this endpoint to read the attributes of a default category.
     * @param categoryGuid The unique id for a &#x60;category&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return ApiResponse&lt;CategoryResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CategoryResponseBody> readDefaultCategoryWithHttpInfo(String categoryGuid, String userGuid) throws ApiException {
        okhttp3.Call localVarCall = readDefaultCategoryValidateBeforeCall(categoryGuid, userGuid, null);
        Type localVarReturnType = new TypeToken<CategoryResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Read a default category (asynchronously)
     * Use this endpoint to read the attributes of a default category.
     * @param categoryGuid The unique id for a &#x60;category&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readDefaultCategoryAsync(String categoryGuid, String userGuid, final ApiCallback<CategoryResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = readDefaultCategoryValidateBeforeCall(categoryGuid, userGuid, _callback);
        Type localVarReturnType = new TypeToken<CategoryResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for readHolding
     * @param holdingGuid The unique id for a &#x60;holding&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readHoldingCall(String holdingGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/holdings/{holding_guid}"
            .replaceAll("\\{" + "holding_guid" + "\\}", localVarApiClient.escapeString(holdingGuid.toString()))
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call readHoldingValidateBeforeCall(String holdingGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'holdingGuid' is set
        if (holdingGuid == null) {
            throw new ApiException("Missing the required parameter 'holdingGuid' when calling readHolding(Async)");
        }
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling readHolding(Async)");
        }
        

        okhttp3.Call localVarCall = readHoldingCall(holdingGuid, userGuid, _callback);
        return localVarCall;

    }

    /**
     * Read holding
     * Use this endpoint to read the attributes of a specific &#x60;holding&#x60;.
     * @param holdingGuid The unique id for a &#x60;holding&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return HoldingResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public HoldingResponseBody readHolding(String holdingGuid, String userGuid) throws ApiException {
        ApiResponse<HoldingResponseBody> localVarResp = readHoldingWithHttpInfo(holdingGuid, userGuid);
        return localVarResp.getData();
    }

    /**
     * Read holding
     * Use this endpoint to read the attributes of a specific &#x60;holding&#x60;.
     * @param holdingGuid The unique id for a &#x60;holding&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return ApiResponse&lt;HoldingResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<HoldingResponseBody> readHoldingWithHttpInfo(String holdingGuid, String userGuid) throws ApiException {
        okhttp3.Call localVarCall = readHoldingValidateBeforeCall(holdingGuid, userGuid, null);
        Type localVarReturnType = new TypeToken<HoldingResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Read holding (asynchronously)
     * Use this endpoint to read the attributes of a specific &#x60;holding&#x60;.
     * @param holdingGuid The unique id for a &#x60;holding&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readHoldingAsync(String holdingGuid, String userGuid, final ApiCallback<HoldingResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = readHoldingValidateBeforeCall(holdingGuid, userGuid, _callback);
        Type localVarReturnType = new TypeToken<HoldingResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for readInstitution
     * @param institutionCode The institution_code of the institution. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readInstitutionCall(String institutionCode, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/institutions/{institution_code}"
            .replaceAll("\\{" + "institution_code" + "\\}", localVarApiClient.escapeString(institutionCode.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call readInstitutionValidateBeforeCall(String institutionCode, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'institutionCode' is set
        if (institutionCode == null) {
            throw new ApiException("Missing the required parameter 'institutionCode' when calling readInstitution(Async)");
        }
        

        okhttp3.Call localVarCall = readInstitutionCall(institutionCode, _callback);
        return localVarCall;

    }

    /**
     * Read institution
     * This endpoint returns information about the institution specified by &#x60;institution_code&#x60;.
     * @param institutionCode The institution_code of the institution. (required)
     * @return InstitutionResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public InstitutionResponseBody readInstitution(String institutionCode) throws ApiException {
        ApiResponse<InstitutionResponseBody> localVarResp = readInstitutionWithHttpInfo(institutionCode);
        return localVarResp.getData();
    }

    /**
     * Read institution
     * This endpoint returns information about the institution specified by &#x60;institution_code&#x60;.
     * @param institutionCode The institution_code of the institution. (required)
     * @return ApiResponse&lt;InstitutionResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<InstitutionResponseBody> readInstitutionWithHttpInfo(String institutionCode) throws ApiException {
        okhttp3.Call localVarCall = readInstitutionValidateBeforeCall(institutionCode, null);
        Type localVarReturnType = new TypeToken<InstitutionResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Read institution (asynchronously)
     * This endpoint returns information about the institution specified by &#x60;institution_code&#x60;.
     * @param institutionCode The institution_code of the institution. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readInstitutionAsync(String institutionCode, final ApiCallback<InstitutionResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = readInstitutionValidateBeforeCall(institutionCode, _callback);
        Type localVarReturnType = new TypeToken<InstitutionResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for readManagedAccount
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readManagedAccountCall(String memberGuid, String userGuid, String accountGuid, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/managed_members/{member_guid}/accounts/{account_guid}"
            .replaceAll("\\{" + "member_guid" + "\\}", localVarApiClient.escapeString(memberGuid.toString()))
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()))
            .replaceAll("\\{" + "account_guid" + "\\}", localVarApiClient.escapeString(accountGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call readManagedAccountValidateBeforeCall(String memberGuid, String userGuid, String accountGuid, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling readManagedAccount(Async)");
        }
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling readManagedAccount(Async)");
        }
        
        // verify the required parameter 'accountGuid' is set
        if (accountGuid == null) {
            throw new ApiException("Missing the required parameter 'accountGuid' when calling readManagedAccount(Async)");
        }
        

        okhttp3.Call localVarCall = readManagedAccountCall(memberGuid, userGuid, accountGuid, _callback);
        return localVarCall;

    }

    /**
     * Read managed account
     * Use this endpoint to read the attributes of a partner-managed account according to its unique guid.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @return AccountResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public AccountResponseBody readManagedAccount(String memberGuid, String userGuid, String accountGuid) throws ApiException {
        ApiResponse<AccountResponseBody> localVarResp = readManagedAccountWithHttpInfo(memberGuid, userGuid, accountGuid);
        return localVarResp.getData();
    }

    /**
     * Read managed account
     * Use this endpoint to read the attributes of a partner-managed account according to its unique guid.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @return ApiResponse&lt;AccountResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<AccountResponseBody> readManagedAccountWithHttpInfo(String memberGuid, String userGuid, String accountGuid) throws ApiException {
        okhttp3.Call localVarCall = readManagedAccountValidateBeforeCall(memberGuid, userGuid, accountGuid, null);
        Type localVarReturnType = new TypeToken<AccountResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Read managed account (asynchronously)
     * Use this endpoint to read the attributes of a partner-managed account according to its unique guid.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readManagedAccountAsync(String memberGuid, String userGuid, String accountGuid, final ApiCallback<AccountResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = readManagedAccountValidateBeforeCall(memberGuid, userGuid, accountGuid, _callback);
        Type localVarReturnType = new TypeToken<AccountResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for readManagedMember
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readManagedMemberCall(String memberGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/managed_members/{member_guid}"
            .replaceAll("\\{" + "member_guid" + "\\}", localVarApiClient.escapeString(memberGuid.toString()))
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call readManagedMemberValidateBeforeCall(String memberGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling readManagedMember(Async)");
        }
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling readManagedMember(Async)");
        }
        

        okhttp3.Call localVarCall = readManagedMemberCall(memberGuid, userGuid, _callback);
        return localVarCall;

    }

    /**
     * Read managed member
     * This endpoint returns the attributes of the specified partner-managed &#x60;member&#x60;.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return MemberResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public MemberResponseBody readManagedMember(String memberGuid, String userGuid) throws ApiException {
        ApiResponse<MemberResponseBody> localVarResp = readManagedMemberWithHttpInfo(memberGuid, userGuid);
        return localVarResp.getData();
    }

    /**
     * Read managed member
     * This endpoint returns the attributes of the specified partner-managed &#x60;member&#x60;.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return ApiResponse&lt;MemberResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MemberResponseBody> readManagedMemberWithHttpInfo(String memberGuid, String userGuid) throws ApiException {
        okhttp3.Call localVarCall = readManagedMemberValidateBeforeCall(memberGuid, userGuid, null);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Read managed member (asynchronously)
     * This endpoint returns the attributes of the specified partner-managed &#x60;member&#x60;.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readManagedMemberAsync(String memberGuid, String userGuid, final ApiCallback<MemberResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = readManagedMemberValidateBeforeCall(memberGuid, userGuid, _callback);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for readManagedTransaction
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param transactionGuid The unique id for a &#x60;transaction&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readManagedTransactionCall(String memberGuid, String userGuid, String transactionGuid, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/managed_members/{member_guid}/transactions/{transaction_guid}"
            .replaceAll("\\{" + "member_guid" + "\\}", localVarApiClient.escapeString(memberGuid.toString()))
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()))
            .replaceAll("\\{" + "transaction_guid" + "\\}", localVarApiClient.escapeString(transactionGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call readManagedTransactionValidateBeforeCall(String memberGuid, String userGuid, String transactionGuid, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling readManagedTransaction(Async)");
        }
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling readManagedTransaction(Async)");
        }
        
        // verify the required parameter 'transactionGuid' is set
        if (transactionGuid == null) {
            throw new ApiException("Missing the required parameter 'transactionGuid' when calling readManagedTransaction(Async)");
        }
        

        okhttp3.Call localVarCall = readManagedTransactionCall(memberGuid, userGuid, transactionGuid, _callback);
        return localVarCall;

    }

    /**
     * Read managed transaction
     * Requests to this endpoint will return the attributes of the specified partner-managed &#x60;transaction&#x60;.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param transactionGuid The unique id for a &#x60;transaction&#x60;. (required)
     * @return TransactionResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public TransactionResponseBody readManagedTransaction(String memberGuid, String userGuid, String transactionGuid) throws ApiException {
        ApiResponse<TransactionResponseBody> localVarResp = readManagedTransactionWithHttpInfo(memberGuid, userGuid, transactionGuid);
        return localVarResp.getData();
    }

    /**
     * Read managed transaction
     * Requests to this endpoint will return the attributes of the specified partner-managed &#x60;transaction&#x60;.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param transactionGuid The unique id for a &#x60;transaction&#x60;. (required)
     * @return ApiResponse&lt;TransactionResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TransactionResponseBody> readManagedTransactionWithHttpInfo(String memberGuid, String userGuid, String transactionGuid) throws ApiException {
        okhttp3.Call localVarCall = readManagedTransactionValidateBeforeCall(memberGuid, userGuid, transactionGuid, null);
        Type localVarReturnType = new TypeToken<TransactionResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Read managed transaction (asynchronously)
     * Requests to this endpoint will return the attributes of the specified partner-managed &#x60;transaction&#x60;.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param transactionGuid The unique id for a &#x60;transaction&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readManagedTransactionAsync(String memberGuid, String userGuid, String transactionGuid, final ApiCallback<TransactionResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = readManagedTransactionValidateBeforeCall(memberGuid, userGuid, transactionGuid, _callback);
        Type localVarReturnType = new TypeToken<TransactionResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for readMember
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readMemberCall(String memberGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/members/{member_guid}"
            .replaceAll("\\{" + "member_guid" + "\\}", localVarApiClient.escapeString(memberGuid.toString()))
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call readMemberValidateBeforeCall(String memberGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling readMember(Async)");
        }
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling readMember(Async)");
        }
        

        okhttp3.Call localVarCall = readMemberCall(memberGuid, userGuid, _callback);
        return localVarCall;

    }

    /**
     * Read member
     * Use this endpoint to read the attributes of a specific member.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return MemberResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public MemberResponseBody readMember(String memberGuid, String userGuid) throws ApiException {
        ApiResponse<MemberResponseBody> localVarResp = readMemberWithHttpInfo(memberGuid, userGuid);
        return localVarResp.getData();
    }

    /**
     * Read member
     * Use this endpoint to read the attributes of a specific member.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return ApiResponse&lt;MemberResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MemberResponseBody> readMemberWithHttpInfo(String memberGuid, String userGuid) throws ApiException {
        okhttp3.Call localVarCall = readMemberValidateBeforeCall(memberGuid, userGuid, null);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Read member (asynchronously)
     * Use this endpoint to read the attributes of a specific member.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readMemberAsync(String memberGuid, String userGuid, final ApiCallback<MemberResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = readMemberValidateBeforeCall(memberGuid, userGuid, _callback);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for readMemberStatus
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readMemberStatusCall(String memberGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/members/{member_guid}/status"
            .replaceAll("\\{" + "member_guid" + "\\}", localVarApiClient.escapeString(memberGuid.toString()))
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call readMemberStatusValidateBeforeCall(String memberGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling readMemberStatus(Async)");
        }
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling readMemberStatus(Async)");
        }
        

        okhttp3.Call localVarCall = readMemberStatusCall(memberGuid, userGuid, _callback);
        return localVarCall;

    }

    /**
     * Read member status
     * This endpoint provides the status of the members most recent aggregation event. This is an important step in the aggregation process, and the results returned by this endpoint should determine what you do next in order to successfully aggregate a member. MX has introduced new, more detailed information on the current status of a members connection to a financial institution and the state of its aggregation - the connection_status field. These are intended to replace and expand upon the information provided in the status field, which will soon be deprecated; support for the status field remains for the time being.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return MemberStatusResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public MemberStatusResponseBody readMemberStatus(String memberGuid, String userGuid) throws ApiException {
        ApiResponse<MemberStatusResponseBody> localVarResp = readMemberStatusWithHttpInfo(memberGuid, userGuid);
        return localVarResp.getData();
    }

    /**
     * Read member status
     * This endpoint provides the status of the members most recent aggregation event. This is an important step in the aggregation process, and the results returned by this endpoint should determine what you do next in order to successfully aggregate a member. MX has introduced new, more detailed information on the current status of a members connection to a financial institution and the state of its aggregation - the connection_status field. These are intended to replace and expand upon the information provided in the status field, which will soon be deprecated; support for the status field remains for the time being.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return ApiResponse&lt;MemberStatusResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MemberStatusResponseBody> readMemberStatusWithHttpInfo(String memberGuid, String userGuid) throws ApiException {
        okhttp3.Call localVarCall = readMemberStatusValidateBeforeCall(memberGuid, userGuid, null);
        Type localVarReturnType = new TypeToken<MemberStatusResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Read member status (asynchronously)
     * This endpoint provides the status of the members most recent aggregation event. This is an important step in the aggregation process, and the results returned by this endpoint should determine what you do next in order to successfully aggregate a member. MX has introduced new, more detailed information on the current status of a members connection to a financial institution and the state of its aggregation - the connection_status field. These are intended to replace and expand upon the information provided in the status field, which will soon be deprecated; support for the status field remains for the time being.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readMemberStatusAsync(String memberGuid, String userGuid, final ApiCallback<MemberStatusResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = readMemberStatusValidateBeforeCall(memberGuid, userGuid, _callback);
        Type localVarReturnType = new TypeToken<MemberStatusResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for readMerchant
     * @param merchantGuid The unique id for a &#x60;merchant&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readMerchantCall(String merchantGuid, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/merchants/{merchant_guid}"
            .replaceAll("\\{" + "merchant_guid" + "\\}", localVarApiClient.escapeString(merchantGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call readMerchantValidateBeforeCall(String merchantGuid, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'merchantGuid' is set
        if (merchantGuid == null) {
            throw new ApiException("Missing the required parameter 'merchantGuid' when calling readMerchant(Async)");
        }
        

        okhttp3.Call localVarCall = readMerchantCall(merchantGuid, _callback);
        return localVarCall;

    }

    /**
     * Read merchant
     * Returns information about a particular merchant, such as a logo, name, and website.
     * @param merchantGuid The unique id for a &#x60;merchant&#x60;. (required)
     * @return MerchantResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public MerchantResponseBody readMerchant(String merchantGuid) throws ApiException {
        ApiResponse<MerchantResponseBody> localVarResp = readMerchantWithHttpInfo(merchantGuid);
        return localVarResp.getData();
    }

    /**
     * Read merchant
     * Returns information about a particular merchant, such as a logo, name, and website.
     * @param merchantGuid The unique id for a &#x60;merchant&#x60;. (required)
     * @return ApiResponse&lt;MerchantResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MerchantResponseBody> readMerchantWithHttpInfo(String merchantGuid) throws ApiException {
        okhttp3.Call localVarCall = readMerchantValidateBeforeCall(merchantGuid, null);
        Type localVarReturnType = new TypeToken<MerchantResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Read merchant (asynchronously)
     * Returns information about a particular merchant, such as a logo, name, and website.
     * @param merchantGuid The unique id for a &#x60;merchant&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readMerchantAsync(String merchantGuid, final ApiCallback<MerchantResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = readMerchantValidateBeforeCall(merchantGuid, _callback);
        Type localVarReturnType = new TypeToken<MerchantResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for readMerchantLocation
     * @param merchantLocationGuid The unique id for a &#x60;merchant_location&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readMerchantLocationCall(String merchantLocationGuid, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/merchant_locations/{merchant_location_guid}"
            .replaceAll("\\{" + "merchant_location_guid" + "\\}", localVarApiClient.escapeString(merchantLocationGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call readMerchantLocationValidateBeforeCall(String merchantLocationGuid, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'merchantLocationGuid' is set
        if (merchantLocationGuid == null) {
            throw new ApiException("Missing the required parameter 'merchantLocationGuid' when calling readMerchantLocation(Async)");
        }
        

        okhttp3.Call localVarCall = readMerchantLocationCall(merchantLocationGuid, _callback);
        return localVarCall;

    }

    /**
     * Read merchant location
     * This endpoint returns the specified merchant_location resource.
     * @param merchantLocationGuid The unique id for a &#x60;merchant_location&#x60;. (required)
     * @return MerchantLocationResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public MerchantLocationResponseBody readMerchantLocation(String merchantLocationGuid) throws ApiException {
        ApiResponse<MerchantLocationResponseBody> localVarResp = readMerchantLocationWithHttpInfo(merchantLocationGuid);
        return localVarResp.getData();
    }

    /**
     * Read merchant location
     * This endpoint returns the specified merchant_location resource.
     * @param merchantLocationGuid The unique id for a &#x60;merchant_location&#x60;. (required)
     * @return ApiResponse&lt;MerchantLocationResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MerchantLocationResponseBody> readMerchantLocationWithHttpInfo(String merchantLocationGuid) throws ApiException {
        okhttp3.Call localVarCall = readMerchantLocationValidateBeforeCall(merchantLocationGuid, null);
        Type localVarReturnType = new TypeToken<MerchantLocationResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Read merchant location (asynchronously)
     * This endpoint returns the specified merchant_location resource.
     * @param merchantLocationGuid The unique id for a &#x60;merchant_location&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readMerchantLocationAsync(String merchantLocationGuid, final ApiCallback<MerchantLocationResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = readMerchantLocationValidateBeforeCall(merchantLocationGuid, _callback);
        Type localVarReturnType = new TypeToken<MerchantLocationResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for readStatementByMember
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param statementGuid The unique id for a &#x60;statement&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readStatementByMemberCall(String memberGuid, String statementGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/members/{member_guid}/statements/{statement_guid}"
            .replaceAll("\\{" + "member_guid" + "\\}", localVarApiClient.escapeString(memberGuid.toString()))
            .replaceAll("\\{" + "statement_guid" + "\\}", localVarApiClient.escapeString(statementGuid.toString()))
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call readStatementByMemberValidateBeforeCall(String memberGuid, String statementGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling readStatementByMember(Async)");
        }
        
        // verify the required parameter 'statementGuid' is set
        if (statementGuid == null) {
            throw new ApiException("Missing the required parameter 'statementGuid' when calling readStatementByMember(Async)");
        }
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling readStatementByMember(Async)");
        }
        

        okhttp3.Call localVarCall = readStatementByMemberCall(memberGuid, statementGuid, userGuid, _callback);
        return localVarCall;

    }

    /**
     * Read statement by member
     * Use this endpoint to read a JSON representation of the statement.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param statementGuid The unique id for a &#x60;statement&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return StatementResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public StatementResponseBody readStatementByMember(String memberGuid, String statementGuid, String userGuid) throws ApiException {
        ApiResponse<StatementResponseBody> localVarResp = readStatementByMemberWithHttpInfo(memberGuid, statementGuid, userGuid);
        return localVarResp.getData();
    }

    /**
     * Read statement by member
     * Use this endpoint to read a JSON representation of the statement.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param statementGuid The unique id for a &#x60;statement&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return ApiResponse&lt;StatementResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<StatementResponseBody> readStatementByMemberWithHttpInfo(String memberGuid, String statementGuid, String userGuid) throws ApiException {
        okhttp3.Call localVarCall = readStatementByMemberValidateBeforeCall(memberGuid, statementGuid, userGuid, null);
        Type localVarReturnType = new TypeToken<StatementResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Read statement by member (asynchronously)
     * Use this endpoint to read a JSON representation of the statement.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param statementGuid The unique id for a &#x60;statement&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readStatementByMemberAsync(String memberGuid, String statementGuid, String userGuid, final ApiCallback<StatementResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = readStatementByMemberValidateBeforeCall(memberGuid, statementGuid, userGuid, _callback);
        Type localVarReturnType = new TypeToken<StatementResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for readTag
     * @param tagGuid The unique id for a &#x60;tag&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readTagCall(String tagGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/tags/{tag_guid}"
            .replaceAll("\\{" + "tag_guid" + "\\}", localVarApiClient.escapeString(tagGuid.toString()))
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call readTagValidateBeforeCall(String tagGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'tagGuid' is set
        if (tagGuid == null) {
            throw new ApiException("Missing the required parameter 'tagGuid' when calling readTag(Async)");
        }
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling readTag(Async)");
        }
        

        okhttp3.Call localVarCall = readTagCall(tagGuid, userGuid, _callback);
        return localVarCall;

    }

    /**
     * Read tag
     * Use this endpoint to read the attributes of a particular tag according to its unique GUID.
     * @param tagGuid The unique id for a &#x60;tag&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return TagResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public TagResponseBody readTag(String tagGuid, String userGuid) throws ApiException {
        ApiResponse<TagResponseBody> localVarResp = readTagWithHttpInfo(tagGuid, userGuid);
        return localVarResp.getData();
    }

    /**
     * Read tag
     * Use this endpoint to read the attributes of a particular tag according to its unique GUID.
     * @param tagGuid The unique id for a &#x60;tag&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return ApiResponse&lt;TagResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TagResponseBody> readTagWithHttpInfo(String tagGuid, String userGuid) throws ApiException {
        okhttp3.Call localVarCall = readTagValidateBeforeCall(tagGuid, userGuid, null);
        Type localVarReturnType = new TypeToken<TagResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Read tag (asynchronously)
     * Use this endpoint to read the attributes of a particular tag according to its unique GUID.
     * @param tagGuid The unique id for a &#x60;tag&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readTagAsync(String tagGuid, String userGuid, final ApiCallback<TagResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = readTagValidateBeforeCall(tagGuid, userGuid, _callback);
        Type localVarReturnType = new TypeToken<TagResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for readTagging
     * @param taggingGuid The unique id for a &#x60;tagging&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readTaggingCall(String taggingGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/taggings/{tagging_guid}"
            .replaceAll("\\{" + "tagging_guid" + "\\}", localVarApiClient.escapeString(taggingGuid.toString()))
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call readTaggingValidateBeforeCall(String taggingGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'taggingGuid' is set
        if (taggingGuid == null) {
            throw new ApiException("Missing the required parameter 'taggingGuid' when calling readTagging(Async)");
        }
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling readTagging(Async)");
        }
        

        okhttp3.Call localVarCall = readTaggingCall(taggingGuid, userGuid, _callback);
        return localVarCall;

    }

    /**
     * Read tagging
     * Use this endpoint to read the attributes of a &#x60;tagging&#x60; according to its unique GUID.
     * @param taggingGuid The unique id for a &#x60;tagging&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return TaggingResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public TaggingResponseBody readTagging(String taggingGuid, String userGuid) throws ApiException {
        ApiResponse<TaggingResponseBody> localVarResp = readTaggingWithHttpInfo(taggingGuid, userGuid);
        return localVarResp.getData();
    }

    /**
     * Read tagging
     * Use this endpoint to read the attributes of a &#x60;tagging&#x60; according to its unique GUID.
     * @param taggingGuid The unique id for a &#x60;tagging&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return ApiResponse&lt;TaggingResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TaggingResponseBody> readTaggingWithHttpInfo(String taggingGuid, String userGuid) throws ApiException {
        okhttp3.Call localVarCall = readTaggingValidateBeforeCall(taggingGuid, userGuid, null);
        Type localVarReturnType = new TypeToken<TaggingResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Read tagging (asynchronously)
     * Use this endpoint to read the attributes of a &#x60;tagging&#x60; according to its unique GUID.
     * @param taggingGuid The unique id for a &#x60;tagging&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readTaggingAsync(String taggingGuid, String userGuid, final ApiCallback<TaggingResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = readTaggingValidateBeforeCall(taggingGuid, userGuid, _callback);
        Type localVarReturnType = new TypeToken<TaggingResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for readTransaction
     * @param transactionGuid The unique id for a &#x60;transaction&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readTransactionCall(String transactionGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/transactions/{transaction_guid}"
            .replaceAll("\\{" + "transaction_guid" + "\\}", localVarApiClient.escapeString(transactionGuid.toString()))
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call readTransactionValidateBeforeCall(String transactionGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'transactionGuid' is set
        if (transactionGuid == null) {
            throw new ApiException("Missing the required parameter 'transactionGuid' when calling readTransaction(Async)");
        }
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling readTransaction(Async)");
        }
        

        okhttp3.Call localVarCall = readTransactionCall(transactionGuid, userGuid, _callback);
        return localVarCall;

    }

    /**
     * Read transaction
     * Requests to this endpoint will return the attributes of the specified &#x60;transaction&#x60;.
     * @param transactionGuid The unique id for a &#x60;transaction&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return TransactionResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public TransactionResponseBody readTransaction(String transactionGuid, String userGuid) throws ApiException {
        ApiResponse<TransactionResponseBody> localVarResp = readTransactionWithHttpInfo(transactionGuid, userGuid);
        return localVarResp.getData();
    }

    /**
     * Read transaction
     * Requests to this endpoint will return the attributes of the specified &#x60;transaction&#x60;.
     * @param transactionGuid The unique id for a &#x60;transaction&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return ApiResponse&lt;TransactionResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TransactionResponseBody> readTransactionWithHttpInfo(String transactionGuid, String userGuid) throws ApiException {
        okhttp3.Call localVarCall = readTransactionValidateBeforeCall(transactionGuid, userGuid, null);
        Type localVarReturnType = new TypeToken<TransactionResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Read transaction (asynchronously)
     * Requests to this endpoint will return the attributes of the specified &#x60;transaction&#x60;.
     * @param transactionGuid The unique id for a &#x60;transaction&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readTransactionAsync(String transactionGuid, String userGuid, final ApiCallback<TransactionResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = readTransactionValidateBeforeCall(transactionGuid, userGuid, _callback);
        Type localVarReturnType = new TypeToken<TransactionResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for readTransactionRule
     * @param transactionRuleGuid The unique id for a &#x60;transaction_rule&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readTransactionRuleCall(String transactionRuleGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/transaction_rules/{transaction_rule_guid}"
            .replaceAll("\\{" + "transaction_rule_guid" + "\\}", localVarApiClient.escapeString(transactionRuleGuid.toString()))
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call readTransactionRuleValidateBeforeCall(String transactionRuleGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'transactionRuleGuid' is set
        if (transactionRuleGuid == null) {
            throw new ApiException("Missing the required parameter 'transactionRuleGuid' when calling readTransactionRule(Async)");
        }
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling readTransactionRule(Async)");
        }
        

        okhttp3.Call localVarCall = readTransactionRuleCall(transactionRuleGuid, userGuid, _callback);
        return localVarCall;

    }

    /**
     * Read transaction rule
     * Use this endpoint to read the attributes of an existing transaction rule based on the rule’s unique GUID.
     * @param transactionRuleGuid The unique id for a &#x60;transaction_rule&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return TransactionRuleResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public TransactionRuleResponseBody readTransactionRule(String transactionRuleGuid, String userGuid) throws ApiException {
        ApiResponse<TransactionRuleResponseBody> localVarResp = readTransactionRuleWithHttpInfo(transactionRuleGuid, userGuid);
        return localVarResp.getData();
    }

    /**
     * Read transaction rule
     * Use this endpoint to read the attributes of an existing transaction rule based on the rule’s unique GUID.
     * @param transactionRuleGuid The unique id for a &#x60;transaction_rule&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return ApiResponse&lt;TransactionRuleResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TransactionRuleResponseBody> readTransactionRuleWithHttpInfo(String transactionRuleGuid, String userGuid) throws ApiException {
        okhttp3.Call localVarCall = readTransactionRuleValidateBeforeCall(transactionRuleGuid, userGuid, null);
        Type localVarReturnType = new TypeToken<TransactionRuleResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Read transaction rule (asynchronously)
     * Use this endpoint to read the attributes of an existing transaction rule based on the rule’s unique GUID.
     * @param transactionRuleGuid The unique id for a &#x60;transaction_rule&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readTransactionRuleAsync(String transactionRuleGuid, String userGuid, final ApiCallback<TransactionRuleResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = readTransactionRuleValidateBeforeCall(transactionRuleGuid, userGuid, _callback);
        Type localVarReturnType = new TypeToken<TransactionRuleResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for readUser
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readUserCall(String userGuid, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}"
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call readUserValidateBeforeCall(String userGuid, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling readUser(Async)");
        }
        

        okhttp3.Call localVarCall = readUserCall(userGuid, _callback);
        return localVarCall;

    }

    /**
     * Read user
     * Use this endpoint to read the attributes of a specific user.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return UserResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public UserResponseBody readUser(String userGuid) throws ApiException {
        ApiResponse<UserResponseBody> localVarResp = readUserWithHttpInfo(userGuid);
        return localVarResp.getData();
    }

    /**
     * Read user
     * Use this endpoint to read the attributes of a specific user.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return ApiResponse&lt;UserResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<UserResponseBody> readUserWithHttpInfo(String userGuid) throws ApiException {
        okhttp3.Call localVarCall = readUserValidateBeforeCall(userGuid, null);
        Type localVarReturnType = new TypeToken<UserResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Read user (asynchronously)
     * Use this endpoint to read the attributes of a specific user.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call readUserAsync(String userGuid, final ApiCallback<UserResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = readUserValidateBeforeCall(userGuid, _callback);
        Type localVarReturnType = new TypeToken<UserResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for requestConnectWidgetURL
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param connectWidgetRequestBody Optional config options for WebView (is_mobile_webview, current_institution_code, current_member_guid, update_credentials) (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call requestConnectWidgetURLCall(String userGuid, ConnectWidgetRequestBody connectWidgetRequestBody, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = connectWidgetRequestBody;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/connect_widget_url"
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call requestConnectWidgetURLValidateBeforeCall(String userGuid, ConnectWidgetRequestBody connectWidgetRequestBody, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling requestConnectWidgetURL(Async)");
        }
        

        okhttp3.Call localVarCall = requestConnectWidgetURLCall(userGuid, connectWidgetRequestBody, _callback);
        return localVarCall;

    }

    /**
     * Request connect widget url
     * This endpoint will return a URL for an embeddable version of MX Connect.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param connectWidgetRequestBody Optional config options for WebView (is_mobile_webview, current_institution_code, current_member_guid, update_credentials) (optional)
     * @return ConnectWidgetResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ConnectWidgetResponseBody requestConnectWidgetURL(String userGuid, ConnectWidgetRequestBody connectWidgetRequestBody) throws ApiException {
        ApiResponse<ConnectWidgetResponseBody> localVarResp = requestConnectWidgetURLWithHttpInfo(userGuid, connectWidgetRequestBody);
        return localVarResp.getData();
    }

    /**
     * Request connect widget url
     * This endpoint will return a URL for an embeddable version of MX Connect.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param connectWidgetRequestBody Optional config options for WebView (is_mobile_webview, current_institution_code, current_member_guid, update_credentials) (optional)
     * @return ApiResponse&lt;ConnectWidgetResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ConnectWidgetResponseBody> requestConnectWidgetURLWithHttpInfo(String userGuid, ConnectWidgetRequestBody connectWidgetRequestBody) throws ApiException {
        okhttp3.Call localVarCall = requestConnectWidgetURLValidateBeforeCall(userGuid, connectWidgetRequestBody, null);
        Type localVarReturnType = new TypeToken<ConnectWidgetResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Request connect widget url (asynchronously)
     * This endpoint will return a URL for an embeddable version of MX Connect.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param connectWidgetRequestBody Optional config options for WebView (is_mobile_webview, current_institution_code, current_member_guid, update_credentials) (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call requestConnectWidgetURLAsync(String userGuid, ConnectWidgetRequestBody connectWidgetRequestBody, final ApiCallback<ConnectWidgetResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = requestConnectWidgetURLValidateBeforeCall(userGuid, connectWidgetRequestBody, _callback);
        Type localVarReturnType = new TypeToken<ConnectWidgetResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for requestOAuthWindowURI
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param referralSource Must be either &#x60;BROWSER&#x60; or &#x60;APP&#x60; depending on the implementation. Defaults to &#x60;BROWSER&#x60;. (optional)
     * @param uiMessageWebviewUrlScheme A scheme for routing the user back to the application state they were previously in. (optional)
     * @param skipAggregation Setting this parameter to &#x60;true&#x60; will prevent the member from automatically aggregating after being redirected from the authorization page. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call requestOAuthWindowURICall(String memberGuid, String userGuid, String referralSource, String uiMessageWebviewUrlScheme, Boolean skipAggregation, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/members/{member_guid}/oauth_window_uri"
            .replaceAll("\\{" + "member_guid" + "\\}", localVarApiClient.escapeString(memberGuid.toString()))
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (referralSource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("referral_source", referralSource));
        }

        if (uiMessageWebviewUrlScheme != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("ui_message_webview_url_scheme", uiMessageWebviewUrlScheme));
        }

        if (skipAggregation != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("skip_aggregation", skipAggregation));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call requestOAuthWindowURIValidateBeforeCall(String memberGuid, String userGuid, String referralSource, String uiMessageWebviewUrlScheme, Boolean skipAggregation, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling requestOAuthWindowURI(Async)");
        }
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling requestOAuthWindowURI(Async)");
        }
        

        okhttp3.Call localVarCall = requestOAuthWindowURICall(memberGuid, userGuid, referralSource, uiMessageWebviewUrlScheme, skipAggregation, _callback);
        return localVarCall;

    }

    /**
     * Request oauth window uri
     * This endpoint will generate an &#x60;oauth_window_uri&#x60; for the specified &#x60;member&#x60;.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param referralSource Must be either &#x60;BROWSER&#x60; or &#x60;APP&#x60; depending on the implementation. Defaults to &#x60;BROWSER&#x60;. (optional)
     * @param uiMessageWebviewUrlScheme A scheme for routing the user back to the application state they were previously in. (optional)
     * @param skipAggregation Setting this parameter to &#x60;true&#x60; will prevent the member from automatically aggregating after being redirected from the authorization page. (optional)
     * @return OAuthWindowResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public OAuthWindowResponseBody requestOAuthWindowURI(String memberGuid, String userGuid, String referralSource, String uiMessageWebviewUrlScheme, Boolean skipAggregation) throws ApiException {
        ApiResponse<OAuthWindowResponseBody> localVarResp = requestOAuthWindowURIWithHttpInfo(memberGuid, userGuid, referralSource, uiMessageWebviewUrlScheme, skipAggregation);
        return localVarResp.getData();
    }

    /**
     * Request oauth window uri
     * This endpoint will generate an &#x60;oauth_window_uri&#x60; for the specified &#x60;member&#x60;.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param referralSource Must be either &#x60;BROWSER&#x60; or &#x60;APP&#x60; depending on the implementation. Defaults to &#x60;BROWSER&#x60;. (optional)
     * @param uiMessageWebviewUrlScheme A scheme for routing the user back to the application state they were previously in. (optional)
     * @param skipAggregation Setting this parameter to &#x60;true&#x60; will prevent the member from automatically aggregating after being redirected from the authorization page. (optional)
     * @return ApiResponse&lt;OAuthWindowResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<OAuthWindowResponseBody> requestOAuthWindowURIWithHttpInfo(String memberGuid, String userGuid, String referralSource, String uiMessageWebviewUrlScheme, Boolean skipAggregation) throws ApiException {
        okhttp3.Call localVarCall = requestOAuthWindowURIValidateBeforeCall(memberGuid, userGuid, referralSource, uiMessageWebviewUrlScheme, skipAggregation, null);
        Type localVarReturnType = new TypeToken<OAuthWindowResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Request oauth window uri (asynchronously)
     * This endpoint will generate an &#x60;oauth_window_uri&#x60; for the specified &#x60;member&#x60;.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param referralSource Must be either &#x60;BROWSER&#x60; or &#x60;APP&#x60; depending on the implementation. Defaults to &#x60;BROWSER&#x60;. (optional)
     * @param uiMessageWebviewUrlScheme A scheme for routing the user back to the application state they were previously in. (optional)
     * @param skipAggregation Setting this parameter to &#x60;true&#x60; will prevent the member from automatically aggregating after being redirected from the authorization page. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call requestOAuthWindowURIAsync(String memberGuid, String userGuid, String referralSource, String uiMessageWebviewUrlScheme, Boolean skipAggregation, final ApiCallback<OAuthWindowResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = requestOAuthWindowURIValidateBeforeCall(memberGuid, userGuid, referralSource, uiMessageWebviewUrlScheme, skipAggregation, _callback);
        Type localVarReturnType = new TypeToken<OAuthWindowResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for requestWidgetURL
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param widgetRequestBody The widget url configuration options. (required)
     * @param acceptLanguage The desired language of the widget. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call requestWidgetURLCall(String userGuid, WidgetRequestBody widgetRequestBody, String acceptLanguage, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = widgetRequestBody;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/widget_urls"
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (acceptLanguage != null) {
            localVarHeaderParams.put("Accept-Language", localVarApiClient.parameterToString(acceptLanguage));
        }

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call requestWidgetURLValidateBeforeCall(String userGuid, WidgetRequestBody widgetRequestBody, String acceptLanguage, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling requestWidgetURL(Async)");
        }
        
        // verify the required parameter 'widgetRequestBody' is set
        if (widgetRequestBody == null) {
            throw new ApiException("Missing the required parameter 'widgetRequestBody' when calling requestWidgetURL(Async)");
        }
        

        okhttp3.Call localVarCall = requestWidgetURLCall(userGuid, widgetRequestBody, acceptLanguage, _callback);
        return localVarCall;

    }

    /**
     * Request widget url
     * This endpoint allows partners to get a URL by passing the &#x60;widget_type&#x60; in the request body, as well as configuring it in several different ways. In the case of Connect, that means setting the &#x60;widget_type&#x60; to &#x60;connect_widget&#x60;. Partners may also pass an optional &#x60;Accept-Language&#x60; header as well as a number of configuration options. Note that this is a &#x60;POST&#x60; request.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param widgetRequestBody The widget url configuration options. (required)
     * @param acceptLanguage The desired language of the widget. (optional)
     * @return WidgetResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public WidgetResponseBody requestWidgetURL(String userGuid, WidgetRequestBody widgetRequestBody, String acceptLanguage) throws ApiException {
        ApiResponse<WidgetResponseBody> localVarResp = requestWidgetURLWithHttpInfo(userGuid, widgetRequestBody, acceptLanguage);
        return localVarResp.getData();
    }

    /**
     * Request widget url
     * This endpoint allows partners to get a URL by passing the &#x60;widget_type&#x60; in the request body, as well as configuring it in several different ways. In the case of Connect, that means setting the &#x60;widget_type&#x60; to &#x60;connect_widget&#x60;. Partners may also pass an optional &#x60;Accept-Language&#x60; header as well as a number of configuration options. Note that this is a &#x60;POST&#x60; request.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param widgetRequestBody The widget url configuration options. (required)
     * @param acceptLanguage The desired language of the widget. (optional)
     * @return ApiResponse&lt;WidgetResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<WidgetResponseBody> requestWidgetURLWithHttpInfo(String userGuid, WidgetRequestBody widgetRequestBody, String acceptLanguage) throws ApiException {
        okhttp3.Call localVarCall = requestWidgetURLValidateBeforeCall(userGuid, widgetRequestBody, acceptLanguage, null);
        Type localVarReturnType = new TypeToken<WidgetResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Request widget url (asynchronously)
     * This endpoint allows partners to get a URL by passing the &#x60;widget_type&#x60; in the request body, as well as configuring it in several different ways. In the case of Connect, that means setting the &#x60;widget_type&#x60; to &#x60;connect_widget&#x60;. Partners may also pass an optional &#x60;Accept-Language&#x60; header as well as a number of configuration options. Note that this is a &#x60;POST&#x60; request.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param widgetRequestBody The widget url configuration options. (required)
     * @param acceptLanguage The desired language of the widget. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call requestWidgetURLAsync(String userGuid, WidgetRequestBody widgetRequestBody, String acceptLanguage, final ApiCallback<WidgetResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = requestWidgetURLValidateBeforeCall(userGuid, widgetRequestBody, acceptLanguage, _callback);
        Type localVarReturnType = new TypeToken<WidgetResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for resumeAggregation
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberResumeRequestBody Member object with MFA challenge answers (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call resumeAggregationCall(String memberGuid, String userGuid, MemberResumeRequestBody memberResumeRequestBody, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = memberResumeRequestBody;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/members/{member_guid}/resume"
            .replaceAll("\\{" + "member_guid" + "\\}", localVarApiClient.escapeString(memberGuid.toString()))
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call resumeAggregationValidateBeforeCall(String memberGuid, String userGuid, MemberResumeRequestBody memberResumeRequestBody, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling resumeAggregation(Async)");
        }
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling resumeAggregation(Async)");
        }
        
        // verify the required parameter 'memberResumeRequestBody' is set
        if (memberResumeRequestBody == null) {
            throw new ApiException("Missing the required parameter 'memberResumeRequestBody' when calling resumeAggregation(Async)");
        }
        

        okhttp3.Call localVarCall = resumeAggregationCall(memberGuid, userGuid, memberResumeRequestBody, _callback);
        return localVarCall;

    }

    /**
     * Resume aggregation
     * This endpoint answers the challenges needed when a member has been challenged by multi-factor authentication.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberResumeRequestBody Member object with MFA challenge answers (required)
     * @return MemberResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public MemberResponseBody resumeAggregation(String memberGuid, String userGuid, MemberResumeRequestBody memberResumeRequestBody) throws ApiException {
        ApiResponse<MemberResponseBody> localVarResp = resumeAggregationWithHttpInfo(memberGuid, userGuid, memberResumeRequestBody);
        return localVarResp.getData();
    }

    /**
     * Resume aggregation
     * This endpoint answers the challenges needed when a member has been challenged by multi-factor authentication.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberResumeRequestBody Member object with MFA challenge answers (required)
     * @return ApiResponse&lt;MemberResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MemberResponseBody> resumeAggregationWithHttpInfo(String memberGuid, String userGuid, MemberResumeRequestBody memberResumeRequestBody) throws ApiException {
        okhttp3.Call localVarCall = resumeAggregationValidateBeforeCall(memberGuid, userGuid, memberResumeRequestBody, null);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Resume aggregation (asynchronously)
     * This endpoint answers the challenges needed when a member has been challenged by multi-factor authentication.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberResumeRequestBody Member object with MFA challenge answers (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call resumeAggregationAsync(String memberGuid, String userGuid, MemberResumeRequestBody memberResumeRequestBody, final ApiCallback<MemberResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = resumeAggregationValidateBeforeCall(memberGuid, userGuid, memberResumeRequestBody, _callback);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateAccountByMember
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param accountUpdateRequestBody Account object to be created with optional parameters (is_hidden) (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateAccountByMemberCall(String userGuid, String memberGuid, String accountGuid, AccountUpdateRequestBody accountUpdateRequestBody, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = accountUpdateRequestBody;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/members/{member_guid}/accounts/{account_guid}"
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()))
            .replaceAll("\\{" + "member_guid" + "\\}", localVarApiClient.escapeString(memberGuid.toString()))
            .replaceAll("\\{" + "account_guid" + "\\}", localVarApiClient.escapeString(accountGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateAccountByMemberValidateBeforeCall(String userGuid, String memberGuid, String accountGuid, AccountUpdateRequestBody accountUpdateRequestBody, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling updateAccountByMember(Async)");
        }
        
        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling updateAccountByMember(Async)");
        }
        
        // verify the required parameter 'accountGuid' is set
        if (accountGuid == null) {
            throw new ApiException("Missing the required parameter 'accountGuid' when calling updateAccountByMember(Async)");
        }
        
        // verify the required parameter 'accountUpdateRequestBody' is set
        if (accountUpdateRequestBody == null) {
            throw new ApiException("Missing the required parameter 'accountUpdateRequestBody' when calling updateAccountByMember(Async)");
        }
        

        okhttp3.Call localVarCall = updateAccountByMemberCall(userGuid, memberGuid, accountGuid, accountUpdateRequestBody, _callback);
        return localVarCall;

    }

    /**
     * Update account by member
     * This endpoint allows you to update certain attributes of an &#x60;account&#x60; resource.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param accountUpdateRequestBody Account object to be created with optional parameters (is_hidden) (required)
     * @return AccountResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public AccountResponseBody updateAccountByMember(String userGuid, String memberGuid, String accountGuid, AccountUpdateRequestBody accountUpdateRequestBody) throws ApiException {
        ApiResponse<AccountResponseBody> localVarResp = updateAccountByMemberWithHttpInfo(userGuid, memberGuid, accountGuid, accountUpdateRequestBody);
        return localVarResp.getData();
    }

    /**
     * Update account by member
     * This endpoint allows you to update certain attributes of an &#x60;account&#x60; resource.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param accountUpdateRequestBody Account object to be created with optional parameters (is_hidden) (required)
     * @return ApiResponse&lt;AccountResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<AccountResponseBody> updateAccountByMemberWithHttpInfo(String userGuid, String memberGuid, String accountGuid, AccountUpdateRequestBody accountUpdateRequestBody) throws ApiException {
        okhttp3.Call localVarCall = updateAccountByMemberValidateBeforeCall(userGuid, memberGuid, accountGuid, accountUpdateRequestBody, null);
        Type localVarReturnType = new TypeToken<AccountResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Update account by member (asynchronously)
     * This endpoint allows you to update certain attributes of an &#x60;account&#x60; resource.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param accountUpdateRequestBody Account object to be created with optional parameters (is_hidden) (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateAccountByMemberAsync(String userGuid, String memberGuid, String accountGuid, AccountUpdateRequestBody accountUpdateRequestBody, final ApiCallback<AccountResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateAccountByMemberValidateBeforeCall(userGuid, memberGuid, accountGuid, accountUpdateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<AccountResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateCategory
     * @param categoryGuid The unique id for a &#x60;category&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param categoryUpdateRequestBody Category object to be updated (While no single parameter is required, the &#x60;category&#x60; object cannot be empty) (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateCategoryCall(String categoryGuid, String userGuid, CategoryUpdateRequestBody categoryUpdateRequestBody, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = categoryUpdateRequestBody;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/categories/{category_guid}"
            .replaceAll("\\{" + "category_guid" + "\\}", localVarApiClient.escapeString(categoryGuid.toString()))
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateCategoryValidateBeforeCall(String categoryGuid, String userGuid, CategoryUpdateRequestBody categoryUpdateRequestBody, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'categoryGuid' is set
        if (categoryGuid == null) {
            throw new ApiException("Missing the required parameter 'categoryGuid' when calling updateCategory(Async)");
        }
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling updateCategory(Async)");
        }
        
        // verify the required parameter 'categoryUpdateRequestBody' is set
        if (categoryUpdateRequestBody == null) {
            throw new ApiException("Missing the required parameter 'categoryUpdateRequestBody' when calling updateCategory(Async)");
        }
        

        okhttp3.Call localVarCall = updateCategoryCall(categoryGuid, userGuid, categoryUpdateRequestBody, _callback);
        return localVarCall;

    }

    /**
     * Update category
     * Use this endpoint to update the attributes of a custom category according to its unique GUID.
     * @param categoryGuid The unique id for a &#x60;category&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param categoryUpdateRequestBody Category object to be updated (While no single parameter is required, the &#x60;category&#x60; object cannot be empty) (required)
     * @return CategoryResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public CategoryResponseBody updateCategory(String categoryGuid, String userGuid, CategoryUpdateRequestBody categoryUpdateRequestBody) throws ApiException {
        ApiResponse<CategoryResponseBody> localVarResp = updateCategoryWithHttpInfo(categoryGuid, userGuid, categoryUpdateRequestBody);
        return localVarResp.getData();
    }

    /**
     * Update category
     * Use this endpoint to update the attributes of a custom category according to its unique GUID.
     * @param categoryGuid The unique id for a &#x60;category&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param categoryUpdateRequestBody Category object to be updated (While no single parameter is required, the &#x60;category&#x60; object cannot be empty) (required)
     * @return ApiResponse&lt;CategoryResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CategoryResponseBody> updateCategoryWithHttpInfo(String categoryGuid, String userGuid, CategoryUpdateRequestBody categoryUpdateRequestBody) throws ApiException {
        okhttp3.Call localVarCall = updateCategoryValidateBeforeCall(categoryGuid, userGuid, categoryUpdateRequestBody, null);
        Type localVarReturnType = new TypeToken<CategoryResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Update category (asynchronously)
     * Use this endpoint to update the attributes of a custom category according to its unique GUID.
     * @param categoryGuid The unique id for a &#x60;category&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param categoryUpdateRequestBody Category object to be updated (While no single parameter is required, the &#x60;category&#x60; object cannot be empty) (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateCategoryAsync(String categoryGuid, String userGuid, CategoryUpdateRequestBody categoryUpdateRequestBody, final ApiCallback<CategoryResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateCategoryValidateBeforeCall(categoryGuid, userGuid, categoryUpdateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<CategoryResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateManagedAccount
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param managedAccountUpdateRequestBody Managed account object to be updated (While no single parameter is required, the request body can&#39;t be empty) (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateManagedAccountCall(String memberGuid, String userGuid, String accountGuid, ManagedAccountUpdateRequestBody managedAccountUpdateRequestBody, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = managedAccountUpdateRequestBody;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/managed_members/{member_guid}/accounts/{account_guid}"
            .replaceAll("\\{" + "member_guid" + "\\}", localVarApiClient.escapeString(memberGuid.toString()))
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()))
            .replaceAll("\\{" + "account_guid" + "\\}", localVarApiClient.escapeString(accountGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateManagedAccountValidateBeforeCall(String memberGuid, String userGuid, String accountGuid, ManagedAccountUpdateRequestBody managedAccountUpdateRequestBody, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling updateManagedAccount(Async)");
        }
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling updateManagedAccount(Async)");
        }
        
        // verify the required parameter 'accountGuid' is set
        if (accountGuid == null) {
            throw new ApiException("Missing the required parameter 'accountGuid' when calling updateManagedAccount(Async)");
        }
        
        // verify the required parameter 'managedAccountUpdateRequestBody' is set
        if (managedAccountUpdateRequestBody == null) {
            throw new ApiException("Missing the required parameter 'managedAccountUpdateRequestBody' when calling updateManagedAccount(Async)");
        }
        

        okhttp3.Call localVarCall = updateManagedAccountCall(memberGuid, userGuid, accountGuid, managedAccountUpdateRequestBody, _callback);
        return localVarCall;

    }

    /**
     * Update managed account
     * Use this endpoint to update the attributes of a partner-managed account according to its unique GUID.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param managedAccountUpdateRequestBody Managed account object to be updated (While no single parameter is required, the request body can&#39;t be empty) (required)
     * @return AccountResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public AccountResponseBody updateManagedAccount(String memberGuid, String userGuid, String accountGuid, ManagedAccountUpdateRequestBody managedAccountUpdateRequestBody) throws ApiException {
        ApiResponse<AccountResponseBody> localVarResp = updateManagedAccountWithHttpInfo(memberGuid, userGuid, accountGuid, managedAccountUpdateRequestBody);
        return localVarResp.getData();
    }

    /**
     * Update managed account
     * Use this endpoint to update the attributes of a partner-managed account according to its unique GUID.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param managedAccountUpdateRequestBody Managed account object to be updated (While no single parameter is required, the request body can&#39;t be empty) (required)
     * @return ApiResponse&lt;AccountResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<AccountResponseBody> updateManagedAccountWithHttpInfo(String memberGuid, String userGuid, String accountGuid, ManagedAccountUpdateRequestBody managedAccountUpdateRequestBody) throws ApiException {
        okhttp3.Call localVarCall = updateManagedAccountValidateBeforeCall(memberGuid, userGuid, accountGuid, managedAccountUpdateRequestBody, null);
        Type localVarReturnType = new TypeToken<AccountResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Update managed account (asynchronously)
     * Use this endpoint to update the attributes of a partner-managed account according to its unique GUID.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param accountGuid The unique id for an &#x60;account&#x60;. (required)
     * @param managedAccountUpdateRequestBody Managed account object to be updated (While no single parameter is required, the request body can&#39;t be empty) (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateManagedAccountAsync(String memberGuid, String userGuid, String accountGuid, ManagedAccountUpdateRequestBody managedAccountUpdateRequestBody, final ApiCallback<AccountResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateManagedAccountValidateBeforeCall(memberGuid, userGuid, accountGuid, managedAccountUpdateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<AccountResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateManagedMember
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param managedMemberUpdateRequestBody Managed member object to be updated (While no single parameter is required, the request body can&#39;t be empty) (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateManagedMemberCall(String memberGuid, String userGuid, ManagedMemberUpdateRequestBody managedMemberUpdateRequestBody, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = managedMemberUpdateRequestBody;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/managed_members/{member_guid}"
            .replaceAll("\\{" + "member_guid" + "\\}", localVarApiClient.escapeString(memberGuid.toString()))
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateManagedMemberValidateBeforeCall(String memberGuid, String userGuid, ManagedMemberUpdateRequestBody managedMemberUpdateRequestBody, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling updateManagedMember(Async)");
        }
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling updateManagedMember(Async)");
        }
        
        // verify the required parameter 'managedMemberUpdateRequestBody' is set
        if (managedMemberUpdateRequestBody == null) {
            throw new ApiException("Missing the required parameter 'managedMemberUpdateRequestBody' when calling updateManagedMember(Async)");
        }
        

        okhttp3.Call localVarCall = updateManagedMemberCall(memberGuid, userGuid, managedMemberUpdateRequestBody, _callback);
        return localVarCall;

    }

    /**
     * Update managed member
     * Use this endpoint to update the attributes of the specified partner_managed &#x60;member&#x60;.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param managedMemberUpdateRequestBody Managed member object to be updated (While no single parameter is required, the request body can&#39;t be empty) (required)
     * @return MemberResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public MemberResponseBody updateManagedMember(String memberGuid, String userGuid, ManagedMemberUpdateRequestBody managedMemberUpdateRequestBody) throws ApiException {
        ApiResponse<MemberResponseBody> localVarResp = updateManagedMemberWithHttpInfo(memberGuid, userGuid, managedMemberUpdateRequestBody);
        return localVarResp.getData();
    }

    /**
     * Update managed member
     * Use this endpoint to update the attributes of the specified partner_managed &#x60;member&#x60;.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param managedMemberUpdateRequestBody Managed member object to be updated (While no single parameter is required, the request body can&#39;t be empty) (required)
     * @return ApiResponse&lt;MemberResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MemberResponseBody> updateManagedMemberWithHttpInfo(String memberGuid, String userGuid, ManagedMemberUpdateRequestBody managedMemberUpdateRequestBody) throws ApiException {
        okhttp3.Call localVarCall = updateManagedMemberValidateBeforeCall(memberGuid, userGuid, managedMemberUpdateRequestBody, null);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Update managed member (asynchronously)
     * Use this endpoint to update the attributes of the specified partner_managed &#x60;member&#x60;.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param managedMemberUpdateRequestBody Managed member object to be updated (While no single parameter is required, the request body can&#39;t be empty) (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateManagedMemberAsync(String memberGuid, String userGuid, ManagedMemberUpdateRequestBody managedMemberUpdateRequestBody, final ApiCallback<MemberResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateManagedMemberValidateBeforeCall(memberGuid, userGuid, managedMemberUpdateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateManagedTransaction
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param transactionGuid The unique id for a &#x60;transaction&#x60;. (required)
     * @param managedTransactionUpdateRequestBody Managed transaction object to be updated (While no single parameter is required, the request body can&#39;t be empty) (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateManagedTransactionCall(String memberGuid, String userGuid, String transactionGuid, ManagedTransactionUpdateRequestBody managedTransactionUpdateRequestBody, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = managedTransactionUpdateRequestBody;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/managed_members/{member_guid}/transactions/{transaction_guid}"
            .replaceAll("\\{" + "member_guid" + "\\}", localVarApiClient.escapeString(memberGuid.toString()))
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()))
            .replaceAll("\\{" + "transaction_guid" + "\\}", localVarApiClient.escapeString(transactionGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateManagedTransactionValidateBeforeCall(String memberGuid, String userGuid, String transactionGuid, ManagedTransactionUpdateRequestBody managedTransactionUpdateRequestBody, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling updateManagedTransaction(Async)");
        }
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling updateManagedTransaction(Async)");
        }
        
        // verify the required parameter 'transactionGuid' is set
        if (transactionGuid == null) {
            throw new ApiException("Missing the required parameter 'transactionGuid' when calling updateManagedTransaction(Async)");
        }
        
        // verify the required parameter 'managedTransactionUpdateRequestBody' is set
        if (managedTransactionUpdateRequestBody == null) {
            throw new ApiException("Missing the required parameter 'managedTransactionUpdateRequestBody' when calling updateManagedTransaction(Async)");
        }
        

        okhttp3.Call localVarCall = updateManagedTransactionCall(memberGuid, userGuid, transactionGuid, managedTransactionUpdateRequestBody, _callback);
        return localVarCall;

    }

    /**
     * Update managed transaction
     * Use this endpoint to update the attributes of the specified partner_managed &#x60;transaction&#x60;.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param transactionGuid The unique id for a &#x60;transaction&#x60;. (required)
     * @param managedTransactionUpdateRequestBody Managed transaction object to be updated (While no single parameter is required, the request body can&#39;t be empty) (required)
     * @return TransactionResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public TransactionResponseBody updateManagedTransaction(String memberGuid, String userGuid, String transactionGuid, ManagedTransactionUpdateRequestBody managedTransactionUpdateRequestBody) throws ApiException {
        ApiResponse<TransactionResponseBody> localVarResp = updateManagedTransactionWithHttpInfo(memberGuid, userGuid, transactionGuid, managedTransactionUpdateRequestBody);
        return localVarResp.getData();
    }

    /**
     * Update managed transaction
     * Use this endpoint to update the attributes of the specified partner_managed &#x60;transaction&#x60;.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param transactionGuid The unique id for a &#x60;transaction&#x60;. (required)
     * @param managedTransactionUpdateRequestBody Managed transaction object to be updated (While no single parameter is required, the request body can&#39;t be empty) (required)
     * @return ApiResponse&lt;TransactionResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TransactionResponseBody> updateManagedTransactionWithHttpInfo(String memberGuid, String userGuid, String transactionGuid, ManagedTransactionUpdateRequestBody managedTransactionUpdateRequestBody) throws ApiException {
        okhttp3.Call localVarCall = updateManagedTransactionValidateBeforeCall(memberGuid, userGuid, transactionGuid, managedTransactionUpdateRequestBody, null);
        Type localVarReturnType = new TypeToken<TransactionResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Update managed transaction (asynchronously)
     * Use this endpoint to update the attributes of the specified partner_managed &#x60;transaction&#x60;.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param transactionGuid The unique id for a &#x60;transaction&#x60;. (required)
     * @param managedTransactionUpdateRequestBody Managed transaction object to be updated (While no single parameter is required, the request body can&#39;t be empty) (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateManagedTransactionAsync(String memberGuid, String userGuid, String transactionGuid, ManagedTransactionUpdateRequestBody managedTransactionUpdateRequestBody, final ApiCallback<TransactionResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateManagedTransactionValidateBeforeCall(memberGuid, userGuid, transactionGuid, managedTransactionUpdateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<TransactionResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateMember
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberUpdateRequestBody Member object to be updated (While no single parameter is required, the request body can&#39;t be empty) (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateMemberCall(String memberGuid, String userGuid, MemberUpdateRequestBody memberUpdateRequestBody, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = memberUpdateRequestBody;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/members/{member_guid}"
            .replaceAll("\\{" + "member_guid" + "\\}", localVarApiClient.escapeString(memberGuid.toString()))
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateMemberValidateBeforeCall(String memberGuid, String userGuid, MemberUpdateRequestBody memberUpdateRequestBody, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling updateMember(Async)");
        }
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling updateMember(Async)");
        }
        
        // verify the required parameter 'memberUpdateRequestBody' is set
        if (memberUpdateRequestBody == null) {
            throw new ApiException("Missing the required parameter 'memberUpdateRequestBody' when calling updateMember(Async)");
        }
        

        okhttp3.Call localVarCall = updateMemberCall(memberGuid, userGuid, memberUpdateRequestBody, _callback);
        return localVarCall;

    }

    /**
     * Update member
     * Use this endpoint to update a members attributes. Only the credentials, id, and metadata parameters can be updated. To get a list of the required credentials for the member, use the list member credentials endpoint.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberUpdateRequestBody Member object to be updated (While no single parameter is required, the request body can&#39;t be empty) (required)
     * @return MemberResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public MemberResponseBody updateMember(String memberGuid, String userGuid, MemberUpdateRequestBody memberUpdateRequestBody) throws ApiException {
        ApiResponse<MemberResponseBody> localVarResp = updateMemberWithHttpInfo(memberGuid, userGuid, memberUpdateRequestBody);
        return localVarResp.getData();
    }

    /**
     * Update member
     * Use this endpoint to update a members attributes. Only the credentials, id, and metadata parameters can be updated. To get a list of the required credentials for the member, use the list member credentials endpoint.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberUpdateRequestBody Member object to be updated (While no single parameter is required, the request body can&#39;t be empty) (required)
     * @return ApiResponse&lt;MemberResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MemberResponseBody> updateMemberWithHttpInfo(String memberGuid, String userGuid, MemberUpdateRequestBody memberUpdateRequestBody) throws ApiException {
        okhttp3.Call localVarCall = updateMemberValidateBeforeCall(memberGuid, userGuid, memberUpdateRequestBody, null);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Update member (asynchronously)
     * Use this endpoint to update a members attributes. Only the credentials, id, and metadata parameters can be updated. To get a list of the required credentials for the member, use the list member credentials endpoint.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param memberUpdateRequestBody Member object to be updated (While no single parameter is required, the request body can&#39;t be empty) (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateMemberAsync(String memberGuid, String userGuid, MemberUpdateRequestBody memberUpdateRequestBody, final ApiCallback<MemberResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateMemberValidateBeforeCall(memberGuid, userGuid, memberUpdateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateTag
     * @param tagGuid The unique id for a &#x60;tag&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param tagUpdateRequestBody Tag object to be updated with required parameter (tag_guid) (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateTagCall(String tagGuid, String userGuid, TagUpdateRequestBody tagUpdateRequestBody, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = tagUpdateRequestBody;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/tags/{tag_guid}"
            .replaceAll("\\{" + "tag_guid" + "\\}", localVarApiClient.escapeString(tagGuid.toString()))
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateTagValidateBeforeCall(String tagGuid, String userGuid, TagUpdateRequestBody tagUpdateRequestBody, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'tagGuid' is set
        if (tagGuid == null) {
            throw new ApiException("Missing the required parameter 'tagGuid' when calling updateTag(Async)");
        }
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling updateTag(Async)");
        }
        
        // verify the required parameter 'tagUpdateRequestBody' is set
        if (tagUpdateRequestBody == null) {
            throw new ApiException("Missing the required parameter 'tagUpdateRequestBody' when calling updateTag(Async)");
        }
        

        okhttp3.Call localVarCall = updateTagCall(tagGuid, userGuid, tagUpdateRequestBody, _callback);
        return localVarCall;

    }

    /**
     * Update tag
     * Use this endpoint to update the name of a specific tag according to its unique GUID.
     * @param tagGuid The unique id for a &#x60;tag&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param tagUpdateRequestBody Tag object to be updated with required parameter (tag_guid) (required)
     * @return TagResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public TagResponseBody updateTag(String tagGuid, String userGuid, TagUpdateRequestBody tagUpdateRequestBody) throws ApiException {
        ApiResponse<TagResponseBody> localVarResp = updateTagWithHttpInfo(tagGuid, userGuid, tagUpdateRequestBody);
        return localVarResp.getData();
    }

    /**
     * Update tag
     * Use this endpoint to update the name of a specific tag according to its unique GUID.
     * @param tagGuid The unique id for a &#x60;tag&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param tagUpdateRequestBody Tag object to be updated with required parameter (tag_guid) (required)
     * @return ApiResponse&lt;TagResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TagResponseBody> updateTagWithHttpInfo(String tagGuid, String userGuid, TagUpdateRequestBody tagUpdateRequestBody) throws ApiException {
        okhttp3.Call localVarCall = updateTagValidateBeforeCall(tagGuid, userGuid, tagUpdateRequestBody, null);
        Type localVarReturnType = new TypeToken<TagResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Update tag (asynchronously)
     * Use this endpoint to update the name of a specific tag according to its unique GUID.
     * @param tagGuid The unique id for a &#x60;tag&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param tagUpdateRequestBody Tag object to be updated with required parameter (tag_guid) (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateTagAsync(String tagGuid, String userGuid, TagUpdateRequestBody tagUpdateRequestBody, final ApiCallback<TagResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateTagValidateBeforeCall(tagGuid, userGuid, tagUpdateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<TagResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateTagging
     * @param taggingGuid The unique id for a &#x60;tagging&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param taggingUpdateRequestBody Tagging object to be updated with required parameter (tag_guid) (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateTaggingCall(String taggingGuid, String userGuid, TaggingUpdateRequestBody taggingUpdateRequestBody, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = taggingUpdateRequestBody;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/taggings/{tagging_guid}"
            .replaceAll("\\{" + "tagging_guid" + "\\}", localVarApiClient.escapeString(taggingGuid.toString()))
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateTaggingValidateBeforeCall(String taggingGuid, String userGuid, TaggingUpdateRequestBody taggingUpdateRequestBody, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'taggingGuid' is set
        if (taggingGuid == null) {
            throw new ApiException("Missing the required parameter 'taggingGuid' when calling updateTagging(Async)");
        }
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling updateTagging(Async)");
        }
        
        // verify the required parameter 'taggingUpdateRequestBody' is set
        if (taggingUpdateRequestBody == null) {
            throw new ApiException("Missing the required parameter 'taggingUpdateRequestBody' when calling updateTagging(Async)");
        }
        

        okhttp3.Call localVarCall = updateTaggingCall(taggingGuid, userGuid, taggingUpdateRequestBody, _callback);
        return localVarCall;

    }

    /**
     * Update tagging
     * Use this endpoint to update a tagging.
     * @param taggingGuid The unique id for a &#x60;tagging&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param taggingUpdateRequestBody Tagging object to be updated with required parameter (tag_guid) (required)
     * @return TaggingResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public TaggingResponseBody updateTagging(String taggingGuid, String userGuid, TaggingUpdateRequestBody taggingUpdateRequestBody) throws ApiException {
        ApiResponse<TaggingResponseBody> localVarResp = updateTaggingWithHttpInfo(taggingGuid, userGuid, taggingUpdateRequestBody);
        return localVarResp.getData();
    }

    /**
     * Update tagging
     * Use this endpoint to update a tagging.
     * @param taggingGuid The unique id for a &#x60;tagging&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param taggingUpdateRequestBody Tagging object to be updated with required parameter (tag_guid) (required)
     * @return ApiResponse&lt;TaggingResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TaggingResponseBody> updateTaggingWithHttpInfo(String taggingGuid, String userGuid, TaggingUpdateRequestBody taggingUpdateRequestBody) throws ApiException {
        okhttp3.Call localVarCall = updateTaggingValidateBeforeCall(taggingGuid, userGuid, taggingUpdateRequestBody, null);
        Type localVarReturnType = new TypeToken<TaggingResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Update tagging (asynchronously)
     * Use this endpoint to update a tagging.
     * @param taggingGuid The unique id for a &#x60;tagging&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param taggingUpdateRequestBody Tagging object to be updated with required parameter (tag_guid) (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateTaggingAsync(String taggingGuid, String userGuid, TaggingUpdateRequestBody taggingUpdateRequestBody, final ApiCallback<TaggingResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateTaggingValidateBeforeCall(taggingGuid, userGuid, taggingUpdateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<TaggingResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateTransaction
     * @param transactionGuid The unique id for a &#x60;transaction&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param transactionUpdateRequestBody Transaction object to be updated with a new description (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateTransactionCall(String transactionGuid, String userGuid, TransactionUpdateRequestBody transactionUpdateRequestBody, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = transactionUpdateRequestBody;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/transactions/{transaction_guid}"
            .replaceAll("\\{" + "transaction_guid" + "\\}", localVarApiClient.escapeString(transactionGuid.toString()))
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateTransactionValidateBeforeCall(String transactionGuid, String userGuid, TransactionUpdateRequestBody transactionUpdateRequestBody, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'transactionGuid' is set
        if (transactionGuid == null) {
            throw new ApiException("Missing the required parameter 'transactionGuid' when calling updateTransaction(Async)");
        }
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling updateTransaction(Async)");
        }
        
        // verify the required parameter 'transactionUpdateRequestBody' is set
        if (transactionUpdateRequestBody == null) {
            throw new ApiException("Missing the required parameter 'transactionUpdateRequestBody' when calling updateTransaction(Async)");
        }
        

        okhttp3.Call localVarCall = updateTransactionCall(transactionGuid, userGuid, transactionUpdateRequestBody, _callback);
        return localVarCall;

    }

    /**
     * Update transaction
     * Use this endpoint to update the &#x60;description&#x60; of a specific transaction according to its unique GUID.
     * @param transactionGuid The unique id for a &#x60;transaction&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param transactionUpdateRequestBody Transaction object to be updated with a new description (required)
     * @return TransactionResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public TransactionResponseBody updateTransaction(String transactionGuid, String userGuid, TransactionUpdateRequestBody transactionUpdateRequestBody) throws ApiException {
        ApiResponse<TransactionResponseBody> localVarResp = updateTransactionWithHttpInfo(transactionGuid, userGuid, transactionUpdateRequestBody);
        return localVarResp.getData();
    }

    /**
     * Update transaction
     * Use this endpoint to update the &#x60;description&#x60; of a specific transaction according to its unique GUID.
     * @param transactionGuid The unique id for a &#x60;transaction&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param transactionUpdateRequestBody Transaction object to be updated with a new description (required)
     * @return ApiResponse&lt;TransactionResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TransactionResponseBody> updateTransactionWithHttpInfo(String transactionGuid, String userGuid, TransactionUpdateRequestBody transactionUpdateRequestBody) throws ApiException {
        okhttp3.Call localVarCall = updateTransactionValidateBeforeCall(transactionGuid, userGuid, transactionUpdateRequestBody, null);
        Type localVarReturnType = new TypeToken<TransactionResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Update transaction (asynchronously)
     * Use this endpoint to update the &#x60;description&#x60; of a specific transaction according to its unique GUID.
     * @param transactionGuid The unique id for a &#x60;transaction&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param transactionUpdateRequestBody Transaction object to be updated with a new description (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateTransactionAsync(String transactionGuid, String userGuid, TransactionUpdateRequestBody transactionUpdateRequestBody, final ApiCallback<TransactionResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateTransactionValidateBeforeCall(transactionGuid, userGuid, transactionUpdateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<TransactionResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateTransactionRule
     * @param transactionRuleGuid The unique id for a &#x60;transaction_rule&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param transactionRuleUpdateRequestBody TransactionRule object to be updated (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateTransactionRuleCall(String transactionRuleGuid, String userGuid, TransactionRuleUpdateRequestBody transactionRuleUpdateRequestBody, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = transactionRuleUpdateRequestBody;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/transaction_rules/{transaction_rule_guid}"
            .replaceAll("\\{" + "transaction_rule_guid" + "\\}", localVarApiClient.escapeString(transactionRuleGuid.toString()))
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateTransactionRuleValidateBeforeCall(String transactionRuleGuid, String userGuid, TransactionRuleUpdateRequestBody transactionRuleUpdateRequestBody, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'transactionRuleGuid' is set
        if (transactionRuleGuid == null) {
            throw new ApiException("Missing the required parameter 'transactionRuleGuid' when calling updateTransactionRule(Async)");
        }
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling updateTransactionRule(Async)");
        }
        
        // verify the required parameter 'transactionRuleUpdateRequestBody' is set
        if (transactionRuleUpdateRequestBody == null) {
            throw new ApiException("Missing the required parameter 'transactionRuleUpdateRequestBody' when calling updateTransactionRule(Async)");
        }
        

        okhttp3.Call localVarCall = updateTransactionRuleCall(transactionRuleGuid, userGuid, transactionRuleUpdateRequestBody, _callback);
        return localVarCall;

    }

    /**
     * Update transaction_rule
     * Use this endpoint to update the attributes of a specific transaction rule based on its unique GUID. The API will respond with the updated transaction_rule object. Any attributes not provided will be left unchanged.
     * @param transactionRuleGuid The unique id for a &#x60;transaction_rule&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param transactionRuleUpdateRequestBody TransactionRule object to be updated (required)
     * @return TransactionRuleResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public TransactionRuleResponseBody updateTransactionRule(String transactionRuleGuid, String userGuid, TransactionRuleUpdateRequestBody transactionRuleUpdateRequestBody) throws ApiException {
        ApiResponse<TransactionRuleResponseBody> localVarResp = updateTransactionRuleWithHttpInfo(transactionRuleGuid, userGuid, transactionRuleUpdateRequestBody);
        return localVarResp.getData();
    }

    /**
     * Update transaction_rule
     * Use this endpoint to update the attributes of a specific transaction rule based on its unique GUID. The API will respond with the updated transaction_rule object. Any attributes not provided will be left unchanged.
     * @param transactionRuleGuid The unique id for a &#x60;transaction_rule&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param transactionRuleUpdateRequestBody TransactionRule object to be updated (required)
     * @return ApiResponse&lt;TransactionRuleResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TransactionRuleResponseBody> updateTransactionRuleWithHttpInfo(String transactionRuleGuid, String userGuid, TransactionRuleUpdateRequestBody transactionRuleUpdateRequestBody) throws ApiException {
        okhttp3.Call localVarCall = updateTransactionRuleValidateBeforeCall(transactionRuleGuid, userGuid, transactionRuleUpdateRequestBody, null);
        Type localVarReturnType = new TypeToken<TransactionRuleResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Update transaction_rule (asynchronously)
     * Use this endpoint to update the attributes of a specific transaction rule based on its unique GUID. The API will respond with the updated transaction_rule object. Any attributes not provided will be left unchanged.
     * @param transactionRuleGuid The unique id for a &#x60;transaction_rule&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param transactionRuleUpdateRequestBody TransactionRule object to be updated (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateTransactionRuleAsync(String transactionRuleGuid, String userGuid, TransactionRuleUpdateRequestBody transactionRuleUpdateRequestBody, final ApiCallback<TransactionRuleResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateTransactionRuleValidateBeforeCall(transactionRuleGuid, userGuid, transactionRuleUpdateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<TransactionRuleResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateUser
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param userUpdateRequestBody User object to be updated (None of these parameters are required, but the user object cannot be empty.) (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateUserCall(String userGuid, UserUpdateRequestBody userUpdateRequestBody, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = userUpdateRequestBody;

        // create path and map variables
        String localVarPath = "/users/{user_guid}"
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateUserValidateBeforeCall(String userGuid, UserUpdateRequestBody userUpdateRequestBody, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling updateUser(Async)");
        }
        
        // verify the required parameter 'userUpdateRequestBody' is set
        if (userUpdateRequestBody == null) {
            throw new ApiException("Missing the required parameter 'userUpdateRequestBody' when calling updateUser(Async)");
        }
        

        okhttp3.Call localVarCall = updateUserCall(userGuid, userUpdateRequestBody, _callback);
        return localVarCall;

    }

    /**
     * Update user
     * Use this endpoint to update the attributes of a specific user. The MX Platform API will respond with the updated user object. Disabling a user means that accounts and transactions associated with it will not be updated in the background by MX. It will also restrict access to that users data until they are no longer disabled. Users who are disabled for the entirety of an MX Platform API billing period will not be factored into that months bill. To disable a user, update it and set the is_disabled parameter to true. Set it to false to re-enable the user.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param userUpdateRequestBody User object to be updated (None of these parameters are required, but the user object cannot be empty.) (required)
     * @return UserResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public UserResponseBody updateUser(String userGuid, UserUpdateRequestBody userUpdateRequestBody) throws ApiException {
        ApiResponse<UserResponseBody> localVarResp = updateUserWithHttpInfo(userGuid, userUpdateRequestBody);
        return localVarResp.getData();
    }

    /**
     * Update user
     * Use this endpoint to update the attributes of a specific user. The MX Platform API will respond with the updated user object. Disabling a user means that accounts and transactions associated with it will not be updated in the background by MX. It will also restrict access to that users data until they are no longer disabled. Users who are disabled for the entirety of an MX Platform API billing period will not be factored into that months bill. To disable a user, update it and set the is_disabled parameter to true. Set it to false to re-enable the user.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param userUpdateRequestBody User object to be updated (None of these parameters are required, but the user object cannot be empty.) (required)
     * @return ApiResponse&lt;UserResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<UserResponseBody> updateUserWithHttpInfo(String userGuid, UserUpdateRequestBody userUpdateRequestBody) throws ApiException {
        okhttp3.Call localVarCall = updateUserValidateBeforeCall(userGuid, userUpdateRequestBody, null);
        Type localVarReturnType = new TypeToken<UserResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Update user (asynchronously)
     * Use this endpoint to update the attributes of a specific user. The MX Platform API will respond with the updated user object. Disabling a user means that accounts and transactions associated with it will not be updated in the background by MX. It will also restrict access to that users data until they are no longer disabled. Users who are disabled for the entirety of an MX Platform API billing period will not be factored into that months bill. To disable a user, update it and set the is_disabled parameter to true. Set it to false to re-enable the user.
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param userUpdateRequestBody User object to be updated (None of these parameters are required, but the user object cannot be empty.) (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateUserAsync(String userGuid, UserUpdateRequestBody userUpdateRequestBody, final ApiCallback<UserResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateUserValidateBeforeCall(userGuid, userUpdateRequestBody, _callback);
        Type localVarReturnType = new TypeToken<UserResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for verifyMember
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call verifyMemberCall(String memberGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users/{user_guid}/members/{member_guid}/verify"
            .replaceAll("\\{" + "member_guid" + "\\}", localVarApiClient.escapeString(memberGuid.toString()))
            .replaceAll("\\{" + "user_guid" + "\\}", localVarApiClient.escapeString(userGuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/vnd.mx.api.v1+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call verifyMemberValidateBeforeCall(String memberGuid, String userGuid, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'memberGuid' is set
        if (memberGuid == null) {
            throw new ApiException("Missing the required parameter 'memberGuid' when calling verifyMember(Async)");
        }
        
        // verify the required parameter 'userGuid' is set
        if (userGuid == null) {
            throw new ApiException("Missing the required parameter 'userGuid' when calling verifyMember(Async)");
        }
        

        okhttp3.Call localVarCall = verifyMemberCall(memberGuid, userGuid, _callback);
        return localVarCall;

    }

    /**
     * Verify member
     * The verify endpoint begins a verification process for a member.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return MemberResponseBody
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public MemberResponseBody verifyMember(String memberGuid, String userGuid) throws ApiException {
        ApiResponse<MemberResponseBody> localVarResp = verifyMemberWithHttpInfo(memberGuid, userGuid);
        return localVarResp.getData();
    }

    /**
     * Verify member
     * The verify endpoint begins a verification process for a member.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @return ApiResponse&lt;MemberResponseBody&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MemberResponseBody> verifyMemberWithHttpInfo(String memberGuid, String userGuid) throws ApiException {
        okhttp3.Call localVarCall = verifyMemberValidateBeforeCall(memberGuid, userGuid, null);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Verify member (asynchronously)
     * The verify endpoint begins a verification process for a member.
     * @param memberGuid The unique id for a &#x60;member&#x60;. (required)
     * @param userGuid The unique id for a &#x60;user&#x60;. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call verifyMemberAsync(String memberGuid, String userGuid, final ApiCallback<MemberResponseBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = verifyMemberValidateBeforeCall(memberGuid, userGuid, _callback);
        Type localVarReturnType = new TypeToken<MemberResponseBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
