/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.util;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.PixelGrabber;
import java.awt.image.WritableRaster;
import java.nio.IntBuffer;

public class ImageUtils {
    public static int[] getImageIntPixels(Image image, boolean allowDeoptimizingDirectRead) {
        return ImageUtils.getImageIntPixels(image, 0, 0, image.getWidth(null), image.getHeight(null), allowDeoptimizingDirectRead);
    }

    public static int[] getImageIntPixels(Image image, int x, int y, int width, int height, boolean allowDeoptimizingDirectRead) {
        if (image instanceof BufferedImage) {
            DataBuffer b;
            BufferedImage bim = (BufferedImage)image;
            WritableRaster raster = bim.getRaster();
            if (allowDeoptimizingDirectRead && raster.getParent() == null && raster.getDataBuffer().getNumBanks() == 1 && (b = bim.getRaster().getDataBuffer()) instanceof DataBufferInt) {
                int[] array = ((DataBufferInt)b).getData();
                return array;
            }
            return bim.getRGB(x, y, width, height, null, 0, width);
        }
        PixelGrabber grabber = new PixelGrabber(image, x, y, width, height, true);
        try {
            grabber.grabPixels();
            return (int[])grabber.getPixels();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException("Pixel read operation was interrupted", ex);
        }
    }

    public static void setImageIntPixels(BufferedImage image, boolean allowDeoptimizingDirectRead, IntBuffer pixels) {
        ImageUtils.setImageIntPixels(image, 0, 0, image.getWidth(null), image.getHeight(null), allowDeoptimizingDirectRead, pixels);
    }

    public static void setImageIntPixels(BufferedImage bim, int x, int y, int width, int height, boolean allowDeoptimizingDirectRead, IntBuffer pixels) {
        Object b;
        WritableRaster raster = bim.getRaster();
        if (allowDeoptimizingDirectRead && raster.getParent() == null && raster.getDataBuffer().getNumBanks() == 1 && (b = bim.getRaster().getDataBuffer()) instanceof DataBufferInt) {
            IntBuffer.wrap(((DataBufferInt)b).getData()).put(pixels);
            return;
        }
        b = IntBuffer.allocate(width * height);
        ((IntBuffer)b).put(pixels);
        ((IntBuffer)b).rewind();
        int[] array = ((IntBuffer)b).array();
        bim.setRGB(x, y, width, height, array, 0, width);
    }
}

