/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d;

import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.Cylinder;
import eu.mihosoft.vrl.v3d.Polygon;
import eu.mihosoft.vrl.v3d.Primitive;
import eu.mihosoft.vrl.v3d.PropertyStorage;
import eu.mihosoft.vrl.v3d.ext.quickhull3d.HullUtil;
import java.util.ArrayList;
import java.util.List;

public class RoundedCylinder
extends Primitive {
    private final PropertyStorage properties = new PropertyStorage();
    private double cornerRadius = 2.0;
    private int resolution = 30;
    private double startRadius;
    private double endRadius;
    private double height;
    private int numCornerSlices;

    public RoundedCylinder(double startRadius, double endRadius, double height, int numSlices) {
        this.startRadius = startRadius;
        this.endRadius = endRadius;
        this.height = height;
        this.resolution = numSlices;
        this.setNumCornerSlices(6);
    }

    public RoundedCylinder(double startRadius, double height) {
        this.startRadius = startRadius;
        this.endRadius = startRadius;
        this.height = height;
        this.resolution = 30;
        this.setNumCornerSlices(6);
    }

    @Override
    public List<Polygon> toPolygons() {
        double minHeight = this.height - this.cornerRadius * 2.0;
        ArrayList<CSG> cylParts = new ArrayList<CSG>();
        for (int i = 0; i < this.numCornerSlices; ++i) {
            double radIncs = this.startRadius - this.cornerRadius + Math.sin(1.5707963267948966 * ((double)i / (double)this.numCornerSlices)) * this.cornerRadius;
            double radInce = this.endRadius - this.cornerRadius + Math.sin(1.5707963267948966 * ((double)i / (double)this.numCornerSlices)) * this.cornerRadius;
            double heightInc = Math.cos(1.5707963267948966 * ((double)i / (double)this.numCornerSlices)) * this.cornerRadius;
            cylParts.add(new Cylinder(radIncs, radInce, heightInc * 2.0 + minHeight, this.resolution).toCSG().movez(-heightInc));
        }
        return HullUtil.hull(cylParts).toZMin().getPolygons();
    }

    @Override
    public PropertyStorage getProperties() {
        return this.properties;
    }

    public int getResolution() {
        return this.resolution;
    }

    public RoundedCylinder resolution(int resolution) {
        this.resolution = resolution;
        return this;
    }

    public double getCornerRadius() {
        return this.cornerRadius;
    }

    public RoundedCylinder cornerRadius(double cornerRadius) {
        this.cornerRadius = cornerRadius;
        return this;
    }

    public int getNumCornerSlices() {
        return this.numCornerSlices;
    }

    public RoundedCylinder setNumCornerSlices(int numCornerSlices) {
        this.numCornerSlices = numCornerSlices;
        return this;
    }
}

