/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.ext.openjfx.shape3d;

import eu.mihosoft.vrl.v3d.ext.openjfx.shape3d.PolygonMesh;
import eu.mihosoft.vrl.v3d.ext.openjfx.shape3d.SubdivisionMesh;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ArrayChangeListener;
import javafx.collections.ObservableFloatArray;
import javafx.scene.Parent;
import javafx.scene.paint.Material;
import javafx.scene.shape.CullFace;
import javafx.scene.shape.DrawMode;
import javafx.scene.shape.Mesh;
import javafx.scene.shape.MeshView;
import javafx.scene.shape.TriangleMesh;

public class PolygonMeshView
extends Parent {
    private static final boolean DEBUG = false;
    private final MeshView meshView = new MeshView();
    private TriangleMesh triangleMesh = new TriangleMesh();
    private SubdivisionMesh subdivisionMesh;
    private final ArrayChangeListener<ObservableFloatArray> meshPointsListener = (t, bln, i, i1) -> {
        this.pointsDirty = true;
        this.updateMesh();
    };
    private final ArrayChangeListener<ObservableFloatArray> meshTexCoordListener = (t, bln, i, i1) -> {
        this.texCoordsDirty = true;
        this.updateMesh();
    };
    private boolean pointsDirty = true;
    private boolean pointsSizeDirty = true;
    private boolean texCoordsDirty = true;
    private boolean facesDirty = true;
    private ObjectProperty<PolygonMesh> meshProperty;
    private ObjectProperty<DrawMode> drawMode;
    private ObjectProperty<CullFace> cullFace;
    private ObjectProperty<Material> materialProperty = new SimpleObjectProperty();
    private SimpleIntegerProperty subdivisionLevelProperty;
    private SimpleObjectProperty<SubdivisionMesh.BoundaryMode> boundaryMode;
    private SimpleObjectProperty<SubdivisionMesh.MapBorderMode> mapBorderMode;

    public PolygonMesh getMesh() {
        return (PolygonMesh)this.meshProperty().get();
    }

    public void setMesh(PolygonMesh mesh) {
        this.meshProperty().set((Object)mesh);
    }

    public ObjectProperty<PolygonMesh> meshProperty() {
        if (this.meshProperty == null) {
            this.meshProperty = new SimpleObjectProperty();
            this.meshProperty.addListener((observable, oldValue, newValue) -> {
                if (oldValue != null) {
                    oldValue.getPoints().removeListener(this.meshPointsListener);
                    oldValue.getPoints().removeListener(this.meshTexCoordListener);
                }
                this.meshProperty.set(newValue);
                this.facesDirty = true;
                this.texCoordsDirty = true;
                this.pointsSizeDirty = true;
                this.pointsDirty = true;
                this.updateMesh();
                if (newValue != null) {
                    newValue.getPoints().addListener(this.meshPointsListener);
                    newValue.getTexCoords().addListener(this.meshTexCoordListener);
                }
            });
        }
        return this.meshProperty;
    }

    public final void setDrawMode(DrawMode value) {
        this.drawModeProperty().set((Object)value);
    }

    public final DrawMode getDrawMode() {
        return this.drawMode == null ? DrawMode.FILL : (DrawMode)this.drawMode.get();
    }

    public final ObjectProperty<DrawMode> drawModeProperty() {
        if (this.drawMode == null) {
            this.drawMode = new SimpleObjectProperty<DrawMode>((Object)this, "drawMode", DrawMode.FILL){

                protected void invalidated() {
                    PolygonMeshView.this.meshView.setDrawMode((DrawMode)this.get());
                    PolygonMeshView.this.pointsDirty = (PolygonMeshView.this.pointsSizeDirty = (PolygonMeshView.this.texCoordsDirty = (PolygonMeshView.this.facesDirty = true)));
                    PolygonMeshView.this.updateMesh();
                }
            };
        }
        return this.drawMode;
    }

    public final void setCullFace(CullFace value) {
        this.cullFaceProperty().set((Object)value);
    }

    public final CullFace getCullFace() {
        return this.cullFace == null ? CullFace.BACK : (CullFace)this.cullFace.get();
    }

    public final ObjectProperty<CullFace> cullFaceProperty() {
        if (this.cullFace == null) {
            this.cullFace = new SimpleObjectProperty<CullFace>((Object)this, "cullFace", CullFace.BACK){

                protected void invalidated() {
                    PolygonMeshView.this.meshView.setCullFace((CullFace)this.get());
                }
            };
        }
        return this.cullFace;
    }

    public Material getMaterial() {
        return (Material)this.materialProperty.get();
    }

    public void setMaterial(Material material) {
        this.materialProperty.set((Object)material);
    }

    public ObjectProperty<Material> materialProperty() {
        return this.materialProperty;
    }

    public void setSubdivisionLevel(int subdivisionLevel) {
        this.subdivisionLevelProperty().set(subdivisionLevel);
    }

    public int getSubdivisionLevel() {
        return this.subdivisionLevelProperty == null ? 0 : this.subdivisionLevelProperty.get();
    }

    public SimpleIntegerProperty subdivisionLevelProperty() {
        if (this.subdivisionLevelProperty == null) {
            this.subdivisionLevelProperty = new SimpleIntegerProperty(this.getSubdivisionLevel()){

                protected void invalidated() {
                    if (PolygonMeshView.this.getSubdivisionLevel() > 0 && PolygonMeshView.this.subdivisionMesh == null) {
                        PolygonMeshView.this.subdivisionMesh = new SubdivisionMesh(PolygonMeshView.this.getMesh(), PolygonMeshView.this.getSubdivisionLevel(), PolygonMeshView.this.getBoundaryMode(), PolygonMeshView.this.getMapBorderMode());
                        PolygonMeshView.this.subdivisionMesh.getOriginalMesh().getPoints().addListener((t, bln, i, i1) -> PolygonMeshView.this.subdivisionMesh.update());
                        PolygonMeshView.this.setMesh(PolygonMeshView.this.subdivisionMesh);
                    }
                    if (PolygonMeshView.this.subdivisionMesh != null) {
                        PolygonMeshView.this.subdivisionMesh.setSubdivisionLevel(PolygonMeshView.this.getSubdivisionLevel());
                        PolygonMeshView.this.subdivisionMesh.update();
                    }
                    PolygonMeshView.this.pointsDirty = (PolygonMeshView.this.pointsSizeDirty = (PolygonMeshView.this.texCoordsDirty = (PolygonMeshView.this.facesDirty = true)));
                    PolygonMeshView.this.updateMesh();
                }
            };
        }
        return this.subdivisionLevelProperty;
    }

    public void setBoundaryMode(SubdivisionMesh.BoundaryMode boundaryMode) {
        this.boundaryModeProperty().set((Object)boundaryMode);
    }

    public SubdivisionMesh.BoundaryMode getBoundaryMode() {
        return this.boundaryMode == null ? SubdivisionMesh.BoundaryMode.CREASE_EDGES : (SubdivisionMesh.BoundaryMode)((Object)this.boundaryMode.get());
    }

    public SimpleObjectProperty<SubdivisionMesh.BoundaryMode> boundaryModeProperty() {
        if (this.boundaryMode == null) {
            this.boundaryMode = new SimpleObjectProperty<SubdivisionMesh.BoundaryMode>(this.getBoundaryMode()){

                protected void invalidated() {
                    if (PolygonMeshView.this.subdivisionMesh != null) {
                        PolygonMeshView.this.subdivisionMesh.setBoundaryMode(PolygonMeshView.this.getBoundaryMode());
                        PolygonMeshView.this.subdivisionMesh.update();
                    }
                    PolygonMeshView.this.pointsDirty = true;
                    PolygonMeshView.this.updateMesh();
                }
            };
        }
        return this.boundaryMode;
    }

    public void setMapBorderMode(SubdivisionMesh.MapBorderMode mapBorderMode) {
        this.mapBorderModeProperty().set((Object)mapBorderMode);
    }

    public SubdivisionMesh.MapBorderMode getMapBorderMode() {
        return this.mapBorderMode == null ? SubdivisionMesh.MapBorderMode.NOT_SMOOTH : (SubdivisionMesh.MapBorderMode)((Object)this.mapBorderMode.get());
    }

    public SimpleObjectProperty<SubdivisionMesh.MapBorderMode> mapBorderModeProperty() {
        if (this.mapBorderMode == null) {
            this.mapBorderMode = new SimpleObjectProperty<SubdivisionMesh.MapBorderMode>(this.getMapBorderMode()){

                protected void invalidated() {
                    if (PolygonMeshView.this.subdivisionMesh != null) {
                        PolygonMeshView.this.subdivisionMesh.setMapBorderMode(PolygonMeshView.this.getMapBorderMode());
                        PolygonMeshView.this.subdivisionMesh.update();
                    }
                    PolygonMeshView.this.texCoordsDirty = true;
                    PolygonMeshView.this.updateMesh();
                }
            };
        }
        return this.mapBorderMode;
    }

    public PolygonMeshView() {
        this.meshView.materialProperty().bind(this.materialProperty());
        this.getChildren().add((Object)this.meshView);
    }

    public PolygonMeshView(PolygonMesh mesh) {
        this();
        this.setMesh(mesh);
    }

    private void updateMesh() {
        PolygonMesh pmesh = this.getMesh();
        if (pmesh == null || pmesh.faces == null) {
            this.triangleMesh = new TriangleMesh();
            this.meshView.setMesh((Mesh)this.triangleMesh);
            return;
        }
        int pointElementSize = this.triangleMesh.getPointElementSize();
        int faceElementSize = this.triangleMesh.getFaceElementSize();
        boolean isWireframe = this.getDrawMode() == DrawMode.LINE;
        int numOfPoints = pmesh.getPoints().size() / pointElementSize;
        if (isWireframe) {
            if (this.texCoordsDirty || this.facesDirty || this.pointsSizeDirty) {
                this.triangleMesh = new TriangleMesh();
                this.facesDirty = true;
                this.texCoordsDirty = true;
                this.pointsSizeDirty = true;
                this.pointsDirty = true;
            }
            if (this.facesDirty) {
                this.facesDirty = false;
                int[] facesArray = new int[pmesh.getNumEdgesInFaces() * faceElementSize];
                int facesInd = 0;
                int pointsInd = pmesh.getPoints().size();
                int[][] nArray = pmesh.faces;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int[] face = nArray[i];
                    int lastPointIndex = face[face.length - 2];
                    for (int p = 0; p < face.length; p += 2) {
                        int pointIndex = face[p];
                        facesArray[facesInd++] = lastPointIndex;
                        facesArray[facesInd++] = 0;
                        facesArray[facesInd++] = pointIndex;
                        facesArray[facesInd++] = 0;
                        facesArray[facesInd++] = pointsInd / pointElementSize;
                        facesArray[facesInd++] = 0;
                        pointsInd += pointElementSize;
                        lastPointIndex = pointIndex;
                    }
                }
                this.triangleMesh.getFaces().setAll(facesArray);
                this.triangleMesh.getFaceSmoothingGroups().clear();
            }
            if (this.texCoordsDirty) {
                this.texCoordsDirty = false;
                this.triangleMesh.getTexCoords().setAll(new float[]{0.0f, 0.0f});
            }
            if (this.pointsDirty) {
                this.pointsDirty = false;
                float[] pointsArray = new float[pmesh.getPoints().size() + pmesh.getNumEdgesInFaces() * 3];
                pmesh.getPoints().copyTo(0, pointsArray, 0, pmesh.getPoints().size());
                int pointsInd = pmesh.getPoints().size();
                for (int[] face : pmesh.faces) {
                    int lastPointIndex = face[face.length - 2];
                    for (int p = 0; p < face.length; p += 2) {
                        int pointIndex = face[p];
                        float x1 = pointsArray[lastPointIndex * pointElementSize];
                        float y1 = pointsArray[lastPointIndex * pointElementSize + 1];
                        float z1 = pointsArray[lastPointIndex * pointElementSize + 2];
                        float x2 = pointsArray[pointIndex * pointElementSize];
                        float y2 = pointsArray[pointIndex * pointElementSize + 1];
                        float z2 = pointsArray[pointIndex * pointElementSize + 2];
                        float distance = Math.abs(this.distanceBetweenPoints(x1, y1, z1, x2, y2, z2));
                        float offset = distance / 1000.0f;
                        pointsArray[pointsInd++] = x2 + offset;
                        pointsArray[pointsInd++] = y2 + offset;
                        pointsArray[pointsInd++] = z2 + offset;
                        lastPointIndex = pointIndex;
                    }
                }
                this.triangleMesh.getPoints().setAll(pointsArray);
            }
        } else {
            if (this.texCoordsDirty || this.facesDirty || this.pointsSizeDirty) {
                this.triangleMesh = new TriangleMesh();
                this.facesDirty = true;
                this.texCoordsDirty = true;
                this.pointsSizeDirty = true;
                this.pointsDirty = true;
            }
            if (this.facesDirty) {
                this.facesDirty = false;
                int numOfFacesBefore = pmesh.faces.length;
                int numOfFacesAfter = pmesh.getNumEdgesInFaces() - 2 * numOfFacesBefore;
                int[] facesArray = new int[numOfFacesAfter * faceElementSize];
                int[] smoothingGroupsArray = new int[numOfFacesAfter];
                int facesInd = 0;
                for (int f = 0; f < pmesh.faces.length; ++f) {
                    int[] face = pmesh.faces[f];
                    int currentSmoothGroup = pmesh.getFaceSmoothingGroups().get(f);
                    int firstPointIndex = face[0];
                    int firstTexIndex = face[1];
                    int lastPointIndex = face[2];
                    int lastTexIndex = face[3];
                    for (int p = 4; p < face.length; p += 2) {
                        int pointIndex = face[p];
                        int texIndex = face[p + 1];
                        facesArray[facesInd * faceElementSize] = firstPointIndex;
                        facesArray[facesInd * faceElementSize + 1] = firstTexIndex;
                        facesArray[facesInd * faceElementSize + 2] = lastPointIndex;
                        facesArray[facesInd * faceElementSize + 3] = lastTexIndex;
                        facesArray[facesInd * faceElementSize + 4] = pointIndex;
                        facesArray[facesInd * faceElementSize + 5] = texIndex;
                        smoothingGroupsArray[facesInd] = currentSmoothGroup;
                        ++facesInd;
                        lastPointIndex = pointIndex;
                        lastTexIndex = texIndex;
                    }
                }
                this.triangleMesh.getFaces().setAll(facesArray);
                this.triangleMesh.getFaceSmoothingGroups().setAll(smoothingGroupsArray);
            }
            if (this.texCoordsDirty) {
                this.texCoordsDirty = false;
                this.triangleMesh.getTexCoords().setAll(pmesh.getTexCoords());
            }
            if (this.pointsDirty) {
                this.pointsDirty = false;
                this.triangleMesh.getPoints().setAll(pmesh.getPoints());
            }
        }
        if (this.meshView.getMesh() != this.triangleMesh) {
            this.meshView.setMesh((Mesh)this.triangleMesh);
        }
        this.facesDirty = false;
        this.texCoordsDirty = false;
        this.pointsSizeDirty = false;
        this.pointsDirty = false;
    }

    private float distanceBetweenPoints(float x1, float y1, float z1, float x2, float y2, float z2) {
        return (float)Math.sqrt(Math.pow(z2 - z1, 2.0) + Math.pow(x2 - x1, 2.0) + Math.pow(y2 - y1, 2.0));
    }
}

