/*
 * Decompiled with CFR 0.152.
 */
package com.openlayer.api.core.http;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.openlayer.api.core.MultipartField;
import com.openlayer.api.core.http.HttpRequestBodies;
import com.openlayer.api.core.http.HttpRequestBody;
import com.openlayer.api.errors.OpenlayerInvalidDataException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0000\u001a\u00020\u0001\"\u0006\b\u0000\u0010\u0002\u0018\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u0002H\u0002H\u0080\b\u00a2\u0006\u0002\u0010\u0006\u001a(\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\tH\u0000\u00a8\u0006\f"}, d2={"json", "Lcom/openlayer/api/core/http/HttpRequestBody;", "T", "jsonMapper", "Lcom/fasterxml/jackson/databind/json/JsonMapper;", "value", "(Lcom/fasterxml/jackson/databind/json/JsonMapper;Ljava/lang/Object;)Lcom/openlayer/api/core/http/HttpRequestBody;", "multipartFormData", "fields", "", "", "Lcom/openlayer/api/core/MultipartField;", "openlayer-java-core"})
@JvmName(name="HttpRequestBodies")
public final class HttpRequestBodies {
    public static final /* synthetic */ <T> HttpRequestBody json(JsonMapper jsonMapper, T value2) {
        Intrinsics.checkNotNullParameter((Object)jsonMapper, (String)"jsonMapper");
        boolean $i$f$json = false;
        return new HttpRequestBody(jsonMapper, value2){
            @NotNull
            private final Lazy bytes$delegate;
            {
                this.bytes$delegate = LazyKt.lazy((Function0)((Function0)new Function0<byte[]>($jsonMapper, $value){
                    final /* synthetic */ JsonMapper $jsonMapper;
                    final /* synthetic */ T $value;
                    {
                        this.$jsonMapper = $jsonMapper;
                        this.$value = $value;
                        super(0);
                    }

                    public final byte[] invoke() {
                        return this.$jsonMapper.writeValueAsBytes(this.$value);
                    }
                }));
            }

            private final byte[] getBytes() {
                Lazy lazy = this.bytes$delegate;
                Object object = lazy.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-bytes>(...)");
                return (byte[])object;
            }

            public void writeTo(@NotNull OutputStream outputStream) {
                Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
                outputStream.write(this.getBytes());
            }

            @NotNull
            public String contentType() {
                return "application/json";
            }

            public long contentLength() {
                return this.getBytes().length;
            }

            public boolean repeatable() {
                return true;
            }

            public void close() {
            }
        };
    }

    public static final /* synthetic */ HttpRequestBody multipartFormData(JsonMapper jsonMapper, Map fields) {
        Intrinsics.checkNotNullParameter((Object)jsonMapper, (String)"jsonMapper");
        Intrinsics.checkNotNullParameter((Object)fields, (String)"fields");
        return new HttpRequestBody(fields, jsonMapper){
            @NotNull
            private final Lazy entity$delegate;
            {
                this.entity$delegate = LazyKt.lazy((Function0)((Function0)new Function0<HttpEntity>($fields, $jsonMapper, this){
                    final /* synthetic */ Map<String, MultipartField<?>> $fields;
                    final /* synthetic */ JsonMapper $jsonMapper;
                    final /* synthetic */ multipartFormData.1 this$0;
                    {
                        this.$fields = $fields;
                        this.$jsonMapper = $jsonMapper;
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final HttpEntity invoke() {
                        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
                        Map<String, MultipartField<?>> map2 = this.$fields;
                        JsonMapper jsonMapper = this.$jsonMapper;
                        multipartFormData.1 var4_4 = this.this$0;
                        MultipartEntityBuilder $this$invoke_u24lambda_u242 = multipartEntityBuilder;
                        boolean bl = false;
                        Map<String, MultipartField<?>> $this$forEach$iv = map2;
                        boolean $i$f$forEach = false;
                        Iterator<Map.Entry<String, MultipartField<?>>> iterator = $this$forEach$iv.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Sequence parts;
                            Sequence sequence;
                            Map.Entry<String, MultipartField<?>> element$iv;
                            Map.Entry<String, MultipartField<?>> entry = element$iv = iterator.next();
                            boolean bl2 = false;
                            String name = entry.getKey();
                            MultipartField<?> field = entry.getValue();
                            Object knownValue = OptionalsKt.getOrNull(field.value().asKnown());
                            if (knownValue instanceof InputStream) {
                                Object[] objectArray = new Pair[]{TuplesKt.to((Object)name, (Object)knownValue)};
                                sequence = SequencesKt.sequenceOf((Object[])objectArray);
                            } else {
                                JsonNode node = jsonMapper.valueToTree(field.value());
                                Intrinsics.checkNotNullExpressionValue((Object)node, (String)"node");
                                sequence = multipartFormData.1.access$serializePart(var4_4, name, node);
                            }
                            Sequence $this$forEach$iv2 = parts = sequence;
                            boolean $i$f$forEach2 = false;
                            for (E element$iv2 : $this$forEach$iv2) {
                                Pair pair = (Pair)element$iv2;
                                boolean bl3 = false;
                                String name2 = (String)pair.component1();
                                InputStream bytes2 = (InputStream)pair.component2();
                                $this$invoke_u24lambda_u242.addBinaryBody(name2, bytes2, ContentType.parseLenient((CharSequence)field.contentType()), (String)OptionalsKt.getOrNull(field.filename()));
                            }
                        }
                        return multipartEntityBuilder.build();
                    }
                }));
            }

            private final HttpEntity getEntity() {
                Lazy lazy = this.entity$delegate;
                Object object = lazy.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-entity>(...)");
                return (HttpEntity)object;
            }

            private final Sequence<Pair<String, InputStream>> serializePart(String name, JsonNode node) {
                Sequence sequence;
                JsonNodeType jsonNodeType = node.getNodeType();
                switch (jsonNodeType == null ? -1 : multipartFormData.WhenMappings.$EnumSwitchMapping$0[jsonNodeType.ordinal()]) {
                    case 1: 
                    case 2: {
                        sequence = SequencesKt.emptySequence();
                        break;
                    }
                    case 3: {
                        Object[] objectArray = new Pair[1];
                        byte[] byArray = node.binaryValue();
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"node.binaryValue()");
                        byte[] byArray2 = byArray;
                        objectArray[0] = TuplesKt.to((Object)name, (Object)new ByteArrayInputStream(byArray2));
                        sequence = SequencesKt.sequenceOf((Object[])objectArray);
                        break;
                    }
                    case 4: {
                        Object[] objectArray = new Pair[1];
                        String string = node.textValue();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.textValue()");
                        objectArray[0] = TuplesKt.to((Object)name, (Object)this.inputStream(string));
                        sequence = SequencesKt.sequenceOf((Object[])objectArray);
                        break;
                    }
                    case 5: {
                        Object[] objectArray = new Pair[]{TuplesKt.to((Object)name, (Object)this.inputStream(String.valueOf(node.booleanValue())))};
                        sequence = SequencesKt.sequenceOf((Object[])objectArray);
                        break;
                    }
                    case 6: {
                        Object[] objectArray = new Pair[]{TuplesKt.to((Object)name, (Object)this.inputStream(node.numberValue().toString()))};
                        sequence = SequencesKt.sequenceOf((Object[])objectArray);
                        break;
                    }
                    case 7: {
                        Object[] objectArray = new Pair[1];
                        Iterator iterator = node.elements();
                        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"node\n                                .elements()");
                        objectArray[0] = TuplesKt.to((Object)name, (Object)this.inputStream(SequencesKt.joinToString$default((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.asSequence((Iterator)iterator), (Function1)((Function1)new Function1<JsonNode, String>(node){
                            final /* synthetic */ JsonNode $node;
                            {
                                this.$node = $node;
                                super(1);
                            }

                            @Nullable
                            public final String invoke(JsonNode element) {
                                String string;
                                JsonNodeType jsonNodeType = element.getNodeType();
                                switch (jsonNodeType == null ? -1 : multipartFormData.serializePart.WhenMappings.$EnumSwitchMapping$0[jsonNodeType.ordinal()]) {
                                    case 1: 
                                    case 2: {
                                        string = null;
                                        break;
                                    }
                                    case 3: {
                                        string = this.$node.textValue();
                                        break;
                                    }
                                    case 4: {
                                        string = String.valueOf(this.$node.booleanValue());
                                        break;
                                    }
                                    case 5: {
                                        string = this.$node.numberValue().toString();
                                        break;
                                    }
                                    case -1: 
                                    case 6: 
                                    case 7: 
                                    case 8: 
                                    case 9: {
                                        throw new OpenlayerInvalidDataException("Unexpected JsonNode type in array: " + this.$node.getNodeType(), null, 2, null);
                                    }
                                    default: {
                                        throw new NoWhenBranchMatchedException();
                                    }
                                }
                                return string;
                            }
                        })), (CharSequence)",", null, null, (int)0, null, null, (int)62, null)));
                        sequence = SequencesKt.sequenceOf((Object[])objectArray);
                        break;
                    }
                    case 8: {
                        Iterator iterator = node.fields();
                        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"node.fields()");
                        sequence = SequencesKt.flatMap((Sequence)SequencesKt.asSequence((Iterator)iterator), (Function1)((Function1)new Function1<Map.Entry<String, JsonNode>, Sequence<? extends Pair<? extends String, ? extends InputStream>>>(this, name){
                            final /* synthetic */ multipartFormData.1 this$0;
                            final /* synthetic */ String $name;
                            {
                                this.this$0 = $receiver;
                                this.$name = $name;
                                super(1);
                            }

                            @NotNull
                            public final Sequence<Pair<String, InputStream>> invoke(Map.Entry<String, JsonNode> entry) {
                                Intrinsics.checkNotNullExpressionValue(entry, (String)"(key, value)");
                                String key = entry.getKey();
                                JsonNode value2 = entry.getValue();
                                String string = this.$name + '[' + key + ']';
                                Intrinsics.checkNotNullExpressionValue((Object)value2, (String)"value");
                                return multipartFormData.1.access$serializePart(this.this$0, string, value2);
                            }
                        }));
                        break;
                    }
                    case -1: 
                    case 9: {
                        throw new OpenlayerInvalidDataException("Unexpected JsonNode type: " + node.getNodeType(), null, 2, null);
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return sequence;
            }

            private final InputStream inputStream(String $this$inputStream) {
                Object object = $this$inputStream;
                byte[] byArray = ((String)object).getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                object = byArray;
                return new ByteArrayInputStream((byte[])object);
            }

            public void writeTo(@NotNull OutputStream outputStream) {
                Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
                this.getEntity().writeTo(outputStream);
            }

            @NotNull
            public String contentType() {
                String string = this.getEntity().getContentType();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"entity.contentType");
                return string;
            }

            public long contentLength() {
                return this.getEntity().getContentLength();
            }

            public boolean repeatable() {
                return this.getEntity().isRepeatable();
            }

            public void close() {
                this.getEntity().close();
            }

            public static final /* synthetic */ Sequence access$serializePart(multipartFormData.1 $this, String name, JsonNode node) {
                return $this.serializePart(name, node);
            }
        };
    }
}

