/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.client;

import com.openshift.client.OpenShiftException;
import com.openshift.internal.client.AbstractOpenShiftResource;
import com.openshift.internal.client.ServiceParameter;
import com.openshift.internal.client.response.Link;
import com.openshift.internal.client.response.RestResponse;

public class ServiceRequest {
    private Link link;
    private String linkName;
    private AbstractOpenShiftResource resource;

    protected ServiceRequest(String linkName, AbstractOpenShiftResource resource) {
        this(resource);
        this.linkName = linkName;
    }

    protected ServiceRequest(Link link, AbstractOpenShiftResource resource) {
        this(resource);
        this.link = link;
    }

    protected ServiceRequest(AbstractOpenShiftResource resource) {
        this.resource = resource;
    }

    Link getLink() throws OpenShiftException {
        if (this.link != null) {
            return this.link;
        }
        if (this.resource == null) {
            return null;
        }
        return this.resource.getLink(this.linkName);
    }

    public <DTO> DTO execute(ServiceParameter ... parameters) throws OpenShiftException {
        Link link = this.getLink();
        if (link == null) {
            throw new OpenShiftException("Could not request resource, no link present", new Object[0]);
        }
        RestResponse response = this.resource.getService().request(link, parameters);
        if (response != null) {
            return (DTO)response.getData();
        }
        return null;
    }
}

