/*
 * Decompiled with CFR 0.152.
 */
package com.pervasivecode.utils.time.testing;

import com.google.common.base.Preconditions;
import com.pervasivecode.utils.time.api.PeriodicRunner;

public class FakePeriodicRunner
implements PeriodicRunner {
    private Runnable task = null;
    public boolean started = false;

    @Override
    public void setPeriodicTask(Runnable task) {
        Preconditions.checkState((this.task == null ? 1 : 0) != 0, (Object)"A task is already scheduled in this runner. Call stop() before setting a different scheduled task, or create a new SimplePeriodicRunner instance to handle an additional scheduled task.");
        Preconditions.checkState((!this.started ? 1 : 0) != 0);
        this.task = (Runnable)Preconditions.checkNotNull((Object)task);
    }

    @Override
    public void start() {
        Preconditions.checkState((this.task != null ? 1 : 0) != 0, (Object)"No periodic task has been set.");
        Preconditions.checkState((!this.started ? 1 : 0) != 0, (Object)"The task has already been started.");
        this.started = true;
    }

    @Override
    public void stop() {
        Preconditions.checkState((boolean)this.started, (Object)"The periodic task is not running.");
        this.started = false;
    }

    public void runOnce() {
        Preconditions.checkState((boolean)this.started, (Object)"The periodic task has not been started yet, or has been stopped.");
        this.task.run();
    }
}

