/*
 * Decompiled with CFR 0.152.
 */
package snlogic;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import models.ActionResult;
import models.ActionType;
import models.ClientFingurePrint;
import models.EventOptions;
import models.FetchOptions;
import models.SecureNativeOptions;
import models.SnEvent;
import models.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import snlogic.EventManager;
import snlogic.EventTypes;
import snlogic.Utils;

@Service(value="snEventMAnager")
public class SnEventManager
implements EventManager {
    private final String SN_COOKIE_NAME = "_sn";
    private final String USERAGENT_HEADER = "user-agent";
    private final String API_DEFAULT_URL = "https://api.securenative.com/v1/collector";
    private final String POST = "POST";
    private final String EMPTY = "";
    private FetchOptions defaultFetchOptions;
    private SecureNativeOptions options;
    private List<FetchOptions> events;
    private boolean sendEnabled = true;
    @Autowired
    public Utils utils;

    public SnEventManager() {
    }

    public SnEventManager(SecureNativeOptions options) {
        this.defaultFetchOptions = new FetchOptions(options != null && options.getApiUrl() != null ? options.getApiUrl() : "https://api.securenative.com/v1/collector", options.getApiKey(), "POST", options.getTimeout());
        this.options = options;
        this.events = new ArrayList<FetchOptions>();
        this.startEventsPersist();
    }

    private void sendEvents() {
        FetchOptions fetchEvent;
        if (this.events.size() > 0 && this.sendEnabled && (fetchEvent = this.events.remove(0)).fetch() == null) {
            this.events.add(0, fetchEvent);
            double backOff = Math.ceil(Math.random() * 10.0) * 1000.0;
            this.sendEnabled = false;
            this.setTimeout(() -> {
                this.sendEnabled = true;
            }, (int)backOff);
        }
    }

    @Override
    public SnEvent buildEvent(HttpServletRequest request, EventOptions options) {
        String decodedCookie = this.utils.base64decode(this.utils.getCookie(request, options != null && !Strings.isNullOrEmpty((String)options.getCookieName()) ? options.getCookieName() : "_sn"));
        ClientFingurePrint clientFP = this.utils.parseClientFP(decodedCookie);
        String eventype = options == null || Strings.isNullOrEmpty((String)options.getEventType()) ? EventTypes.types.get((Object)EventTypes.EventKey.LOG_IN) : options.getEventType();
        String cid = clientFP != null ? clientFP.getCid() : "";
        String vid = UUID.randomUUID().toString();
        String fp = clientFP != null ? clientFP.getFp() : "";
        String ip = options != null && options.getIp() != null ? options.getIp() : this.utils.remoteIpFromRequest(request);
        String remoteIP = request.getRemoteAddr();
        String userAgent = options != null && options.getUserAgent() != null ? options.getUserAgent() : request.getHeader("user-agent");
        User user = options != null && options.getUser() != null ? options.getUser() : new User("anonymous", null, null);
        String device = options != null && options.getDevice() != null ? options.getDevice() : "";
        HashMap<String, String> params = options != null && options.getParams() != null ? options.getParams() : new HashMap<String, String>();
        return new SnEvent(eventype, cid, vid, fp, ip, remoteIP, userAgent, user, Instant.now().getEpochSecond(), device, params);
    }

    @Override
    public ActionResult sendSync(SnEvent event, String requestUrl) {
        FetchOptions fetchEvent = new FetchOptions(this.options.getApiUrl(), this.options.getApiKey(), this.defaultFetchOptions.getMethod(), this.options.getTimeout());
        String response = fetchEvent.fetch();
        if (response == null) {
            return new ActionResult(ActionType.type.ALLOW, 0.0, new String[0]);
        }
        Gson gson = new Gson();
        try {
            return (ActionResult)gson.fromJson(response, ActionResult.class);
        }
        catch (Exception e) {
            System.err.println(e);
            return new ActionResult(ActionType.type.ALLOW, 0.0, new String[0]);
        }
    }

    @Override
    public void sendAsync(SnEvent event, String url) {
        if ((long)this.events.size() >= this.options.getMaxEvents()) {
            this.events.remove(0);
        }
        this.events.add(0, new FetchOptions(this.options.getApiUrl(), this.options.getApiKey(), this.defaultFetchOptions.getMethod(), this.options.getTimeout()));
    }

    private void setTimeout(Runnable runnable, int delay) {
        new Thread(() -> {
            try {
                Thread.sleep(delay);
                runnable.run();
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }).start();
    }

    private void startEventsPersist() {
        if (this.options.isAutoSend().booleanValue()) {
            new Timer().scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    SnEventManager.this.sendEvents();
                }
            }, 0L, (long)this.options.getInterval());
        }
    }
}

