/*
 * Decompiled with CFR 0.152.
 */
package snlogic;

import com.google.common.base.Strings;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import models.ActionResult;
import models.ActionType;
import models.EventOptions;
import snlogic.EventTypes;
import snlogic.SecureNative;
import snlogic.Utils;

public class VerifyRequestMiddleware
implements Filter {
    private SecureNative sn;
    private Utils utils;

    public VerifyRequestMiddleware(SecureNative sn) {
        this.sn = sn;
    }

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)servletRequest;
        HttpServletResponse res = (HttpServletResponse)servletResponse;
        String cookie = this.utils.getCookie(req, null);
        if (Strings.isNullOrEmpty((String)cookie)) {
            ActionResult response = this.sn.verify(new EventOptions(this.utils.remoteIpFromRequest(req), req.getHeader("user-agent"), EventTypes.types.get((Object)EventTypes.EventKey.VERIFY)), req);
            if (ActionType.type.BLOCK == response.getAction()) {
                res.sendRedirect(String.valueOf(500));
            }
            if (ActionType.type.REDIRECT == response.getAction()) {
                res.sendRedirect("/error");
            }
        }
        filterChain.doFilter((ServletRequest)req, (ServletResponse)res);
    }

    public void destroy() {
    }
}

