/*
 * Decompiled with CFR 0.152.
 */
package snlogic;

import com.google.common.base.Strings;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import models.ActionType;
import models.EventOptions;
import models.RiskResult;
import snlogic.EventTypes;
import snlogic.ISDK;
import snlogic.SecureNative;
import snlogic.Utils;

public class VerifyRequestMiddleware
implements Filter {
    private ISDK sn;
    private Utils utils;

    public VerifyRequestMiddleware(SecureNative sn) {
        this.sn = sn;
    }

    public void init(FilterConfig filterConfig) {
        this.utils = new Utils();
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)servletRequest;
        HttpServletResponse res = (HttpServletResponse)servletResponse;
        String cookie = this.utils.getCookie(req, null);
        if (Strings.isNullOrEmpty((String)cookie)) {
            RiskResult response = this.sn.verify(new EventOptions(this.utils.remoteIpFromRequest(req), req.getHeader("user-agent"), EventTypes.VERIFY.getType()), req);
            if (ActionType.type.BLOCK.name() == response.getRiskLevel()) {
                res.sendRedirect(String.valueOf(500));
            }
            if (ActionType.type.REDIRECT.name() == response.getRiskLevel()) {
                res.sendRedirect("/error");
            }
        }
        filterChain.doFilter((ServletRequest)req, (ServletResponse)res);
    }

    public void destroy() {
    }
}

