/*
 * Decompiled with CFR 0.152.
 */
package snlogic;

import com.google.common.base.Strings;
import exceptions.SecureNativeSDKException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import snlogic.Utils;

public class VerifyWebHookMiddleware
implements Filter {
    private String apikey;
    private Utils utils;
    private final String SINATURE_KEY = "x-securenative";

    public VerifyWebHookMiddleware(String apiKey) {
        this.apikey = apiKey;
        this.utils = new Utils();
    }

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        String payload;
        HttpServletRequest req = (HttpServletRequest)servletRequest;
        HttpServletResponse res = (HttpServletResponse)servletResponse;
        HttpServletRequestWrapper n = new HttpServletRequestWrapper(req);
        String signature = "";
        if (req != null && !Strings.isNullOrEmpty((String)req.getHeader("x-securenative"))) {
            signature = req.getHeader("x-securenative");
        }
        if (Strings.isNullOrEmpty((String)(payload = this.getBody(servletRequest)))) {
            res.sendError(400, "bad request");
            return;
        }
        String comparison_signature = "";
        try {
            comparison_signature = this.utils.calculateRFC2104HMAC(payload, this.apikey);
        }
        catch (SecureNativeSDKException e) {
            e.printStackTrace();
            res.sendError(400, "bad request");
            return;
        }
        if (!signature.equals(comparison_signature)) {
            res.sendError(401, "Mismatched signatures");
            return;
        }
        filterChain.doFilter((ServletRequest)req, (ServletResponse)res);
    }

    public void destroy() {
    }

    private String getBody(ServletRequest servletRequest) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        try (BufferedReader bufferedReader = null;){
            ServletInputStream inputStream = servletRequest.getInputStream();
            if (inputStream != null) {
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)inputStream));
                char[] charBuffer = new char[128];
                int bytesRead = -1;
                while ((bytesRead = bufferedReader.read(charBuffer)) > 0) {
                    stringBuilder.append(charBuffer, 0, bytesRead);
                }
            } else {
                stringBuilder.append("");
            }
        }
        return stringBuilder.toString();
    }
}

