/*
 * Decompiled with CFR 0.152.
 */
package com.securenative.agent.events;

import com.securenative.agent.config.SecureNativeOptions;
import com.securenative.agent.enums.EventTypes;
import com.securenative.agent.events.AgentHeartBeatEvent;
import com.securenative.agent.events.AgentLoginEvent;
import com.securenative.agent.events.AgentLogoutEvent;
import com.securenative.agent.events.ConfigEvent;
import com.securenative.agent.events.ErrorEvent;
import com.securenative.agent.events.Event;
import com.securenative.agent.events.LoginChallengeEvent;
import com.securenative.agent.events.LoginEvent;
import com.securenative.agent.events.LoginFailureEvent;
import com.securenative.agent.events.LogoutEvent;
import com.securenative.agent.events.PerformanceEvent;
import com.securenative.agent.events.RequestEvent;
import com.securenative.agent.events.SDKEvent;
import com.securenative.agent.models.EventOptions;
import com.securenative.agent.models.RequestOptions;
import com.securenative.agent.models.User;

public class EventFactory {
    public static Event createEvent(EventTypes eventType, Object ... args) {
        if (eventType == EventTypes.AGENT_LOG_IN) {
            String framework = (String)args[0];
            String frameworkVersion = (String)args[1];
            String appName = (String)args[2];
            return new AgentLoginEvent(framework, frameworkVersion, appName);
        }
        if (eventType == EventTypes.AGENT_LOG_OUT) {
            return new AgentLogoutEvent();
        }
        if (eventType == EventTypes.ERROR) {
            String stackTrace = (String)args[0];
            String message = (String)args[1];
            return new ErrorEvent(stackTrace, message);
        }
        if (eventType == EventTypes.CONFIG) {
            String appName = (String)args[0];
            return new ConfigEvent(appName);
        }
        if (eventType == EventTypes.HEARTBEAT) {
            return new AgentHeartBeatEvent();
        }
        if (eventType == EventTypes.REQUEST) {
            RequestOptions options = (RequestOptions)args[0];
            return new RequestEvent(options);
        }
        if (eventType == EventTypes.SDK) {
            EventOptions eventOptions = (EventOptions)args[0];
            SecureNativeOptions snOptions = (SecureNativeOptions)args[2];
            return new SDKEvent(eventOptions, snOptions);
        }
        if (eventType == EventTypes.LOG_IN) {
            User user = (User)args[0];
            return new LoginEvent(user);
        }
        if (eventType == EventTypes.LOG_OUT) {
            User user = (User)args[0];
            return new LogoutEvent(user);
        }
        if (eventType == EventTypes.LOG_IN_CHALLENGE) {
            User user = (User)args[0];
            return new LoginChallengeEvent(user);
        }
        if (eventType == EventTypes.LOG_IN_FAILURE) {
            User user = (User)args[0];
            return new LoginFailureEvent(user);
        }
        if (eventType == EventTypes.PERFORMANCE) {
            return new PerformanceEvent();
        }
        return null;
    }
}

