/*
 * Decompiled with CFR 0.152.
 */
package com.soundcloud.api;

import com.soundcloud.api.CloudAPI;
import com.soundcloud.api.Env;
import com.soundcloud.api.Http;
import com.soundcloud.api.OAuth2HttpRequestInterceptor;
import com.soundcloud.api.OAuth2Scheme;
import com.soundcloud.api.Request;
import com.soundcloud.api.Token;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.Arrays;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthSchemeFactory;
import org.apache.http.auth.AuthScope;
import org.apache.http.client.AuthenticationHandler;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.RedirectHandler;
import org.apache.http.client.RequestDirector;
import org.apache.http.client.UserTokenHandler;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultRequestDirector;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestExecutor;
import org.json.JSONException;

public class ApiWrapper
implements CloudAPI,
Serializable {
    private static final long serialVersionUID = 3662083416905771921L;
    public final Env env;
    private Token mToken;
    private final String mClientId;
    private final String mClientSecret;
    private final URI mRedirectUri;
    private transient HttpClient httpClient;
    private transient CloudAPI.TokenListener listener;

    public ApiWrapper(String clientId, String clientSecret, URI redirectUri, Token token, Env env) {
        this.mClientId = clientId;
        this.mClientSecret = clientSecret;
        this.mRedirectUri = redirectUri;
        this.mToken = token == null ? new Token(null, null) : token;
        this.env = env;
    }

    public Token login(String username, String password) throws IOException {
        if (username == null || password == null) {
            throw new IllegalArgumentException("username or password is null");
        }
        this.mToken = this.requestToken(Request.to("/oauth2/token", new Object[0]).with("grant_type", "password", "client_id", this.mClientId, "client_secret", this.mClientSecret, "username", username, "password", password));
        return this.mToken;
    }

    public Token authorizationCode(String code) throws IOException {
        if (code == null) {
            throw new IllegalArgumentException("username or password is null");
        }
        this.mToken = this.requestToken(Request.to("/oauth2/token", new Object[0]).with("grant_type", "authorization_code", "client_id", this.mClientId, "client_secret", this.mClientSecret, "redirect_uri", this.mRedirectUri, "code", code));
        return this.mToken;
    }

    public Token clientCredentials() throws IOException {
        return this.clientCredentials("signup");
    }

    public Token clientCredentials(String scope) throws IOException {
        Request req = Request.to("/oauth2/token", new Object[0]).with("grant_type", "client_credentials", "client_id", this.mClientId, "client_secret", this.mClientSecret);
        if (scope != null) {
            req.add("scope", scope);
        }
        Token token = this.requestToken(req);
        if (scope != null && !token.scoped(scope)) {
            throw new CloudAPI.InvalidTokenException(-1, "Could not obtain requested scope '" + scope + "' (got: '" + token.scope + "')");
        }
        return token;
    }

    public Token refreshToken() throws IOException {
        if (this.mToken == null || this.mToken.refresh == null) {
            throw new IllegalStateException("no refresh token available");
        }
        this.mToken = this.requestToken(Request.to("/oauth2/token", new Object[0]).with("grant_type", "refresh_token", "client_id", this.mClientId, "client_secret", this.mClientSecret, "refresh_token", this.mToken.refresh));
        return this.mToken;
    }

    public Token exchangeOAuth1Token(String oauth1AccessToken) throws IOException {
        if (oauth1AccessToken == null) {
            throw new IllegalArgumentException("need access token");
        }
        this.mToken = this.requestToken(Request.to("/oauth2/token", new Object[0]).with("grant_type", "oauth1_token", "client_id", this.mClientId, "client_secret", this.mClientSecret, "refresh_token", oauth1AccessToken));
        return this.mToken;
    }

    public Token invalidateToken() {
        if (this.mToken != null) {
            Token alternative = this.listener == null ? null : this.listener.onTokenInvalid(this.mToken);
            this.mToken.invalidate();
            if (alternative != null) {
                this.mToken = alternative;
                return this.mToken;
            }
            return null;
        }
        return null;
    }

    public URI authorizationCodeUrl(String ... options) {
        return this.getURI(Request.to(options.length == 0 ? "/connect" : options[0], new Object[0]).with("redirect_uri", this.mRedirectUri, "client_id", this.mClientId, "response_type", "code"), false, true);
    }

    public URI getURI(Request request, boolean api, boolean secure) {
        return URI.create((api ? this.env.getResourceHost(secure) : this.env.getAuthResourceHost(secure)).toURI()).resolve(request.toUrl());
    }

    protected Token requestToken(Request request) throws IOException {
        HttpResponse response = this.getHttpClient().execute(this.env.sslResourceHost, (HttpRequest)request.buildRequest(HttpPost.class));
        int status = response.getStatusLine().getStatusCode();
        if (status == 200) {
            Token token = new Token(Http.getJSON(response));
            if (this.listener != null) {
                this.listener.onTokenRefreshed(token);
            }
            return token;
        }
        String error = "";
        try {
            error = Http.getJSON(response).getString("error");
        }
        catch (IOException ignored) {
        }
        catch (JSONException ignored) {
            // empty catch block
        }
        throw status == 401 ? new CloudAPI.InvalidTokenException(status, error) : new IOException(status + " " + response.getStatusLine().getReasonPhrase() + " " + error);
    }

    protected HttpParams getParams() {
        return Http.defaultParams();
    }

    protected SocketFactory getSocketFactory() {
        return PlainSocketFactory.getSocketFactory();
    }

    protected SSLSocketFactory getSSLSocketFactory() {
        return SSLSocketFactory.getSocketFactory();
    }

    protected String getUserAgent() {
        return "SoundCloud Java Wrapper (1.0.0)";
    }

    public HttpClient getHttpClient() {
        if (this.httpClient == null) {
            HttpParams params = this.getParams();
            HttpClientParams.setRedirecting((HttpParams)params, (boolean)false);
            HttpProtocolParams.setUserAgent((HttpParams)params, (String)this.getUserAgent());
            SchemeRegistry registry = new SchemeRegistry();
            registry.register(new Scheme("http", this.getSocketFactory(), 80));
            SSLSocketFactory sslFactory = this.getSSLSocketFactory();
            if (this.env == Env.SANDBOX) {
                sslFactory.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            }
            registry.register(new Scheme("https", (SocketFactory)sslFactory, 443));
            this.httpClient = new DefaultHttpClient((ClientConnectionManager)new ThreadSafeClientConnManager(params, registry), params){
                {
                    this.setKeepAliveStrategy(new ConnectionKeepAliveStrategy(){

                        public long getKeepAliveDuration(HttpResponse httpResponse, HttpContext httpContext) {
                            return 20000L;
                        }
                    });
                    this.getCredentialsProvider().setCredentials(new AuthScope(AuthScope.ANY_HOST, -1, "SoundCloud", "oauth"), OAuth2Scheme.EmptyCredentials.INSTANCE);
                    this.getAuthSchemes().register("oauth", (AuthSchemeFactory)new OAuth2Scheme.Factory(ApiWrapper.this));
                }

                protected HttpContext createHttpContext() {
                    HttpContext ctxt = super.createHttpContext();
                    ctxt.setAttribute("http.auth.scheme-pref", Arrays.asList("oauth", "digest", "basic"));
                    return ctxt;
                }

                protected BasicHttpProcessor createHttpProcessor() {
                    BasicHttpProcessor processor = super.createHttpProcessor();
                    processor.addInterceptor((HttpRequestInterceptor)new OAuth2HttpRequestInterceptor());
                    return processor;
                }

                protected RequestDirector createClientRequestDirector(HttpRequestExecutor requestExec, ClientConnectionManager conman, ConnectionReuseStrategy reustrat, ConnectionKeepAliveStrategy kastrat, HttpRoutePlanner rouplan, HttpProcessor httpProcessor, HttpRequestRetryHandler retryHandler, RedirectHandler redirectHandler, AuthenticationHandler targetAuthHandler, AuthenticationHandler proxyAuthHandler, UserTokenHandler stateHandler, HttpParams params) {
                    return ApiWrapper.this.getRequestDirector(requestExec, conman, reustrat, kastrat, rouplan, httpProcessor, retryHandler, redirectHandler, targetAuthHandler, proxyAuthHandler, stateHandler, params);
                }
            };
        }
        return this.httpClient;
    }

    public long resolve(String url) throws IOException {
        String s;
        Header location;
        HttpResponse resp = this.get(Request.to("/resolve", new Object[0]).with("url", url));
        if (resp.getStatusLine().getStatusCode() == 302 && (location = resp.getFirstHeader("Location")) != null && (s = location.getValue()).contains("/")) {
            try {
                return Integer.parseInt(s.substring(s.lastIndexOf("/") + 1, s.length()));
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
        }
        return -1L;
    }

    public HttpResponse get(Request request) throws IOException {
        return this.execute((HttpRequest)request.buildRequest(HttpGet.class));
    }

    public HttpResponse put(Request request) throws IOException {
        return this.execute((HttpRequest)request.buildRequest(HttpPut.class));
    }

    public HttpResponse post(Request request) throws IOException {
        return this.execute((HttpRequest)request.buildRequest(HttpPost.class));
    }

    public HttpResponse delete(Request request) throws IOException {
        return this.execute((HttpRequest)request.buildRequest(HttpDelete.class));
    }

    public Token getToken() {
        return this.mToken;
    }

    public void setToken(Token newToken) {
        this.mToken = newToken;
    }

    public synchronized void setTokenListener(CloudAPI.TokenListener listener) {
        this.listener = listener;
    }

    public HttpResponse execute(HttpRequest req) throws IOException {
        return this.getHttpClient().execute(this.env.sslResourceHost, this.addHeaders(req));
    }

    public void toFile(File f) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(f));
        oos.writeObject(this);
        oos.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ApiWrapper fromFile(File f) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = new ObjectInputStream(new FileInputStream(f));
        try {
            ApiWrapper apiWrapper = (ApiWrapper)ois.readObject();
            return apiWrapper;
        }
        finally {
            ois.close();
        }
    }

    public static Header createOAuthHeader(Token token) {
        return new BasicHeader("Authorization", "OAuth " + (token == null || !token.valid() ? "invalidated" : token.access));
    }

    protected HttpRequest addAuthHeader(HttpRequest request) {
        if (!request.containsHeader("Authorization")) {
            request.addHeader(ApiWrapper.createOAuthHeader(this.getToken()));
        }
        return request;
    }

    protected HttpRequest addAcceptHeader(HttpRequest request) {
        if (!request.containsHeader("Accept")) {
            request.addHeader("Accept", "application/json");
        }
        return request;
    }

    protected HttpRequest addHeaders(HttpRequest req) {
        return this.addAcceptHeader(this.addAuthHeader(req));
    }

    protected RequestDirector getRequestDirector(HttpRequestExecutor requestExec, ClientConnectionManager conman, ConnectionReuseStrategy reustrat, ConnectionKeepAliveStrategy kastrat, HttpRoutePlanner rouplan, HttpProcessor httpProcessor, HttpRequestRetryHandler retryHandler, RedirectHandler redirectHandler, AuthenticationHandler targetAuthHandler, AuthenticationHandler proxyAuthHandler, UserTokenHandler stateHandler, HttpParams params) {
        return new DefaultRequestDirector(requestExec, conman, reustrat, kastrat, rouplan, httpProcessor, retryHandler, redirectHandler, targetAuthHandler, proxyAuthHandler, stateHandler, params);
    }
}

