/*
 * Decompiled with CFR 0.152.
 */
package com.soundcloud.api;

import com.soundcloud.api.Request;
import com.soundcloud.api.Token;
import java.io.IOException;
import java.net.URI;
import org.apache.http.HttpResponse;

public interface CloudAPI {
    public static final String PASSWORD = "password";
    public static final String AUTHORIZATION_CODE = "authorization_code";
    public static final String REFRESH_TOKEN = "refresh_token";
    public static final String OAUTH1_TOKEN = "oauth1_token";
    public static final String CLIENT_CREDENTIALS = "client_credentials";
    public static final String REALM = "SoundCloud";
    public static final String OAUTH_SCHEME = "oauth";
    public static final String VERSION = "1.0.0";
    public static final String USER_AGENT = "SoundCloud Java Wrapper (1.0.0)";

    public Token login(String var1, String var2) throws IOException;

    public Token authorizationCode(String var1) throws IOException;

    public Token clientCredentials() throws IOException;

    public Token clientCredentials(String var1) throws IOException;

    public Token refreshToken() throws IOException;

    public Token exchangeOAuth1Token(String var1) throws IOException;

    public Token invalidateToken();

    public HttpResponse get(Request var1) throws IOException;

    public HttpResponse post(Request var1) throws IOException;

    public HttpResponse put(Request var1) throws IOException;

    public HttpResponse delete(Request var1) throws IOException;

    public long resolve(String var1) throws IOException;

    public Token getToken();

    public void setToken(Token var1);

    public void setTokenListener(TokenListener var1);

    public URI authorizationCodeUrl(String ... var1);

    public static class InvalidTokenException
    extends IOException {
        private static final long serialVersionUID = 1954919760451539868L;

        public InvalidTokenException(int code, String status) {
            super("HTTP error:" + code + " (" + status + ")");
        }
    }

    public static interface TokenListener {
        public Token onTokenInvalid(Token var1);

        public void onTokenRefreshed(Token var1);
    }
}

