/*
 * Decompiled with CFR 0.152.
 */
package com.soundcloud.api;

import com.soundcloud.api.Request;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;

class CountingMultipartEntity
implements HttpEntity {
    private HttpEntity mDelegate;
    private Request.TransferProgressListener mListener;

    public CountingMultipartEntity(HttpEntity delegate, Request.TransferProgressListener listener) {
        this.mDelegate = delegate;
        this.mListener = listener;
    }

    public void consumeContent() throws IOException {
        this.mDelegate.consumeContent();
    }

    public InputStream getContent() throws IOException, IllegalStateException {
        return this.mDelegate.getContent();
    }

    public Header getContentEncoding() {
        return this.mDelegate.getContentEncoding();
    }

    public long getContentLength() {
        return this.mDelegate.getContentLength();
    }

    public Header getContentType() {
        return this.mDelegate.getContentType();
    }

    public boolean isChunked() {
        return this.mDelegate.isChunked();
    }

    public boolean isRepeatable() {
        return this.mDelegate.isRepeatable();
    }

    public boolean isStreaming() {
        return this.mDelegate.isStreaming();
    }

    public void writeTo(OutputStream outstream) throws IOException {
        this.mDelegate.writeTo((OutputStream)new CountingOutputStream(outstream, this.mListener));
    }

    private static class CountingOutputStream
    extends FilterOutputStream {
        private final Request.TransferProgressListener mListener;
        private long mTransferred;

        public CountingOutputStream(OutputStream out, Request.TransferProgressListener listener) {
            super(out);
            this.mListener = listener;
            this.mTransferred = 0L;
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
            this.mTransferred += (long)len;
            if (this.mListener != null) {
                this.mListener.transferred(this.mTransferred);
            }
        }

        public void write(int b) throws IOException {
            this.out.write(b);
            ++this.mTransferred;
            if (this.mListener != null) {
                this.mListener.transferred(this.mTransferred);
            }
        }
    }
}

