/*
 * Decompiled with CFR 0.152.
 */
package com.soundcloud.api;

import java.io.IOException;
import java.io.InputStream;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.json.JSONException;
import org.json.JSONObject;

public class Http {
    public static final int BUFFER_SIZE = 8192;
    public static final int TIMEOUT = 20000;

    private Http() {
    }

    public static String getString(HttpResponse response) throws IOException {
        int n;
        InputStream is = response.getEntity().getContent();
        if (is == null) {
            return null;
        }
        int length = 8192;
        Header contentLength = null;
        try {
            contentLength = response.getFirstHeader("Content-Length");
        }
        catch (UnsupportedOperationException ignored) {
            // empty catch block
        }
        if (contentLength != null) {
            try {
                length = Integer.parseInt(contentLength.getValue());
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
        }
        StringBuilder sb = new StringBuilder(length);
        byte[] buffer = new byte[8192];
        while ((n = is.read(buffer)) != -1) {
            sb.append(new String(buffer, 0, n));
        }
        return sb.toString();
    }

    public static JSONObject getJSON(HttpResponse response) throws IOException {
        String json = Http.getString(response);
        if (json == null || json.length() == 0) {
            throw new IOException("JSON response is empty");
        }
        try {
            return new JSONObject(json);
        }
        catch (JSONException e) {
            throw new IOException("could not parse JSON document: " + e.getMessage() + " " + (json.length() > 80 ? json.substring(0, 79) + "..." : json));
        }
    }

    public static HttpParams defaultParams() {
        BasicHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)20000);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)20000);
        HttpConnectionParams.setSocketBufferSize((HttpParams)params, (int)8192);
        HttpConnectionParams.setStaleCheckingEnabled((HttpParams)params, (boolean)false);
        params.setBooleanParameter("http.protocol.expect-continue", false);
        params.setParameter("http.conn-manager.max-per-route", (Object)new ConnPerRoute(){

            public int getMaxForRoute(HttpRoute httpRoute) {
                return 6;
            }
        });
        return params;
    }
}

