/*
 * Decompiled with CFR 0.152.
 */
package com.soundcloud.api;

import com.soundcloud.api.ApiWrapper;
import com.soundcloud.api.CountingMultipartEntity;
import com.soundcloud.api.Token;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.message.BasicNameValuePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Request
implements Iterable<NameValuePair> {
    private List<NameValuePair> params = new ArrayList<NameValuePair>();
    private Map<String, File> files;
    private Token mToken;
    private String mResource;
    private TransferProgressListener listener;

    public Request() {
    }

    public Request(String resource) {
        this.mResource = resource;
    }

    public static Request to(String resource, Object ... args) {
        if (args != null && args.length > 0) {
            resource = String.format(resource, args);
        }
        return new Request(resource);
    }

    public Request add(String name, Object value) {
        this.params.add((NameValuePair)new BasicNameValuePair(name, String.valueOf(value)));
        return this;
    }

    public Request with(Object ... args) {
        if (args != null) {
            if (args.length % 2 != 0) {
                throw new IllegalArgumentException("need even number of arguments");
            }
            for (int i = 0; i < args.length; i += 2) {
                this.add(args[i].toString(), args[i + 1]);
            }
        }
        return this;
    }

    public Request usingToken(Token token) {
        this.mToken = token;
        return this;
    }

    public int size() {
        return this.params.size();
    }

    public String queryString() {
        return URLEncodedUtils.format(this.params, (String)"UTF-8");
    }

    public String toUrl(String resource) {
        return this.params.isEmpty() ? resource : resource + "?" + this.queryString();
    }

    public String toUrl() {
        return this.toUrl(this.mResource);
    }

    public Request withFile(String name, File file) {
        if (this.files == null) {
            this.files = new HashMap<String, File>();
        }
        if (file != null) {
            this.files.put(name, file);
        }
        return this;
    }

    public Request setProgressListener(TransferProgressListener listener) {
        this.listener = listener;
        return this;
    }

    public <T extends HttpRequestBase> T buildRequest(Class<T> method) {
        try {
            HttpRequestBase request = (HttpRequestBase)method.newInstance();
            if (request instanceof HttpEntityEnclosingRequestBase) {
                HttpEntityEnclosingRequestBase enclosingRequest = (HttpEntityEnclosingRequestBase)request;
                if (this.files != null && !this.files.isEmpty()) {
                    MultipartEntity multiPart = new MultipartEntity();
                    for (Map.Entry<String, File> e : this.files.entrySet()) {
                        multiPart.addPart(e.getKey(), (ContentBody)new FileBody(e.getValue()));
                    }
                    for (NameValuePair pair : this.params) {
                        multiPart.addPart(pair.getName(), (ContentBody)new StringBodyNoHeaders(pair.getValue()));
                    }
                    enclosingRequest.setEntity((HttpEntity)(this.listener == null ? multiPart : new CountingMultipartEntity((HttpEntity)multiPart, this.listener)));
                } else if (!this.params.isEmpty()) {
                    request.setHeader("Content-Type", "application/x-www-form-urlencoded");
                    enclosingRequest.setEntity((HttpEntity)new StringEntity(this.queryString()));
                }
                request.setURI(URI.create(this.mResource));
            } else {
                request.setURI(URI.create(this.toUrl()));
            }
            if (this.mToken != null) {
                request.addHeader(ApiWrapper.createOAuthHeader(this.mToken));
            }
            return (T)request;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Iterator<NameValuePair> iterator() {
        return this.params.iterator();
    }

    public String toString() {
        return "Request{params=" + this.params + ", files=" + this.files + ", mToken=" + this.mToken + ", mResource='" + this.mResource + '\'' + ", listener=" + this.listener + '}';
    }

    static class StringBodyNoHeaders
    extends StringBody {
        public StringBodyNoHeaders(String value) throws UnsupportedEncodingException {
            super(value);
        }

        public String getMimeType() {
            return null;
        }

        public String getTransferEncoding() {
            return null;
        }
    }

    public static interface TransferProgressListener {
        public void transferred(long var1);
    }
}

