/*
 * Decompiled with CFR 0.152.
 */
package com.soundcloud.api;

import com.soundcloud.api.CloudAPI;
import com.soundcloud.api.Env;
import com.soundcloud.api.Http;
import com.soundcloud.api.OAuth2HttpRequestInterceptor;
import com.soundcloud.api.OAuth2Scheme;
import com.soundcloud.api.Request;
import com.soundcloud.api.Stream;
import com.soundcloud.api.Token;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.Arrays;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthSchemeFactory;
import org.apache.http.auth.AuthScope;
import org.apache.http.client.AuthenticationHandler;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.RedirectHandler;
import org.apache.http.client.RequestDirector;
import org.apache.http.client.UserTokenHandler;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultRequestDirector;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestExecutor;
import org.json.JSONException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApiWrapper
implements CloudAPI,
Serializable {
    private static final long serialVersionUID = 3662083416905771921L;
    public static final String DEFAULT_CONTENT_TYPE = "application/json";
    public final Env env = Env.LIVE;
    private Token mToken;
    private final String mClientId;
    private final String mClientSecret;
    private final URI mRedirectUri;
    private transient HttpClient httpClient;
    private transient CloudAPI.TokenListener listener;
    private String mDefaultContentType;
    public static final int BUFFER_SIZE = 8192;
    public static final int TIMEOUT = 20000;
    public static final long KEEPALIVE_TIMEOUT = 20000L;
    public static final int MAX_TOTAL_CONNECTIONS = 10;
    public boolean debugRequests;
    private static final ThreadLocal<Request> defaultParams = new ThreadLocal<Request>(){

        @Override
        protected Request initialValue() {
            return new Request();
        }
    };

    public ApiWrapper(String clientId, String clientSecret, URI redirectUri, Token token) {
        this.mClientId = clientId;
        this.mClientSecret = clientSecret;
        this.mRedirectUri = redirectUri;
        this.mToken = token == null ? new Token(null, null) : token;
    }

    @Override
    public Token login(String username, String password, String ... scopes) throws IOException {
        if (username == null || password == null) {
            throw new IllegalArgumentException("username or password is null");
        }
        Request request = ApiWrapper.addScope(Request.to("/oauth2/token", new Object[0]).with("grant_type", "password", "client_id", this.mClientId, "client_secret", this.mClientSecret, "username", username, "password", password), scopes);
        this.mToken = this.requestToken(request);
        return this.mToken;
    }

    @Override
    public Token authorizationCode(String code, String ... scopes) throws IOException {
        if (code == null) {
            throw new IllegalArgumentException("code is null");
        }
        Request request = ApiWrapper.addScope(Request.to("/oauth2/token", new Object[0]).with("grant_type", "authorization_code", "client_id", this.mClientId, "client_secret", this.mClientSecret, "redirect_uri", this.mRedirectUri, "code", code), scopes);
        this.mToken = this.requestToken(request);
        return this.mToken;
    }

    @Override
    public Token clientCredentials(String ... scopes) throws IOException {
        Request req = ApiWrapper.addScope(Request.to("/oauth2/token", new Object[0]).with("grant_type", "client_credentials", "client_id", this.mClientId, "client_secret", this.mClientSecret), scopes);
        Token token = this.requestToken(req);
        if (scopes != null) {
            for (String scope : scopes) {
                if (token.scoped(scope)) continue;
                throw new CloudAPI.InvalidTokenException(-1, "Could not obtain requested scope '" + scope + "' (got: '" + token.scope + "')");
            }
        }
        return token;
    }

    @Override
    public Token extensionGrantType(String grantType, String ... scopes) throws IOException {
        Request req = ApiWrapper.addScope(Request.to("/oauth2/token", new Object[0]).with("grant_type", grantType, "client_id", this.mClientId, "client_secret", this.mClientSecret), scopes);
        this.mToken = this.requestToken(req);
        return this.mToken;
    }

    @Override
    public Token refreshToken() throws IOException {
        if (this.mToken == null || this.mToken.refresh == null) {
            throw new IllegalStateException("no refresh token available");
        }
        this.mToken = this.requestToken(Request.to("/oauth2/token", new Object[0]).with("grant_type", "refresh_token", "client_id", this.mClientId, "client_secret", this.mClientSecret, "refresh_token", this.mToken.refresh));
        return this.mToken;
    }

    @Override
    public Token exchangeOAuth1Token(String oauth1AccessToken) throws IOException {
        if (oauth1AccessToken == null) {
            throw new IllegalArgumentException("need access token");
        }
        this.mToken = this.requestToken(Request.to("/oauth2/token", new Object[0]).with("grant_type", "oauth1_token", "client_id", this.mClientId, "client_secret", this.mClientSecret, "refresh_token", oauth1AccessToken));
        return this.mToken;
    }

    @Override
    public Token invalidateToken() {
        if (this.mToken != null) {
            Token alternative = this.listener == null ? null : this.listener.onTokenInvalid(this.mToken);
            this.mToken.invalidate();
            if (alternative != null) {
                this.mToken = alternative;
                return this.mToken;
            }
            return null;
        }
        return null;
    }

    @Override
    public URI authorizationCodeUrl(String ... options) {
        Request req = Request.to(options.length == 0 ? "/connect" : options[0], new Object[0]).with("redirect_uri", this.mRedirectUri, "client_id", this.mClientId, "response_type", "code");
        if (options.length == 2) {
            req.add("scope", options[1]);
        }
        return this.getURI(req, false, true);
    }

    public URI getURI(Request request, boolean api, boolean secure) {
        URI uri = api ? this.env.getResourceURI(secure) : this.env.getAuthResourceURI(secure);
        return uri.resolve(request.toUrl());
    }

    public String getUserAgent() {
        return "SoundCloud Java Wrapper (1.2.0)";
    }

    protected Token requestToken(Request request) throws IOException {
        HttpResponse response = this.safeExecute(this.env.sslResourceHost, (HttpUriRequest)request.buildRequest(HttpPost.class));
        int status = response.getStatusLine().getStatusCode();
        if (status == 200) {
            Token token = new Token(Http.getJSON(response));
            if (this.listener != null) {
                this.listener.onTokenRefreshed(token);
            }
            return token;
        }
        String error = "";
        try {
            error = Http.getJSON(response).getString("error");
        }
        catch (IOException ignored) {
        }
        catch (JSONException ignored) {
            // empty catch block
        }
        throw status == 401 ? new CloudAPI.InvalidTokenException(status, error) : new IOException(status + " " + response.getStatusLine().getReasonPhrase() + " " + error);
    }

    protected HttpParams getParams() {
        BasicHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)20000);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)20000);
        HttpConnectionParams.setSocketBufferSize((HttpParams)params, (int)8192);
        ConnManagerParams.setMaxTotalConnections((HttpParams)params, (int)10);
        HttpConnectionParams.setStaleCheckingEnabled((HttpParams)params, (boolean)false);
        params.setBooleanParameter("http.protocol.expect-continue", false);
        params.setParameter("http.conn-manager.max-per-route", (Object)new ConnPerRoute(){

            public int getMaxForRoute(HttpRoute httpRoute) {
                if (ApiWrapper.this.env.isApiHost(httpRoute.getTargetHost())) {
                    return 10;
                }
                return 2;
            }
        });
        String proxyHost = System.getProperty("http.proxyHost");
        String proxyPort = System.getProperty("http.proxyPort");
        if (proxyHost != null) {
            int port = 80;
            try {
                port = Integer.parseInt(proxyPort);
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
            params.setParameter("http.route.default-proxy", (Object)new HttpHost(proxyHost, port));
        }
        return params;
    }

    public void setProxy(URI proxy) {
        HttpHost host;
        if (proxy != null) {
            Scheme scheme = this.getHttpClient().getConnectionManager().getSchemeRegistry().getScheme(proxy.getScheme());
            host = new HttpHost(proxy.getHost(), scheme.resolvePort(proxy.getPort()), scheme.getName());
        } else {
            host = null;
        }
        this.getHttpClient().getParams().setParameter("http.route.default-proxy", host);
    }

    public URI getProxy() {
        Object proxy = this.getHttpClient().getParams().getParameter("http.route.default-proxy");
        if (proxy instanceof HttpHost) {
            return URI.create(((HttpHost)proxy).toURI());
        }
        return null;
    }

    public boolean isProxySet() {
        return this.getProxy() != null;
    }

    protected SocketFactory getSocketFactory() {
        return PlainSocketFactory.getSocketFactory();
    }

    protected SSLSocketFactory getSSLSocketFactory() {
        return SSLSocketFactory.getSocketFactory();
    }

    @Override
    public HttpClient getHttpClient() {
        if (this.httpClient == null) {
            HttpParams params = this.getParams();
            HttpClientParams.setRedirecting((HttpParams)params, (boolean)false);
            HttpProtocolParams.setUserAgent((HttpParams)params, (String)this.getUserAgent());
            SchemeRegistry registry = new SchemeRegistry();
            registry.register(new Scheme("http", this.getSocketFactory(), 80));
            SSLSocketFactory sslFactory = this.getSSLSocketFactory();
            registry.register(new Scheme("https", (SocketFactory)sslFactory, 443));
            this.httpClient = new DefaultHttpClient((ClientConnectionManager)new ThreadSafeClientConnManager(params, registry), params){
                {
                    this.setKeepAliveStrategy(new ConnectionKeepAliveStrategy(){

                        public long getKeepAliveDuration(HttpResponse httpResponse, HttpContext httpContext) {
                            return 20000L;
                        }
                    });
                    this.getCredentialsProvider().setCredentials(new AuthScope(AuthScope.ANY_HOST, -1, "SoundCloud", "oauth"), OAuth2Scheme.EmptyCredentials.INSTANCE);
                    this.getAuthSchemes().register("oauth", (AuthSchemeFactory)new OAuth2Scheme.Factory(ApiWrapper.this));
                }

                protected HttpContext createHttpContext() {
                    HttpContext ctxt = super.createHttpContext();
                    ctxt.setAttribute("http.auth.scheme-pref", Arrays.asList("oauth", "digest", "basic"));
                    return ctxt;
                }

                protected BasicHttpProcessor createHttpProcessor() {
                    BasicHttpProcessor processor = super.createHttpProcessor();
                    processor.addInterceptor((HttpRequestInterceptor)new OAuth2HttpRequestInterceptor());
                    return processor;
                }

                protected RequestDirector createClientRequestDirector(HttpRequestExecutor requestExec, ClientConnectionManager conman, ConnectionReuseStrategy reustrat, ConnectionKeepAliveStrategy kastrat, HttpRoutePlanner rouplan, HttpProcessor httpProcessor, HttpRequestRetryHandler retryHandler, RedirectHandler redirectHandler, AuthenticationHandler targetAuthHandler, AuthenticationHandler proxyAuthHandler, UserTokenHandler stateHandler, HttpParams params) {
                    return ApiWrapper.this.getRequestDirector(requestExec, conman, reustrat, kastrat, rouplan, httpProcessor, retryHandler, redirectHandler, targetAuthHandler, proxyAuthHandler, stateHandler, params);
                }
            };
        }
        return this.httpClient;
    }

    @Override
    public long resolve(String url) throws IOException {
        HttpResponse resp = this.get(Request.to("/resolve", new Object[0]).with("url", url));
        if (resp.getStatusLine().getStatusCode() == 302) {
            Header location = resp.getFirstHeader("Location");
            if (location != null) {
                String s = location.getValue();
                if (s.contains("/")) {
                    try {
                        return Integer.parseInt(s.substring(s.lastIndexOf("/") + 1, s.length()));
                    }
                    catch (NumberFormatException e) {
                        throw new CloudAPI.ResolverException(e, resp);
                    }
                }
                throw new CloudAPI.ResolverException("Invalid string:" + s, resp);
            }
            throw new CloudAPI.ResolverException("No location header", resp);
        }
        throw new CloudAPI.ResolverException("Invalid status code", resp);
    }

    @Override
    public Stream resolveStreamUrl(String url, boolean skipLogging) throws IOException {
        HttpResponse resp = this.head(Request.to(url, new Object[0]));
        if (resp.getStatusLine().getStatusCode() == 302) {
            Header location = resp.getFirstHeader("Location");
            if (location != null && location.getValue() != null) {
                String headRedirect = location.getValue();
                resp = this.safeExecute(null, (HttpUriRequest)new HttpHead(headRedirect));
                if (resp.getStatusLine().getStatusCode() == 200) {
                    Stream stream = new Stream(url, headRedirect, resp);
                    Request req = Request.to(url, new Object[0]);
                    if (skipLogging) {
                        req.with("skip_logging", "1");
                    }
                    if ((resp = this.get(req)).getStatusLine().getStatusCode() == 302) {
                        return stream.withNewStreamUrl(resp.getFirstHeader("Location").getValue());
                    }
                    throw new CloudAPI.ResolverException("Unexpected response code", resp);
                }
                throw new CloudAPI.ResolverException("Unexpected response code", resp);
            }
            throw new CloudAPI.ResolverException("Location header not set", resp);
        }
        throw new CloudAPI.ResolverException("Unexpected response code", resp);
    }

    @Override
    public HttpResponse head(Request request) throws IOException {
        return this.execute(request, HttpHead.class);
    }

    @Override
    public HttpResponse get(Request request) throws IOException {
        return this.execute(request, HttpGet.class);
    }

    @Override
    public HttpResponse put(Request request) throws IOException {
        return this.execute(request, HttpPut.class);
    }

    @Override
    public HttpResponse post(Request request) throws IOException {
        return this.execute(request, HttpPost.class);
    }

    @Override
    public HttpResponse delete(Request request) throws IOException {
        return this.execute(request, HttpDelete.class);
    }

    @Override
    public Token getToken() {
        return this.mToken;
    }

    @Override
    public void setToken(Token newToken) {
        this.mToken = newToken;
    }

    @Override
    public synchronized void setTokenListener(CloudAPI.TokenListener listener) {
        this.listener = listener;
    }

    public HttpResponse execute(HttpUriRequest request) throws IOException {
        return this.safeExecute(this.env.sslResourceHost, this.addHeaders(request));
    }

    @Override
    public HttpResponse safeExecute(HttpHost target, HttpUriRequest request) throws IOException {
        if (target == null) {
            target = this.determineTarget(request);
        }
        try {
            return this.getHttpClient().execute(target, (HttpRequest)request);
        }
        catch (NullPointerException e) {
            if (!request.isAborted() && request.getParams().isParameterFalse("npe-retried")) {
                request.getParams().setBooleanParameter("npe-retried", true);
                return this.safeExecute(target, request);
            }
            request.abort();
            throw new CloudAPI.BrokenHttpClientException(e);
        }
        catch (IllegalArgumentException e) {
            request.abort();
            throw new CloudAPI.BrokenHttpClientException(e);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            request.abort();
            throw new CloudAPI.BrokenHttpClientException(e);
        }
    }

    protected HttpResponse execute(Request req, Class<? extends HttpRequestBase> reqType) throws IOException {
        Request defaults = defaultParams.get();
        if (defaults != null && !defaults.getParams().isEmpty()) {
            for (NameValuePair nvp : defaults) {
                req = new Request(req);
                req.add(nvp.getName(), nvp.getValue());
            }
        }
        this.logRequest(reqType, req);
        return this.execute((HttpUriRequest)req.buildRequest(reqType));
    }

    protected void logRequest(Class<? extends HttpRequestBase> reqType, Request request) {
        if (this.debugRequests) {
            System.err.println(reqType.getSimpleName() + " " + request);
        }
    }

    protected HttpHost determineTarget(HttpUriRequest request) {
        URI requestURI = request.getURI();
        if (requestURI.isAbsolute()) {
            return new HttpHost(requestURI.getHost(), requestURI.getPort(), requestURI.getScheme());
        }
        return null;
    }

    public void toFile(File f) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(f));
        oos.writeObject(this);
        oos.close();
    }

    public String getDefaultContentType() {
        return this.mDefaultContentType == null ? DEFAULT_CONTENT_TYPE : this.mDefaultContentType;
    }

    @Override
    public void setDefaultContentType(String contentType) {
        this.mDefaultContentType = contentType;
    }

    static Request addScope(Request request, String[] scopes) {
        if (scopes != null && scopes.length > 0) {
            StringBuilder scope = new StringBuilder();
            for (int i = 0; i < scopes.length; ++i) {
                scope.append(scopes[i]);
                if (i >= scopes.length - 1) continue;
                scope.append(" ");
            }
            request.add("scope", scope.toString());
        }
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ApiWrapper fromFile(File f) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = new ObjectInputStream(new FileInputStream(f));
        try {
            ApiWrapper apiWrapper = (ApiWrapper)ois.readObject();
            return apiWrapper;
        }
        finally {
            ois.close();
        }
    }

    public static Header createOAuthHeader(Token token) {
        return new BasicHeader("Authorization", "OAuth " + (token == null || !token.valid() ? "invalidated" : token.access));
    }

    protected HttpUriRequest addAuthHeader(HttpUriRequest request) {
        if (!request.containsHeader("Authorization")) {
            request.addHeader(ApiWrapper.createOAuthHeader(this.getToken()));
        }
        return request;
    }

    protected HttpUriRequest addAcceptHeader(HttpUriRequest request) {
        if (!request.containsHeader("Accept")) {
            request.addHeader("Accept", this.getDefaultContentType());
        }
        return request;
    }

    protected HttpUriRequest addHeaders(HttpUriRequest req) {
        return this.addAcceptHeader(this.addAuthHeader(req));
    }

    protected RequestDirector getRequestDirector(HttpRequestExecutor requestExec, ClientConnectionManager conman, ConnectionReuseStrategy reustrat, ConnectionKeepAliveStrategy kastrat, HttpRoutePlanner rouplan, HttpProcessor httpProcessor, HttpRequestRetryHandler retryHandler, RedirectHandler redirectHandler, AuthenticationHandler targetAuthHandler, AuthenticationHandler proxyAuthHandler, UserTokenHandler stateHandler, HttpParams params) {
        return new DefaultRequestDirector(requestExec, conman, reustrat, kastrat, rouplan, httpProcessor, retryHandler, redirectHandler, targetAuthHandler, proxyAuthHandler, stateHandler, params);
    }

    public static void setDefaultParameter(String name, String value) {
        defaultParams.get().set(name, value);
    }

    public static void clearDefaultParameters() {
        defaultParams.remove();
    }
}

