/*
 * Decompiled with CFR 0.152.
 */
package com.soundcloud.api;

import com.soundcloud.api.Request;
import com.soundcloud.api.Stream;
import com.soundcloud.api.Token;
import java.io.IOException;
import java.net.URI;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;

public interface CloudAPI {
    public static final String PASSWORD = "password";
    public static final String AUTHORIZATION_CODE = "authorization_code";
    public static final String REFRESH_TOKEN = "refresh_token";
    public static final String CLIENT_CREDENTIALS = "client_credentials";
    public static final String OAUTH1_TOKEN = "oauth1_token";
    public static final String FACEBOOK_GRANT_TYPE = "urn:soundcloud:oauth2:grant-type:facebook&access_token=";
    public static final String REALM = "SoundCloud";
    public static final String OAUTH_SCHEME = "oauth";
    public static final String VERSION = "1.2.0";
    public static final String USER_AGENT = "SoundCloud Java Wrapper (1.2.0)";

    public Token login(String var1, String var2, String ... var3) throws IOException;

    public Token authorizationCode(String var1, String ... var2) throws IOException;

    public Token clientCredentials(String ... var1) throws IOException;

    public Token extensionGrantType(String var1, String ... var2) throws IOException;

    public Token refreshToken() throws IOException;

    public Token exchangeOAuth1Token(String var1) throws IOException;

    public Token invalidateToken();

    public HttpResponse head(Request var1) throws IOException;

    public HttpResponse get(Request var1) throws IOException;

    public HttpResponse post(Request var1) throws IOException;

    public HttpResponse put(Request var1) throws IOException;

    public HttpResponse delete(Request var1) throws IOException;

    public HttpClient getHttpClient();

    public HttpResponse safeExecute(HttpHost var1, HttpUriRequest var2) throws IOException;

    public long resolve(String var1) throws IOException;

    public Stream resolveStreamUrl(String var1, boolean var2) throws IOException;

    public Token getToken();

    public void setToken(Token var1);

    public void setTokenListener(TokenListener var1);

    public URI authorizationCodeUrl(String ... var1);

    public void setDefaultContentType(String var1);

    public static class BrokenHttpClientException
    extends IOException {
        private static final long serialVersionUID = -4764332412926419313L;

        BrokenHttpClientException(Throwable throwable) {
            super(throwable == null ? null : throwable.toString());
            this.initCause(throwable);
        }
    }

    public static class ResolverException
    extends IOException {
        private static final long serialVersionUID = -2990651725862868387L;
        public final HttpResponse response;

        public ResolverException(String s, HttpResponse resp) {
            super(s);
            this.response = resp;
        }

        public ResolverException(Throwable throwable, HttpResponse response) {
            super(throwable == null ? null : throwable.toString());
            this.initCause(throwable);
            this.response = response;
        }

        public int getStatusCode() {
            return this.response.getStatusLine().getStatusCode();
        }

        public String getMessage() {
            return super.getMessage() + " " + (this.response != null ? this.response.getStatusLine() : "");
        }
    }

    public static class InvalidTokenException
    extends IOException {
        private static final long serialVersionUID = 1954919760451539868L;

        public InvalidTokenException(int code, String status) {
            super("HTTP error:" + code + " (" + status + ")");
        }
    }

    public static interface TokenListener {
        public Token onTokenInvalid(Token var1);

        public void onTokenRefreshed(Token var1);
    }
}

