/*
 * Decompiled with CFR 0.152.
 */
package com.soundcloud.api;

import com.soundcloud.api.CloudAPI;
import com.soundcloud.api.Request;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.apache.http.Header;
import org.apache.http.HttpResponse;

public class Stream
implements Serializable {
    public static final String AMZ_BITRATE = "x-amz-meta-bitrate";
    public static final String AMZ_DURATION = "x-amz-meta-duration";
    static final String EXPIRES = "Expires";
    public static final long DEFAULT_URL_LIFETIME = 60000L;
    public static final DateFormat DATE_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
    private static final long serialVersionUID = -2054788615389851590L;
    public final String url;
    public final String streamUrl;
    public final String eTag;
    public final long contentLength;
    public final long lastModified;
    public final int duration;
    public final int bitRate;
    public final long expires;

    public Stream(String url, String streamUrl, HttpResponse resp) throws CloudAPI.ResolverException {
        this(url, streamUrl, Stream.getHeaderValue(resp, "ETag"), Stream.getLongHeader(resp, "Content-Length"), Stream.getDateHeader(resp, "Last-Modified"), Stream.getIntHeader(resp, AMZ_DURATION), Stream.getIntHeader(resp, AMZ_BITRATE), Stream.getExpires(streamUrl));
    }

    public Stream(String url, String streamUrl, String eTag, long contentLength, long lastModified, int duration, int bitRate, long expires) {
        this.url = url;
        this.streamUrl = streamUrl;
        this.eTag = eTag;
        this.contentLength = contentLength;
        this.lastModified = lastModified;
        this.duration = duration;
        this.bitRate = bitRate;
        this.expires = expires;
    }

    public Request streamUrl() {
        return Request.to(this.streamUrl, new Object[0]);
    }

    public Request url() {
        return Request.to(this.url, new Object[0]);
    }

    public Stream withNewStreamUrl(String newStreamUrl) {
        return new Stream(this.url, newStreamUrl, this.eTag, this.contentLength, this.lastModified, this.duration, this.bitRate, Stream.getExpires(newStreamUrl));
    }

    public static long getLongHeader(HttpResponse resp, String name) throws CloudAPI.ResolverException {
        try {
            return Long.parseLong(Stream.getHeaderValue(resp, name));
        }
        catch (NumberFormatException e) {
            throw new CloudAPI.ResolverException(e, resp);
        }
    }

    public static int getIntHeader(HttpResponse resp, String name) throws CloudAPI.ResolverException {
        try {
            return Integer.parseInt(Stream.getHeaderValue(resp, name));
        }
        catch (NumberFormatException e) {
            throw new CloudAPI.ResolverException(e, resp);
        }
    }

    public static long getDateHeader(HttpResponse resp, String name) throws CloudAPI.ResolverException {
        try {
            return DATE_FORMAT.parse(Stream.getHeaderValue(resp, name)).getTime();
        }
        catch (ParseException e) {
            throw new CloudAPI.ResolverException(e, resp);
        }
    }

    private static String getHeaderValue(HttpResponse resp, String name) throws CloudAPI.ResolverException {
        Header h = resp.getFirstHeader(name);
        if (h != null && h.getValue() != null) {
            return h.getValue();
        }
        throw new CloudAPI.ResolverException("header " + name + " not set", resp);
    }

    private static long getExpires(String resource) {
        String query = resource.substring(Math.min(resource.length(), resource.indexOf("?") + 1), resource.length());
        for (String s : query.split("&")) {
            String[] kv = s.split("=", 2);
            if (kv == null || kv.length != 2) continue;
            try {
                String name = URLDecoder.decode(kv[0], "UTF-8");
                if (!EXPIRES.equalsIgnoreCase(name)) continue;
                String value = URLDecoder.decode(kv[1], "UTF-8");
                try {
                    return Long.parseLong(value) * 1000L;
                }
                catch (NumberFormatException ignored) {
                }
            }
            catch (UnsupportedEncodingException ignored) {
                // empty catch block
            }
        }
        return System.currentTimeMillis() + 60000L;
    }

    public String toString() {
        return "Stream{url='" + this.url + '\'' + ", streamUrl='" + this.streamUrl + '\'' + ", eTag='" + this.eTag + '\'' + ", contentLength=" + this.contentLength + ", lastModified=" + this.lastModified + ", duration=" + this.duration + ", bitRate=" + this.bitRate + ", expires=" + this.expires + '}';
    }
}

