/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command.export;

import com.sqlapp.data.db.command.export.AbstractExportCommand;
import com.sqlapp.data.db.command.export.TableFileReader;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.SchemaReader;
import com.sqlapp.data.db.sql.SqlFactory;
import com.sqlapp.data.db.sql.SqlFactoryRegistry;
import com.sqlapp.data.db.sql.SqlOperation;
import com.sqlapp.data.db.sql.SqlType;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.AbstractNamedObject;
import com.sqlapp.data.schemas.Catalog;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.ColumnCollection;
import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.data.schemas.Row;
import com.sqlapp.data.schemas.RowIteratorHandler;
import com.sqlapp.data.schemas.Schema;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.XmlReaderOptions;
import com.sqlapp.data.schemas.function.RowValueConverter;
import com.sqlapp.data.schemas.rowiterator.CombinedRowIteratorHandler;
import com.sqlapp.data.schemas.rowiterator.CsvRowIteratorHandler;
import com.sqlapp.data.schemas.rowiterator.ExcelRowIteratorHandler;
import com.sqlapp.data.schemas.rowiterator.JsonRowIteratorHandler;
import com.sqlapp.data.schemas.rowiterator.WorkbookFileType;
import com.sqlapp.data.schemas.rowiterator.XmlRowIteratorHandler;
import com.sqlapp.data.schemas.rowiterator.YamlRowIteratorHandler;
import com.sqlapp.exceptions.InvalidValueException;
import com.sqlapp.jdbc.sql.JdbcBatchUpdateHandler;
import com.sqlapp.jdbc.sql.JdbcHandler;
import com.sqlapp.jdbc.sql.SqlConverter;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;

public class ImportDataFromFileCommand
extends AbstractExportCommand {
    private boolean useTableNameDirectory = false;
    private long queryCommitInterval = Long.MAX_VALUE;
    private File fileDirectory = null;
    private File file = null;
    private SqlType sqlType = SqlType.MERGE_ROW;
    private Predicate<File> fileFilter = f -> true;
    private String placeholderPrefix = "${";
    private String placeholderSuffix = "}";
    private boolean placeholders = false;
    private int csvSkipHeaderRowsSize = 1;
    private RowValueConverter rowValueConverter;

    @Override
    protected void doRun() {
        Connection connection = null;
        try {
            File[] directories;
            connection = this.getConnection();
            Dialect dialect = this.getDialect();
            SchemaReader schemaReader = null;
            try {
                schemaReader = this.getSchemaReader(connection, dialect);
            }
            catch (SQLException e) {
                this.getExceptionHandler().handle((Throwable)e);
            }
            Set schemaNames = CommonUtils.lowerSet();
            if (this.isUseSchemaNameDirectory() && (directories = this.getDirectory().listFiles(c -> c.isDirectory())) != null) {
                for (File directory : directories) {
                    String name = directory.getName();
                    schemaNames.add(name);
                }
            }
            TableFileReader tableFileReader = this.createTableFileReader();
            Map<String, Schema> schemaMap = this.isUseSchemaNameDirectory() ? this.getSchemas(connection, dialect, schemaReader, s -> schemaNames.contains(s.getName())) : this.getSchemas(connection, dialect, schemaReader, s -> true);
            Catalog catalog = new Catalog();
            catalog.setDialect(dialect);
            schemaMap.forEach((k, v) -> catalog.getSchemas().add((AbstractNamedObject)v));
            List tfs = tableFileReader.getTableFilePairs(catalog);
            try {
                tableFileReader.setFiles(tfs);
            }
            catch (IOException | XMLStreamException | EncryptedDocumentException | InvalidFormatException e) {
                this.getExceptionHandler().handle(e);
            }
            if (this.getSqlType().getTableComparator() != null) {
                tfs = SchemaUtils.getNewSortedTableList(tfs, (Comparator)this.getSqlType().getTableComparator(), tf -> tf.getTable());
            }
            connection.setAutoCommit(false);
            int commitCount = 0;
            for (TableFileReader.TableFilesPair tf2 : tfs) {
                this.println("target=" + tf2);
                if (this.getTableOptions().getCommitPerTable().test((Object)tf2.getTable())) {
                    try {
                        this.executeImport(connection, dialect, tf2.getTable(), tf2.getFiles());
                        connection.commit();
                        ++commitCount;
                    }
                    catch (SQLException e) {
                        this.rollback(connection);
                        this.getExceptionHandler().handle((Throwable)e);
                    }
                    continue;
                }
                this.executeImport(connection, dialect, tf2.getTable(), tf2.getFiles());
            }
            if (commitCount == 0) {
                connection.commit();
            }
        }
        catch (RuntimeException e) {
            this.rollback(connection);
            this.getExceptionHandler().handle((Throwable)e);
        }
        catch (SQLException e) {
            this.rollback(connection);
            this.getExceptionHandler().handle((Throwable)e);
        }
    }

    private TableFileReader createTableFileReader() {
        TableFileReader tableFileReader = new TableFileReader();
        tableFileReader.setContext(this.getContext());
        tableFileReader.setCsvEncoding(this.getCsvEncoding());
        tableFileReader.setDirectory(this.getDirectory());
        tableFileReader.setFileDirectory(this.getFileDirectory());
        tableFileReader.setFileFilter(this.getFileFilter());
        tableFileReader.setJsonConverter(this.getJsonConverter());
        tableFileReader.setPlaceholderPrefix(this.getPlaceholderPrefix());
        tableFileReader.setPlaceholders(this.isPlaceholders());
        tableFileReader.setPlaceholderSuffix(this.getPlaceholderSuffix());
        tableFileReader.setUseSchemaNameDirectory(this.isUseSchemaNameDirectory());
        tableFileReader.setUseTableNameDirectory(this.isUseTableNameDirectory());
        return tableFileReader;
    }

    private void rollback(Connection connection) {
        if (connection == null) {
            return;
        }
        try {
            connection.rollback();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected void executeImport(Connection connection, Dialect dialect, Table table, List<File> files) throws SQLException {
        try {
            if (this.getSqlType().supportRows()) {
                this.applyFromFileByRow(connection, dialect, table, files);
            } else {
                this.applyFromFileByTable(connection, dialect, table, files);
            }
        }
        catch (EncryptedDocumentException e) {
            this.getExceptionHandler().handle((Throwable)e);
        }
        catch (InvalidFormatException e) {
            this.getExceptionHandler().handle((Throwable)e);
        }
        catch (XMLStreamException e) {
            this.getExceptionHandler().handle((Throwable)e);
        }
        catch (IOException e) {
            this.getExceptionHandler().handle((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyFromFileByRow(Connection connection, Dialect dialect, Table table, List<File> files) throws EncryptedDocumentException, InvalidFormatException, IOException, XMLStreamException, SQLException {
        SqlFactoryRegistry sqlFactoryRegistry = dialect.getSqlFactoryRegistry();
        sqlFactoryRegistry.getOption().setTableOptions(this.getTableOptions());
        SqlFactory factory = sqlFactoryRegistry.getSqlFactory((DbCommonObject)new Row(), this.getSqlType());
        long queryCount = 0L;
        List targets = CommonUtils.list();
        if (!CommonUtils.isEmpty(files)) {
            for (File file : files) {
                if (file.isDirectory()) {
                    for (File children : file.listFiles()) {
                        targets.add(children);
                    }
                    continue;
                }
                targets.add(file);
            }
            this.readFiles(table, targets);
        }
        SqlConverter sqlConverter = this.getSqlConverter();
        List batchRows = CommonUtils.list();
        try {
            for (Row row : table.getRows()) {
                batchRows.add(row);
                if (batchRows.size() <= (Integer)this.getTableOptions().getDmlBatchSize().apply((Object)table)) continue;
                List operations = factory.createSql((Collection)batchRows);
                ParametersContext context = new ParametersContext();
                context.putAll(this.getContext());
                context.putAll(this.convert(row, table.getColumns()));
                for (SqlOperation operation : operations) {
                    SqlNode sqlNode = sqlConverter.parseSql(context, operation.getSqlText());
                    JdbcHandler jdbcHandler = new JdbcHandler(sqlNode);
                    jdbcHandler.execute(connection, context);
                    queryCount = this.commit(connection, queryCount);
                }
                batchRows.clear();
            }
        }
        finally {
            table.setRowIteratorHandler(null);
        }
        if (batchRows.size() > 0) {
            List operations = factory.createSql((Collection)batchRows);
            ParametersContext context = new ParametersContext();
            context.putAll(this.getContext());
            for (SqlOperation operation : operations) {
                SqlNode sqlNode = sqlConverter.parseSql(context, operation.getSqlText());
                JdbcHandler jdbcHandler = new JdbcHandler(sqlNode);
                jdbcHandler.execute(connection, context);
                this.commit(connection, queryCount);
            }
            batchRows.clear();
        }
    }

    protected SqlConverter getSqlConverter() {
        SqlConverter sqlConverter = new SqlConverter();
        sqlConverter.getExpressionConverter().setFileDirectory(this.getFileDirectory());
        sqlConverter.getExpressionConverter().setPlaceholderPrefix(this.getPlaceholderPrefix());
        sqlConverter.getExpressionConverter().setPlaceholderSuffix(this.getPlaceholderSuffix());
        sqlConverter.getExpressionConverter().setPlaceholders(this.isPlaceholders());
        return sqlConverter;
    }

    private long commit(Connection connection, long queryCount) throws SQLException {
        if (queryCount >= this.getQueryCommitInterval()) {
            connection.commit();
            return 0L;
        }
        return queryCount + 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyFromFileByTable(Connection connection, Dialect dialect, Table table, List<File> files) throws EncryptedDocumentException, InvalidFormatException, IOException, XMLStreamException, SQLException {
        SqlFactoryRegistry sqlFactoryRegistry = dialect.getSqlFactoryRegistry();
        SqlFactory factory = sqlFactoryRegistry.getSqlFactory((DbCommonObject)table, this.getSqlType());
        List operations = factory.createSql((DbCommonObject)table);
        SqlConverter sqlConverter = this.getSqlConverter();
        List handlers = operations.stream().map(c -> {
            ParametersContext context = new ParametersContext();
            context.putAll(this.getContext());
            SqlNode sqlNode = sqlConverter.parseSql(context, c.getSqlText());
            JdbcBatchUpdateHandler jdbcHandler = new JdbcBatchUpdateHandler(sqlNode);
            return jdbcHandler;
        }).collect(Collectors.toList());
        long queryCount = 0L;
        List targets = CommonUtils.list();
        if (!CommonUtils.isEmpty(files)) {
            for (File file : files) {
                if (file.isDirectory()) {
                    for (File children : file.listFiles()) {
                        targets.add(children);
                    }
                    continue;
                }
                targets.add(file);
            }
            this.readFiles(table, targets);
        }
        List batchRows = CommonUtils.list();
        try {
            for (Row row : table.getRows()) {
                ParametersContext context = new ParametersContext();
                context.putAll(this.getContext());
                context.putAll(this.convert(row, table.getColumns()));
                batchRows.add(context);
                if (batchRows.size() <= (Integer)this.getTableOptions().getDmlBatchSize().apply((Object)table)) continue;
                for (JdbcBatchUpdateHandler jdbcHandler : handlers) {
                    jdbcHandler.execute(connection, (Object)batchRows);
                    queryCount = this.commit(connection, queryCount);
                }
                batchRows.clear();
            }
        }
        finally {
            table.setRowIteratorHandler(null);
        }
        if (batchRows.size() > 0) {
            for (JdbcBatchUpdateHandler jdbcHandler : handlers) {
                jdbcHandler.execute(connection, (Object)batchRows);
                this.commit(connection, queryCount);
            }
            batchRows.clear();
        }
    }

    private Map<String, Object> convert(Row row, ColumnCollection columns) {
        Map map = row.toMap();
        Map ret = CommonUtils.map((int)map.size());
        SqlConverter sqlConverter = this.getSqlConverter();
        ParametersContext context = new ParametersContext();
        context.putAll(this.getContext());
        for (Column column : columns) {
            Object val;
            Object originalValue = row.get(column);
            try {
                val = sqlConverter.getExpressionConverter().convert(originalValue, (Object)context);
            }
            catch (IOException e) {
                throw new InvalidValueException(row.getDataSourceInfo(), row.getDataSourceDetailInfo(), column.getName(), originalValue, (Throwable)e);
            }
            ret.put(column.getName(), val);
        }
        return ret;
    }

    private RowValueConverter createRowValueConverter() {
        SqlConverter sqlConverter = this.getSqlConverter();
        ParametersContext context = new ParametersContext();
        context.putAll(this.getContext());
        return (RowValueConverter & Serializable)(r, c, v) -> {
            Object val;
            Object originalVal = this.createRowValueConverter() != null ? this.createRowValueConverter().apply(r, c, v) : v;
            try {
                val = sqlConverter.getExpressionConverter().convert(originalVal, (Object)context);
            }
            catch (IOException e) {
                throw new InvalidValueException(r, c, v, (Throwable)e);
            }
            return val;
        };
    }

    private void readFiles(Table table, List<File> files) throws EncryptedDocumentException, InvalidFormatException, IOException, XMLStreamException {
        List handlers = files.stream().map(file -> {
            WorkbookFileType workbookFileType = WorkbookFileType.parse((File)file);
            if (workbookFileType.isTextFile()) {
                if (workbookFileType.isCsv()) {
                    return new CsvRowIteratorHandler(file, this.getCsvEncoding(), this.createRowValueConverter());
                }
                if (workbookFileType.isXml()) {
                    return new XmlRowIteratorHandler(file, this.createRowValueConverter());
                }
                if (workbookFileType.isYaml()) {
                    return new YamlRowIteratorHandler(file, this.getYamlConverter(), this.createRowValueConverter());
                }
                return new JsonRowIteratorHandler(file, this.getJsonConverter(), this.createRowValueConverter());
            }
            return new ExcelRowIteratorHandler(file, this.createRowValueConverter());
        }).collect(Collectors.toList());
        table.setRowIteratorHandler((RowIteratorHandler)new CombinedRowIteratorHandler(handlers));
    }

    protected void readFileAsXml(Table table, File file, WorkbookFileType workbookFileType) throws XMLStreamException, FileNotFoundException {
        XmlReaderOptions options = new XmlReaderOptions();
        options.setRowValueConverter(this.createRowValueConverter());
        table.loadXml(file, options);
    }

    public boolean isUseTableNameDirectory() {
        return this.useTableNameDirectory;
    }

    public void setUseTableNameDirectory(boolean useTableNameDirectory) {
        this.useTableNameDirectory = useTableNameDirectory;
    }

    public long getQueryCommitInterval() {
        return this.queryCommitInterval;
    }

    public void setQueryCommitInterval(long queryCommitInterval) {
        this.queryCommitInterval = queryCommitInterval;
    }

    public File getFileDirectory() {
        return this.fileDirectory;
    }

    public void setFileDirectory(File fileDirectory) {
        this.fileDirectory = fileDirectory;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public SqlType getSqlType() {
        return this.sqlType;
    }

    public void setSqlType(SqlType sqlType) {
        this.sqlType = sqlType;
    }

    public Predicate<File> getFileFilter() {
        return this.fileFilter;
    }

    public void setFileFilter(Predicate<File> fileFilter) {
        this.fileFilter = fileFilter;
    }

    public String getPlaceholderPrefix() {
        return this.placeholderPrefix;
    }

    public void setPlaceholderPrefix(String placeholderPrefix) {
        this.placeholderPrefix = placeholderPrefix;
    }

    public String getPlaceholderSuffix() {
        return this.placeholderSuffix;
    }

    public void setPlaceholderSuffix(String placeholderSuffix) {
        this.placeholderSuffix = placeholderSuffix;
    }

    public boolean isPlaceholders() {
        return this.placeholders;
    }

    public void setPlaceholders(boolean placeholders) {
        this.placeholders = placeholders;
    }

    public int getCsvSkipHeaderRowsSize() {
        return this.csvSkipHeaderRowsSize;
    }

    public void setCsvSkipHeaderRowsSize(int csvSkipHeaderRowsSize) {
        this.csvSkipHeaderRowsSize = csvSkipHeaderRowsSize;
    }

    public void setRowValueConverter(RowValueConverter rowValueConverter) {
        this.rowValueConverter = rowValueConverter;
    }

    public RowValueConverter getRowValueConverter() {
        return this.rowValueConverter;
    }
}

