/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api.common.log;

import com.stackify.api.AppIdentity;
import com.stackify.api.EnvironmentDetail;
import com.stackify.api.LogMsg;
import com.stackify.api.LogMsgGroup;
import com.stackify.api.common.AppIdentityService;
import com.stackify.api.common.collect.SynchronizedEvictingQueue;
import com.stackify.api.common.http.HttpException;
import com.stackify.api.common.log.LogSender;
import com.stackify.api.common.util.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;

public class LogCollector {
    private static final int MAX_BATCH = 100;
    private final String logger;
    private final EnvironmentDetail envDetail;
    private final AppIdentityService appIdentityService;
    private final Queue<LogMsg> queue = new SynchronizedEvictingQueue<LogMsg>(10000);

    public LogCollector(String logger, EnvironmentDetail envDetail, AppIdentityService appIdentityService) {
        Preconditions.checkNotNull(logger);
        Preconditions.checkNotNull(envDetail);
        Preconditions.checkNotNull(appIdentityService);
        this.logger = logger;
        this.envDetail = envDetail;
        this.appIdentityService = appIdentityService;
    }

    public void addLogMsg(LogMsg logMsg) {
        Preconditions.checkNotNull(logMsg);
        this.queue.offer(logMsg);
    }

    public int flush(LogSender sender) throws IOException, HttpException {
        int numSent;
        int maxToSend = this.queue.size();
        if (0 < maxToSend) {
            int batchSize;
            AppIdentity appIdentity = this.appIdentityService.getAppIdentity();
            for (numSent = 0; numSent < maxToSend; numSent += batchSize) {
                batchSize = Math.min(maxToSend - numSent, 100);
                ArrayList<LogMsg> batch = new ArrayList<LogMsg>(batchSize);
                for (int i = 0; i < batchSize; ++i) {
                    batch.add(this.queue.remove());
                }
                LogMsgGroup group = this.createLogMessageGroup(batch, this.logger, this.envDetail, appIdentity);
                int httpStatus = sender.send(group);
                if (httpStatus == 200) continue;
                throw new HttpException(httpStatus);
            }
        }
        return numSent;
    }

    private LogMsgGroup createLogMessageGroup(List<LogMsg> batch, String logger, EnvironmentDetail envDetail, AppIdentity appIdentity) {
        LogMsgGroup.Builder groupBuilder = LogMsgGroup.newBuilder();
        groupBuilder.platform("java").logger(logger).serverName(envDetail.getDeviceName()).env(envDetail.getConfiguredEnvironmentName()).appName(envDetail.getConfiguredAppName()).appLoc(envDetail.getAppLocation());
        if (appIdentity != null) {
            groupBuilder.cdId(appIdentity.getDeviceId()).cdAppId(appIdentity.getDeviceAppId()).appNameId(appIdentity.getAppNameId()).appEnvId(appIdentity.getAppEnvId()).envId(appIdentity.getEnvId()).env(appIdentity.getEnv());
            if (appIdentity.getAppName() != null && 0 < appIdentity.getAppName().length()) {
                groupBuilder.appName(appIdentity.getAppName());
            }
        }
        groupBuilder.msgs(batch);
        return groupBuilder.build();
    }
}

