/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api.common.http;

import java.net.InetSocketAddress;
import java.net.Proxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpProxy {
    private static final Logger log = LoggerFactory.getLogger(HttpProxy.class);

    public static Proxy fromSystemProperties() {
        return HttpProxy.build(System.getProperty("https.proxyHost"), System.getProperty("https.proxyPort"));
    }

    public static Proxy build(String httpProxyHost, String httpProxyPort) {
        try {
            if (httpProxyHost != null && !httpProxyHost.isEmpty() && httpProxyPort != null && !httpProxyPort.isEmpty()) {
                return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(httpProxyHost, Integer.parseInt(httpProxyPort)));
            }
        }
        catch (Throwable t) {
            log.info("Unable to read HTTP proxy information from system properties", t);
        }
        return Proxy.NO_PROXY;
    }

    private HttpProxy() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

