/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyUtil {
    private static final Logger log = LoggerFactory.getLogger(PropertyUtil.class);

    public static Map<String, String> readAndMerge(String ... paths) {
        if (paths == null) {
            throw new NullPointerException("paths");
        }
        HashMap<String, String> mergedMap = new HashMap<String, String>();
        for (String path : paths) {
            Map<String, String> map = PropertyUtil.read(path);
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (mergedMap.containsKey(entry.getKey())) continue;
                mergedMap.put(entry.getKey(), entry.getValue());
            }
        }
        return mergedMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(String path) {
        block23: {
            if (path != null) {
                try {
                    File file = new File(path);
                    if (file.exists()) {
                        try {
                            Properties p = new Properties();
                            p.load(new FileInputStream(file));
                            return p;
                        }
                        catch (Exception e) {
                            log.error("Error loading properties from file: " + path);
                        }
                    }
                }
                catch (Throwable e) {
                    log.debug(e.getMessage(), e);
                }
                InputStream inputStream = null;
                try {
                    inputStream = PropertyUtil.class.getResourceAsStream(path);
                    if (inputStream == null) break block23;
                    try {
                        Properties p = new Properties();
                        p.load(inputStream);
                        Properties properties = p;
                        return properties;
                    }
                    catch (Exception e) {
                        try {
                            log.error("Error loading properties from resource: " + path);
                        }
                        catch (Exception e2) {
                            log.error("Error loading properties from resource: " + path);
                        }
                    }
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable t) {
                            log.debug("Error closing: " + path, t);
                        }
                    }
                }
            }
        }
        return new Properties();
    }

    public static Map<String, String> read(String path) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (path != null) {
            try {
                Properties p = PropertyUtil.loadProperties(path);
                for (Object key : p.keySet()) {
                    String value = p.getProperty(String.valueOf(key));
                    if (value.startsWith("\"") && value.endsWith("\"") || value.startsWith("'") && value.endsWith("'")) {
                        value = value.substring(1, value.length() - 1);
                    }
                    if ((value = value.trim()).equals("")) continue;
                    map.put(String.valueOf(key), value);
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return map;
    }
}

