/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api;

import com.stackify.api.TraceFrame;
import java.util.List;
import java.util.Map;

public class ErrorItem {
    private final String message;
    private final String errorType;
    private final String errorTypeCode;
    private final Map<String, String> data;
    private final String sourceMethod;
    private final List<TraceFrame> stackTrace;
    private final ErrorItem innerError;

    public String getMessage() {
        return this.message;
    }

    public String getErrorType() {
        return this.errorType;
    }

    public String getErrorTypeCode() {
        return this.errorTypeCode;
    }

    public Map<String, String> getData() {
        return this.data;
    }

    public String getSourceMethod() {
        return this.sourceMethod;
    }

    public List<TraceFrame> getStackTrace() {
        return this.stackTrace;
    }

    public ErrorItem getInnerError() {
        return this.innerError;
    }

    private ErrorItem(Builder builder) {
        this.message = builder.message;
        this.errorType = builder.errorType;
        this.errorTypeCode = builder.errorTypeCode;
        this.data = builder.data;
        this.sourceMethod = builder.sourceMethod;
        this.stackTrace = builder.stackTrace;
        this.innerError = builder.innerError;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String message;
        private String errorType;
        private String errorTypeCode;
        private Map<String, String> data;
        private String sourceMethod;
        private List<TraceFrame> stackTrace;
        private ErrorItem innerError;

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder errorType(String errorType) {
            this.errorType = errorType;
            return this;
        }

        public Builder errorTypeCode(String errorTypeCode) {
            this.errorTypeCode = errorTypeCode;
            return this;
        }

        public Builder data(Map<String, String> data) {
            this.data = data;
            return this;
        }

        public Builder sourceMethod(String sourceMethod) {
            this.sourceMethod = sourceMethod;
            return this;
        }

        public Builder stackTrace(List<TraceFrame> stackTrace) {
            this.stackTrace = stackTrace;
            return this;
        }

        public Builder innerError(ErrorItem innerError) {
            this.innerError = innerError;
            return this;
        }

        public ErrorItem build() {
            return new ErrorItem(this);
        }
    }
}

