/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */


package com.stackone.stackone_client_java.models.components;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Map;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class RawResponse {

    @JsonProperty("method")
    private String method;

    @JsonProperty("url")
    private String url;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("body")
    private JsonNullable<String> body;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("response")
    private JsonNullable<? extends Map<String, Object>> response;

    @JsonCreator
    public RawResponse(
            @JsonProperty("method") String method,
            @JsonProperty("url") String url,
            @JsonProperty("body") JsonNullable<String> body,
            @JsonProperty("response") JsonNullable<? extends Map<String, Object>> response) {
        Utils.checkNotNull(method, "method");
        Utils.checkNotNull(url, "url");
        Utils.checkNotNull(body, "body");
        Utils.checkNotNull(response, "response");
        this.method = method;
        this.url = url;
        this.body = body;
        this.response = response;
    }
    
    public RawResponse(
            String method,
            String url) {
        this(method, url, JsonNullable.undefined(), JsonNullable.undefined());
    }

    @JsonIgnore
    public String method() {
        return method;
    }

    @JsonIgnore
    public String url() {
        return url;
    }

    @JsonIgnore
    public JsonNullable<String> body() {
        return body;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Map<String, Object>> response() {
        return (JsonNullable<Map<String, Object>>) response;
    }

    public final static Builder builder() {
        return new Builder();
    }

    public RawResponse withMethod(String method) {
        Utils.checkNotNull(method, "method");
        this.method = method;
        return this;
    }

    public RawResponse withUrl(String url) {
        Utils.checkNotNull(url, "url");
        this.url = url;
        return this;
    }

    public RawResponse withBody(String body) {
        Utils.checkNotNull(body, "body");
        this.body = JsonNullable.of(body);
        return this;
    }

    public RawResponse withBody(JsonNullable<String> body) {
        Utils.checkNotNull(body, "body");
        this.body = body;
        return this;
    }

    public RawResponse withResponse(Map<String, Object> response) {
        Utils.checkNotNull(response, "response");
        this.response = JsonNullable.of(response);
        return this;
    }

    public RawResponse withResponse(JsonNullable<? extends Map<String, Object>> response) {
        Utils.checkNotNull(response, "response");
        this.response = response;
        return this;
    }
    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RawResponse other = (RawResponse) o;
        return 
            Objects.deepEquals(this.method, other.method) &&
            Objects.deepEquals(this.url, other.url) &&
            Objects.deepEquals(this.body, other.body) &&
            Objects.deepEquals(this.response, other.response);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            method,
            url,
            body,
            response);
    }
    
    @Override
    public String toString() {
        return Utils.toString(RawResponse.class,
                "method", method,
                "url", url,
                "body", body,
                "response", response);
    }
    
    public final static class Builder {
 
        private String method;
 
        private String url;
 
        private JsonNullable<String> body = JsonNullable.undefined();
 
        private JsonNullable<? extends Map<String, Object>> response = JsonNullable.undefined();  
        
        private Builder() {
          // force use of static builder() method
        }

        public Builder method(String method) {
            Utils.checkNotNull(method, "method");
            this.method = method;
            return this;
        }

        public Builder url(String url) {
            Utils.checkNotNull(url, "url");
            this.url = url;
            return this;
        }

        public Builder body(String body) {
            Utils.checkNotNull(body, "body");
            this.body = JsonNullable.of(body);
            return this;
        }

        public Builder body(JsonNullable<String> body) {
            Utils.checkNotNull(body, "body");
            this.body = body;
            return this;
        }

        public Builder response(Map<String, Object> response) {
            Utils.checkNotNull(response, "response");
            this.response = JsonNullable.of(response);
            return this;
        }

        public Builder response(JsonNullable<? extends Map<String, Object>> response) {
            Utils.checkNotNull(response, "response");
            this.response = response;
            return this;
        }
        
        public RawResponse build() {
            return new RawResponse(
                method,
                url,
                body,
                response);
        }
    }
}

