/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */


package com.stackone.stackone_client_java.models.components;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;
/**
 * WorkEligibilityCategory - The category of the file
 */

public class WorkEligibilityCategory {

    /**
     * The category of the file
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("value")
    private JsonNullable<String> value;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("source_value")
    private JsonNullable<? extends WorkEligibilityDocumentSourceValue> sourceValue;

    @JsonCreator
    public WorkEligibilityCategory(
            @JsonProperty("value") JsonNullable<String> value,
            @JsonProperty("source_value") JsonNullable<? extends WorkEligibilityDocumentSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }
    
    public WorkEligibilityCategory() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The category of the file
     */
    @JsonIgnore
    public JsonNullable<String> value() {
        return value;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<WorkEligibilityDocumentSourceValue> sourceValue() {
        return (JsonNullable<WorkEligibilityDocumentSourceValue>) sourceValue;
    }

    public final static Builder builder() {
        return new Builder();
    }

    /**
     * The category of the file
     */
    public WorkEligibilityCategory withValue(String value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of(value);
        return this;
    }

    /**
     * The category of the file
     */
    public WorkEligibilityCategory withValue(JsonNullable<String> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    public WorkEligibilityCategory withSourceValue(WorkEligibilityDocumentSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of(sourceValue);
        return this;
    }

    public WorkEligibilityCategory withSourceValue(JsonNullable<? extends WorkEligibilityDocumentSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }
    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        WorkEligibilityCategory other = (WorkEligibilityCategory) o;
        return 
            Objects.deepEquals(this.value, other.value) &&
            Objects.deepEquals(this.sourceValue, other.sourceValue);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            value,
            sourceValue);
    }
    
    @Override
    public String toString() {
        return Utils.toString(WorkEligibilityCategory.class,
                "value", value,
                "sourceValue", sourceValue);
    }
    
    public final static class Builder {
 
        private JsonNullable<String> value = JsonNullable.undefined();
 
        private JsonNullable<? extends WorkEligibilityDocumentSourceValue> sourceValue = JsonNullable.undefined();  
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The category of the file
         */
        public Builder value(String value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of(value);
            return this;
        }

        /**
         * The category of the file
         */
        public Builder value(JsonNullable<String> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        public Builder sourceValue(WorkEligibilityDocumentSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of(sourceValue);
            return this;
        }

        public Builder sourceValue(JsonNullable<? extends WorkEligibilityDocumentSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }
        
        public WorkEligibilityCategory build() {
            return new WorkEligibilityCategory(
                value,
                sourceValue);
        }
    }
}

