/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class CompletionValue {
    public static final CompletionValue PASS = new CompletionValue("Pass");
    public static final CompletionValue FAIL = new CompletionValue("Fail");
    private static final Map<String, CompletionValue> values = CompletionValue.createValuesMap();
    private static final Map<String, CompletionValueEnum> enums = CompletionValue.createEnumsMap();
    private final String value;

    private CompletionValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CompletionValue of(String value) {
        Class<CompletionValue> clazz = CompletionValue.class;
        synchronized (CompletionValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new CompletionValue((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<CompletionValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompletionValue other = (CompletionValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "CompletionValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CompletionValue[] values() {
        Class<CompletionValue> clazz = CompletionValue.class;
        synchronized (CompletionValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new CompletionValue[0]);
        }
    }

    private static final Map<String, CompletionValue> createValuesMap() {
        LinkedHashMap<String, CompletionValue> map = new LinkedHashMap<String, CompletionValue>();
        map.put("Pass", PASS);
        map.put("Fail", FAIL);
        return map;
    }

    private static final Map<String, CompletionValueEnum> createEnumsMap() {
        HashMap<String, CompletionValueEnum> map = new HashMap<String, CompletionValueEnum>();
        map.put("Pass", CompletionValueEnum.PASS);
        map.put("Fail", CompletionValueEnum.FAIL);
        return map;
    }

    public static enum CompletionValueEnum {
        PASS("Pass"),
        FAIL("Fail");

        private final String value;

        private CompletionValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<CompletionValue> {
        protected _Deserializer() {
            super(CompletionValue.class);
        }

        public CompletionValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return CompletionValue.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<CompletionValue> {
        protected _Serializer() {
            super(CompletionValue.class);
        }

        public void serialize(CompletionValue value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

