/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.models.components.NoteSourceValue;
import com.stackone.stackone_client_java.models.components.NoteValue;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class Visibility {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="value")
    private JsonNullable<? extends NoteValue> value;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="source_value")
    private JsonNullable<? extends NoteSourceValue> sourceValue;

    @JsonCreator
    public Visibility(@JsonProperty(value="value") JsonNullable<? extends NoteValue> value, @JsonProperty(value="source_value") JsonNullable<? extends NoteSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }

    public Visibility() {
        this((JsonNullable<? extends NoteValue>)JsonNullable.undefined(), (JsonNullable<? extends NoteSourceValue>)JsonNullable.undefined());
    }

    @JsonIgnore
    public JsonNullable<NoteValue> value() {
        return this.value;
    }

    @JsonIgnore
    public JsonNullable<NoteSourceValue> sourceValue() {
        return this.sourceValue;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public Visibility withValue(NoteValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of((Object)value);
        return this;
    }

    public Visibility withValue(JsonNullable<? extends NoteValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    public Visibility withSourceValue(NoteSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of((Object)sourceValue);
        return this;
    }

    public Visibility withSourceValue(JsonNullable<? extends NoteSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Visibility other = (Visibility)o;
        return Objects.deepEquals(this.value, other.value) && Objects.deepEquals(this.sourceValue, other.sourceValue);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.sourceValue);
    }

    public String toString() {
        return Utils.toString(Visibility.class, "value", this.value, "sourceValue", this.sourceValue);
    }

    public static final class Builder {
        private JsonNullable<? extends NoteValue> value = JsonNullable.undefined();
        private JsonNullable<? extends NoteSourceValue> sourceValue = JsonNullable.undefined();

        private Builder() {
        }

        public Builder value(NoteValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of((Object)value);
            return this;
        }

        public Builder value(JsonNullable<? extends NoteValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        public Builder sourceValue(NoteSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of((Object)sourceValue);
            return this;
        }

        public Builder sourceValue(JsonNullable<? extends NoteSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }

        public Visibility build() {
            return new Visibility(this.value, this.sourceValue);
        }
    }
}

