/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.models.components.EntitySkillsSourceValue;
import com.stackone.stackone_client_java.models.components.EntitySkillsValue;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class Language {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="value")
    private JsonNullable<? extends EntitySkillsValue> value;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="source_value")
    private JsonNullable<? extends EntitySkillsSourceValue> sourceValue;

    @JsonCreator
    public Language(@JsonProperty(value="value") JsonNullable<? extends EntitySkillsValue> value, @JsonProperty(value="source_value") JsonNullable<? extends EntitySkillsSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }

    public Language() {
        this((JsonNullable<? extends EntitySkillsValue>)JsonNullable.undefined(), (JsonNullable<? extends EntitySkillsSourceValue>)JsonNullable.undefined());
    }

    @JsonIgnore
    public JsonNullable<EntitySkillsValue> value() {
        return this.value;
    }

    @JsonIgnore
    public JsonNullable<EntitySkillsSourceValue> sourceValue() {
        return this.sourceValue;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public Language withValue(EntitySkillsValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of((Object)value);
        return this;
    }

    public Language withValue(JsonNullable<? extends EntitySkillsValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    public Language withSourceValue(EntitySkillsSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of((Object)sourceValue);
        return this;
    }

    public Language withSourceValue(JsonNullable<? extends EntitySkillsSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Language other = (Language)o;
        return Objects.deepEquals(this.value, other.value) && Objects.deepEquals(this.sourceValue, other.sourceValue);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.sourceValue);
    }

    public String toString() {
        return Utils.toString(Language.class, "value", this.value, "sourceValue", this.sourceValue);
    }

    public static final class Builder {
        private JsonNullable<? extends EntitySkillsValue> value = JsonNullable.undefined();
        private JsonNullable<? extends EntitySkillsSourceValue> sourceValue = JsonNullable.undefined();

        private Builder() {
        }

        public Builder value(EntitySkillsValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of((Object)value);
            return this;
        }

        public Builder value(JsonNullable<? extends EntitySkillsValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        public Builder sourceValue(EntitySkillsSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of((Object)sourceValue);
            return this;
        }

        public Builder sourceValue(JsonNullable<? extends EntitySkillsSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }

        public Language build() {
            return new Language(this.value, this.sourceValue);
        }
    }
}

