/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */


package com.stackone.stackone_client_java.models.components;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;


/**
 * <p>Wrapper class for an "open" enum. "Open" enums are those that are expected
 * to evolve (particularly with the addition of enum members over time). If an
 * open enum is used then the appearance of unexpected enum values (say in a 
 * response from an updated an API) will not bring about a runtime error thus 
 * ensuring that non-updated client versions can continue to work without error.
 *
 * <p>Note that instances are immutable and are singletons (an internal thread-safe
 * cache is maintained to ensure that). As a consequence instances created with the 
 * same value will satisfy reference equality (via {@code ==}).
 * 
 * <p>This class is intended to emulate an enum (in terms of common usage and with 
 * reference equality) but with the ability to carry unknown values. Unfortunately
 * Java does not permit the use of an instance in a switch expression but you can 
 * use the {@code asEnum()} method (after dealing with the `Optional` appropriately).
 *
 */
/**
 * TimeOffPoliciesValue - The unified value for the type of the time off policy. If the provider does not specify this unit, the value will be set to unmapped_value
 */
@JsonDeserialize(using = TimeOffPoliciesValue._Deserializer.class)
@JsonSerialize(using = TimeOffPoliciesValue._Serializer.class)
public class TimeOffPoliciesValue {

    public static final TimeOffPoliciesValue PAID = new TimeOffPoliciesValue("paid");
    public static final TimeOffPoliciesValue UNPAID = new TimeOffPoliciesValue("unpaid");
    public static final TimeOffPoliciesValue HOLIDAY = new TimeOffPoliciesValue("holiday");
    public static final TimeOffPoliciesValue VACATION = new TimeOffPoliciesValue("vacation");
    public static final TimeOffPoliciesValue SICK = new TimeOffPoliciesValue("sick");
    public static final TimeOffPoliciesValue PERSONAL = new TimeOffPoliciesValue("personal");
    public static final TimeOffPoliciesValue IN_LIEU = new TimeOffPoliciesValue("in_lieu");
    public static final TimeOffPoliciesValue BEREAVEMENT = new TimeOffPoliciesValue("bereavement");
    public static final TimeOffPoliciesValue JURY_DUTY = new TimeOffPoliciesValue("jury_duty");
    public static final TimeOffPoliciesValue UNMAPPED_VALUE = new TimeOffPoliciesValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, TimeOffPoliciesValue> values = createValuesMap();
    private static final Map<String, TimeOffPoliciesValueEnum> enums = createEnumsMap();

    private final String value;

    private TimeOffPoliciesValue(String value) {
        this.value = value;
    }

    /**
     * Returns a TimeOffPoliciesValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as TimeOffPoliciesValue
     */ 
    public static TimeOffPoliciesValue of(String value) {
        synchronized (TimeOffPoliciesValue.class) {
            return values.computeIfAbsent(value, v -> new TimeOffPoliciesValue(v));
        }
    }

    public String value() {
        return value;
    }

    public Optional<TimeOffPoliciesValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        TimeOffPoliciesValue other = (TimeOffPoliciesValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "TimeOffPoliciesValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static TimeOffPoliciesValue[] values() {
        synchronized (TimeOffPoliciesValue.class) {
            return values.values().toArray(new TimeOffPoliciesValue[] {});
        }
    }

    private static final Map<String, TimeOffPoliciesValue> createValuesMap() {
        Map<String, TimeOffPoliciesValue> map = new LinkedHashMap<>();
        map.put("paid", PAID);
        map.put("unpaid", UNPAID);
        map.put("holiday", HOLIDAY);
        map.put("vacation", VACATION);
        map.put("sick", SICK);
        map.put("personal", PERSONAL);
        map.put("in_lieu", IN_LIEU);
        map.put("bereavement", BEREAVEMENT);
        map.put("jury_duty", JURY_DUTY);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, TimeOffPoliciesValueEnum> createEnumsMap() {
        Map<String, TimeOffPoliciesValueEnum> map = new HashMap<>();
        map.put("paid", TimeOffPoliciesValueEnum.PAID);
        map.put("unpaid", TimeOffPoliciesValueEnum.UNPAID);
        map.put("holiday", TimeOffPoliciesValueEnum.HOLIDAY);
        map.put("vacation", TimeOffPoliciesValueEnum.VACATION);
        map.put("sick", TimeOffPoliciesValueEnum.SICK);
        map.put("personal", TimeOffPoliciesValueEnum.PERSONAL);
        map.put("in_lieu", TimeOffPoliciesValueEnum.IN_LIEU);
        map.put("bereavement", TimeOffPoliciesValueEnum.BEREAVEMENT);
        map.put("jury_duty", TimeOffPoliciesValueEnum.JURY_DUTY);
        map.put("unmapped_value", TimeOffPoliciesValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    @SuppressWarnings("serial")
    public static final class _Serializer extends StdSerializer<TimeOffPoliciesValue> {

        protected _Serializer() {
            super(TimeOffPoliciesValue.class);
        }

        @Override
        public void serialize(TimeOffPoliciesValue value, JsonGenerator g, SerializerProvider provider)
                throws IOException, JsonProcessingException {
            g.writeObject(value.value);
        }
    }

    @SuppressWarnings("serial")
    public static final class _Deserializer extends StdDeserializer<TimeOffPoliciesValue> {

        protected _Deserializer() {
            super(TimeOffPoliciesValue.class);
        }

        @Override
        public TimeOffPoliciesValue deserialize(JsonParser p, DeserializationContext ctxt)
                throws IOException, JacksonException {
            String v = p.readValueAs(new TypeReference<String>() {});
            // use the factory method to ensure we get singletons
            return TimeOffPoliciesValue.of(v);
        }
    }
    
    public enum TimeOffPoliciesValueEnum {

        PAID("paid"),
        UNPAID("unpaid"),
        HOLIDAY("holiday"),
        VACATION("vacation"),
        SICK("sick"),
        PERSONAL("personal"),
        IN_LIEU("in_lieu"),
        BEREAVEMENT("bereavement"),
        JURY_DUTY("jury_duty"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private TimeOffPoliciesValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}
