/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class AssessmentResultValue {
    public static final AssessmentResultValue CANCELLED = new AssessmentResultValue("cancelled");
    public static final AssessmentResultValue COMPLETED = new AssessmentResultValue("completed");
    public static final AssessmentResultValue EXPIRED = new AssessmentResultValue("expired");
    public static final AssessmentResultValue FAILED = new AssessmentResultValue("failed");
    public static final AssessmentResultValue PASSED = new AssessmentResultValue("passed");
    private static final Map<String, AssessmentResultValue> values = AssessmentResultValue.createValuesMap();
    private static final Map<String, AssessmentResultValueEnum> enums = AssessmentResultValue.createEnumsMap();
    private final String value;

    private AssessmentResultValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AssessmentResultValue of(String value) {
        Class<AssessmentResultValue> clazz = AssessmentResultValue.class;
        synchronized (AssessmentResultValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new AssessmentResultValue((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<AssessmentResultValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AssessmentResultValue other = (AssessmentResultValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "AssessmentResultValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AssessmentResultValue[] values() {
        Class<AssessmentResultValue> clazz = AssessmentResultValue.class;
        synchronized (AssessmentResultValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new AssessmentResultValue[0]);
        }
    }

    private static final Map<String, AssessmentResultValue> createValuesMap() {
        LinkedHashMap<String, AssessmentResultValue> map = new LinkedHashMap<String, AssessmentResultValue>();
        map.put("cancelled", CANCELLED);
        map.put("completed", COMPLETED);
        map.put("expired", EXPIRED);
        map.put("failed", FAILED);
        map.put("passed", PASSED);
        return map;
    }

    private static final Map<String, AssessmentResultValueEnum> createEnumsMap() {
        HashMap<String, AssessmentResultValueEnum> map = new HashMap<String, AssessmentResultValueEnum>();
        map.put("cancelled", AssessmentResultValueEnum.CANCELLED);
        map.put("completed", AssessmentResultValueEnum.COMPLETED);
        map.put("expired", AssessmentResultValueEnum.EXPIRED);
        map.put("failed", AssessmentResultValueEnum.FAILED);
        map.put("passed", AssessmentResultValueEnum.PASSED);
        return map;
    }

    public static enum AssessmentResultValueEnum {
        CANCELLED("cancelled"),
        COMPLETED("completed"),
        EXPIRED("expired"),
        FAILED("failed"),
        PASSED("passed");

        private final String value;

        private AssessmentResultValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<AssessmentResultValue> {
        protected _Deserializer() {
            super(AssessmentResultValue.class);
        }

        public AssessmentResultValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return AssessmentResultValue.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<AssessmentResultValue> {
        protected _Serializer() {
            super(AssessmentResultValue.class);
        }

        public void serialize(AssessmentResultValue value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

