/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class TimeOffBalancesPolicyTypeValue {
    public static final TimeOffBalancesPolicyTypeValue PAID = new TimeOffBalancesPolicyTypeValue("paid");
    public static final TimeOffBalancesPolicyTypeValue UNPAID = new TimeOffBalancesPolicyTypeValue("unpaid");
    public static final TimeOffBalancesPolicyTypeValue HOLIDAY = new TimeOffBalancesPolicyTypeValue("holiday");
    public static final TimeOffBalancesPolicyTypeValue VACATION = new TimeOffBalancesPolicyTypeValue("vacation");
    public static final TimeOffBalancesPolicyTypeValue SICK = new TimeOffBalancesPolicyTypeValue("sick");
    public static final TimeOffBalancesPolicyTypeValue PERSONAL = new TimeOffBalancesPolicyTypeValue("personal");
    public static final TimeOffBalancesPolicyTypeValue IN_LIEU = new TimeOffBalancesPolicyTypeValue("in_lieu");
    public static final TimeOffBalancesPolicyTypeValue BEREAVEMENT = new TimeOffBalancesPolicyTypeValue("bereavement");
    public static final TimeOffBalancesPolicyTypeValue JURY_DUTY = new TimeOffBalancesPolicyTypeValue("jury_duty");
    public static final TimeOffBalancesPolicyTypeValue UNMAPPED_VALUE = new TimeOffBalancesPolicyTypeValue("unmapped_value");
    private static final Map<String, TimeOffBalancesPolicyTypeValue> values = TimeOffBalancesPolicyTypeValue.createValuesMap();
    private static final Map<String, TimeOffBalancesPolicyTypeValueEnum> enums = TimeOffBalancesPolicyTypeValue.createEnumsMap();
    private final String value;

    private TimeOffBalancesPolicyTypeValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TimeOffBalancesPolicyTypeValue of(String value) {
        Class<TimeOffBalancesPolicyTypeValue> clazz = TimeOffBalancesPolicyTypeValue.class;
        synchronized (TimeOffBalancesPolicyTypeValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new TimeOffBalancesPolicyTypeValue((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<TimeOffBalancesPolicyTypeValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeOffBalancesPolicyTypeValue other = (TimeOffBalancesPolicyTypeValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "TimeOffBalancesPolicyTypeValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TimeOffBalancesPolicyTypeValue[] values() {
        Class<TimeOffBalancesPolicyTypeValue> clazz = TimeOffBalancesPolicyTypeValue.class;
        synchronized (TimeOffBalancesPolicyTypeValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new TimeOffBalancesPolicyTypeValue[0]);
        }
    }

    private static final Map<String, TimeOffBalancesPolicyTypeValue> createValuesMap() {
        LinkedHashMap<String, TimeOffBalancesPolicyTypeValue> map = new LinkedHashMap<String, TimeOffBalancesPolicyTypeValue>();
        map.put("paid", PAID);
        map.put("unpaid", UNPAID);
        map.put("holiday", HOLIDAY);
        map.put("vacation", VACATION);
        map.put("sick", SICK);
        map.put("personal", PERSONAL);
        map.put("in_lieu", IN_LIEU);
        map.put("bereavement", BEREAVEMENT);
        map.put("jury_duty", JURY_DUTY);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, TimeOffBalancesPolicyTypeValueEnum> createEnumsMap() {
        HashMap<String, TimeOffBalancesPolicyTypeValueEnum> map = new HashMap<String, TimeOffBalancesPolicyTypeValueEnum>();
        map.put("paid", TimeOffBalancesPolicyTypeValueEnum.PAID);
        map.put("unpaid", TimeOffBalancesPolicyTypeValueEnum.UNPAID);
        map.put("holiday", TimeOffBalancesPolicyTypeValueEnum.HOLIDAY);
        map.put("vacation", TimeOffBalancesPolicyTypeValueEnum.VACATION);
        map.put("sick", TimeOffBalancesPolicyTypeValueEnum.SICK);
        map.put("personal", TimeOffBalancesPolicyTypeValueEnum.PERSONAL);
        map.put("in_lieu", TimeOffBalancesPolicyTypeValueEnum.IN_LIEU);
        map.put("bereavement", TimeOffBalancesPolicyTypeValueEnum.BEREAVEMENT);
        map.put("jury_duty", TimeOffBalancesPolicyTypeValueEnum.JURY_DUTY);
        map.put("unmapped_value", TimeOffBalancesPolicyTypeValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum TimeOffBalancesPolicyTypeValueEnum {
        PAID("paid"),
        UNPAID("unpaid"),
        HOLIDAY("holiday"),
        VACATION("vacation"),
        SICK("sick"),
        PERSONAL("personal"),
        IN_LIEU("in_lieu"),
        BEREAVEMENT("bereavement"),
        JURY_DUTY("jury_duty"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private TimeOffBalancesPolicyTypeValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<TimeOffBalancesPolicyTypeValue> {
        protected _Deserializer() {
            super(TimeOffBalancesPolicyTypeValue.class);
        }

        public TimeOffBalancesPolicyTypeValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return TimeOffBalancesPolicyTypeValue.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<TimeOffBalancesPolicyTypeValue> {
        protected _Serializer() {
            super(TimeOffBalancesPolicyTypeValue.class);
        }

        public void serialize(TimeOffBalancesPolicyTypeValue value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

