/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.DocumentsListFilesRequest;
import com.stackone.stackone_client_java.models.operations.DocumentsListFilesResponse;
import com.stackone.stackone_client_java.operations.DocumentsListFiles;
import com.stackone.stackone_client_java.utils.Exceptions;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import com.stackone.stackone_client_java.utils.pagination.CursorTracker;
import com.stackone.stackone_client_java.utils.pagination.Paginator;
import java.util.Optional;
import java.util.stream.Stream;

public class DocumentsListFilesRequestBuilder {
    private DocumentsListFilesRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public DocumentsListFilesRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public DocumentsListFilesRequestBuilder request(DocumentsListFilesRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public DocumentsListFilesRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public DocumentsListFilesRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public DocumentsListFilesResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        DocumentsListFiles.Sync operation = new DocumentsListFiles.Sync(this.sdkConfiguration, options);
        return (DocumentsListFilesResponse)operation.handleResponse(operation.doRequest(this.request));
    }

    public Iterable<DocumentsListFilesResponse> callAsIterable() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        DocumentsListFiles.Sync operation = new DocumentsListFiles.Sync(this.sdkConfiguration, options);
        Paginator<DocumentsListFilesRequest, String> iterator = new Paginator<DocumentsListFilesRequest, String>(this.request, new CursorTracker<String>("$.next", String.class), DocumentsListFilesRequest::withNext, nextRequest -> Exceptions.unchecked(() -> operation.doRequest(this.request)).get());
        return () -> Utils.transform(iterator, operation::handleResponse);
    }

    public Stream<DocumentsListFilesResponse> callAsStream() {
        return Utils.toStream(this.callAsIterable());
    }
}

