/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.HrisListEmployeesRequest;
import com.stackone.stackone_client_java.models.operations.HrisListEmployeesResponse;
import com.stackone.stackone_client_java.operations.HrisListEmployees;
import com.stackone.stackone_client_java.utils.Exceptions;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import com.stackone.stackone_client_java.utils.pagination.CursorTracker;
import com.stackone.stackone_client_java.utils.pagination.Paginator;
import java.util.Optional;
import java.util.stream.Stream;

public class HrisListEmployeesRequestBuilder {
    private HrisListEmployeesRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public HrisListEmployeesRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public HrisListEmployeesRequestBuilder request(HrisListEmployeesRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public HrisListEmployeesRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public HrisListEmployeesRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public HrisListEmployeesResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        HrisListEmployees.Sync operation = new HrisListEmployees.Sync(this.sdkConfiguration, options);
        return (HrisListEmployeesResponse)operation.handleResponse(operation.doRequest(this.request));
    }

    public Iterable<HrisListEmployeesResponse> callAsIterable() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        HrisListEmployees.Sync operation = new HrisListEmployees.Sync(this.sdkConfiguration, options);
        Paginator<HrisListEmployeesRequest, String> iterator = new Paginator<HrisListEmployeesRequest, String>(this.request, new CursorTracker<String>("$.next", String.class), HrisListEmployeesRequest::withNext, nextRequest -> Exceptions.unchecked(() -> operation.doRequest(this.request)).get());
        return () -> Utils.transform(iterator, operation::handleResponse);
    }

    public Stream<HrisListEmployeesResponse> callAsStream() {
        return Utils.toStream(this.callAsIterable());
    }
}

