/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.HrisListEmploymentsRequest;
import com.stackone.stackone_client_java.models.operations.HrisListEmploymentsResponse;
import com.stackone.stackone_client_java.operations.HrisListEmployments;
import com.stackone.stackone_client_java.utils.Exceptions;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import com.stackone.stackone_client_java.utils.pagination.CursorTracker;
import com.stackone.stackone_client_java.utils.pagination.Paginator;
import java.util.Optional;
import java.util.stream.Stream;

public class HrisListEmploymentsRequestBuilder {
    private HrisListEmploymentsRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public HrisListEmploymentsRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public HrisListEmploymentsRequestBuilder request(HrisListEmploymentsRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public HrisListEmploymentsRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public HrisListEmploymentsRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public HrisListEmploymentsResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        HrisListEmployments.Sync operation = new HrisListEmployments.Sync(this.sdkConfiguration, options);
        return (HrisListEmploymentsResponse)operation.handleResponse(operation.doRequest(this.request));
    }

    public Iterable<HrisListEmploymentsResponse> callAsIterable() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        HrisListEmployments.Sync operation = new HrisListEmployments.Sync(this.sdkConfiguration, options);
        Paginator<HrisListEmploymentsRequest, String> iterator = new Paginator<HrisListEmploymentsRequest, String>(this.request, new CursorTracker<String>("$.next", String.class), HrisListEmploymentsRequest::withNext, nextRequest -> Exceptions.unchecked(() -> operation.doRequest(this.request)).get());
        return () -> Utils.transform(iterator, operation::handleResponse);
    }

    public Stream<HrisListEmploymentsResponse> callAsStream() {
        return Utils.toStream(this.callAsIterable());
    }
}

