/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.EntitySkillsPaginated;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class HrisListEmployeeSkillsResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends EntitySkillsPaginated> entitySkillsPaginated;
    private Map<String, List<String>> headers;

    @JsonCreator
    public HrisListEmployeeSkillsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends EntitySkillsPaginated> entitySkillsPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(entitySkillsPaginated, "entitySkillsPaginated");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.entitySkillsPaginated = entitySkillsPaginated;
        this.headers = headers;
    }

    public HrisListEmployeeSkillsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<EntitySkillsPaginated> entitySkillsPaginated() {
        return this.entitySkillsPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public HrisListEmployeeSkillsResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public HrisListEmployeeSkillsResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public HrisListEmployeeSkillsResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public HrisListEmployeeSkillsResponse withEntitySkillsPaginated(EntitySkillsPaginated entitySkillsPaginated) {
        Utils.checkNotNull(entitySkillsPaginated, "entitySkillsPaginated");
        this.entitySkillsPaginated = Optional.ofNullable(entitySkillsPaginated);
        return this;
    }

    public HrisListEmployeeSkillsResponse withEntitySkillsPaginated(Optional<? extends EntitySkillsPaginated> entitySkillsPaginated) {
        Utils.checkNotNull(entitySkillsPaginated, "entitySkillsPaginated");
        this.entitySkillsPaginated = entitySkillsPaginated;
        return this;
    }

    public HrisListEmployeeSkillsResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HrisListEmployeeSkillsResponse other = (HrisListEmployeeSkillsResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.entitySkillsPaginated, other.entitySkillsPaginated) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.entitySkillsPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(HrisListEmployeeSkillsResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "entitySkillsPaginated", this.entitySkillsPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends EntitySkillsPaginated> entitySkillsPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder entitySkillsPaginated(EntitySkillsPaginated entitySkillsPaginated) {
            Utils.checkNotNull(entitySkillsPaginated, "entitySkillsPaginated");
            this.entitySkillsPaginated = Optional.ofNullable(entitySkillsPaginated);
            return this;
        }

        public Builder entitySkillsPaginated(Optional<? extends EntitySkillsPaginated> entitySkillsPaginated) {
            Utils.checkNotNull(entitySkillsPaginated, "entitySkillsPaginated");
            this.entitySkillsPaginated = entitySkillsPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public HrisListEmployeeSkillsResponse build() {
            return new HrisListEmployeeSkillsResponse(this.contentType, this.statusCode, this.rawResponse, this.entitySkillsPaginated, this.headers);
        }
    }
}

