/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.MarketingListPushTemplatesRequest;
import com.stackone.stackone_client_java.models.operations.MarketingListPushTemplatesResponse;
import com.stackone.stackone_client_java.operations.MarketingListPushTemplates;
import com.stackone.stackone_client_java.utils.Exceptions;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import com.stackone.stackone_client_java.utils.pagination.CursorTracker;
import com.stackone.stackone_client_java.utils.pagination.Paginator;
import java.util.Optional;
import java.util.stream.Stream;

public class MarketingListPushTemplatesRequestBuilder {
    private MarketingListPushTemplatesRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers();

    public MarketingListPushTemplatesRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public MarketingListPushTemplatesRequestBuilder request(MarketingListPushTemplatesRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public MarketingListPushTemplatesRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public MarketingListPushTemplatesRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public MarketingListPushTemplatesResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        MarketingListPushTemplates.Sync operation = new MarketingListPushTemplates.Sync(this.sdkConfiguration, options, this._headers);
        return (MarketingListPushTemplatesResponse)operation.handleResponse(operation.doRequest(this.request));
    }

    public Iterable<MarketingListPushTemplatesResponse> callAsIterable() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        MarketingListPushTemplates.Sync operation = new MarketingListPushTemplates.Sync(this.sdkConfiguration, options, this._headers);
        Paginator<MarketingListPushTemplatesRequest, String> iterator = new Paginator<MarketingListPushTemplatesRequest, String>(this.request, new CursorTracker<String>("$.next", String.class), MarketingListPushTemplatesRequest::withNext, nextRequest -> Exceptions.unchecked(() -> operation.doRequest(this.request)).get());
        return () -> Utils.transform(iterator, operation::handleResponse);
    }

    public Stream<MarketingListPushTemplatesResponse> callAsStream() {
        return Utils.toStream(this.callAsIterable());
    }
}

