/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.HRISLocationsPaginated;
import com.stackone.stackone_client_java.utils.AsyncResponse;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Utils;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class HrisListLocationsResponse
implements AsyncResponse {
    private String contentType;
    private int statusCode;
    private HttpResponse<Blob> rawResponse;
    private Optional<? extends HRISLocationsPaginated> hrisLocationsPaginated;
    private Map<String, List<String>> headers;

    @JsonCreator
    public HrisListLocationsResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Optional<? extends HRISLocationsPaginated> hrisLocationsPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(hrisLocationsPaginated, "hrisLocationsPaginated");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.hrisLocationsPaginated = hrisLocationsPaginated;
        this.headers = headers;
    }

    public HrisListLocationsResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<Blob> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<HRISLocationsPaginated> hrisLocationsPaginated() {
        return this.hrisLocationsPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public HrisListLocationsResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public HrisListLocationsResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public HrisListLocationsResponse withRawResponse(HttpResponse<Blob> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public HrisListLocationsResponse withHRISLocationsPaginated(HRISLocationsPaginated hrisLocationsPaginated) {
        Utils.checkNotNull(hrisLocationsPaginated, "hrisLocationsPaginated");
        this.hrisLocationsPaginated = Optional.ofNullable(hrisLocationsPaginated);
        return this;
    }

    public HrisListLocationsResponse withHRISLocationsPaginated(Optional<? extends HRISLocationsPaginated> hrisLocationsPaginated) {
        Utils.checkNotNull(hrisLocationsPaginated, "hrisLocationsPaginated");
        this.hrisLocationsPaginated = hrisLocationsPaginated;
        return this;
    }

    public HrisListLocationsResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HrisListLocationsResponse other = (HrisListLocationsResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.hrisLocationsPaginated, other.hrisLocationsPaginated) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.hrisLocationsPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(HrisListLocationsResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "hrisLocationsPaginated", this.hrisLocationsPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<Blob> rawResponse;
        private Optional<? extends HRISLocationsPaginated> hrisLocationsPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<Blob> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder hrisLocationsPaginated(HRISLocationsPaginated hrisLocationsPaginated) {
            Utils.checkNotNull(hrisLocationsPaginated, "hrisLocationsPaginated");
            this.hrisLocationsPaginated = Optional.ofNullable(hrisLocationsPaginated);
            return this;
        }

        public Builder hrisLocationsPaginated(Optional<? extends HRISLocationsPaginated> hrisLocationsPaginated) {
            Utils.checkNotNull(hrisLocationsPaginated, "hrisLocationsPaginated");
            this.hrisLocationsPaginated = hrisLocationsPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public HrisListLocationsResponse build() {
            return new HrisListLocationsResponse(this.contentType, this.statusCode, this.rawResponse, this.hrisLocationsPaginated, this.headers);
        }
    }
}

