/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Double;
import java.lang.Override;
import java.lang.String;
import org.openapitools.jackson.nullable.JsonNullable;


public class MessagingAttachment {
    /**
     * Unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * Provider's unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_id")
    private JsonNullable<String> remoteId;

    /**
     * Name of the attached file
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("file_name")
    private JsonNullable<String> fileName;

    /**
     * Size of the attached file
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("file_size")
    private JsonNullable<Double> fileSize;

    /**
     * MIME type of the attached file
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("file_type")
    private JsonNullable<String> fileType;

    @JsonCreator
    public MessagingAttachment(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("remote_id") JsonNullable<String> remoteId,
            @JsonProperty("file_name") JsonNullable<String> fileName,
            @JsonProperty("file_size") JsonNullable<Double> fileSize,
            @JsonProperty("file_type") JsonNullable<String> fileType) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(remoteId, "remoteId");
        Utils.checkNotNull(fileName, "fileName");
        Utils.checkNotNull(fileSize, "fileSize");
        Utils.checkNotNull(fileType, "fileType");
        this.id = id;
        this.remoteId = remoteId;
        this.fileName = fileName;
        this.fileSize = fileSize;
        this.fileType = fileType;
    }
    
    public MessagingAttachment() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * Provider's unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> remoteId() {
        return remoteId;
    }

    /**
     * Name of the attached file
     */
    @JsonIgnore
    public JsonNullable<String> fileName() {
        return fileName;
    }

    /**
     * Size of the attached file
     */
    @JsonIgnore
    public JsonNullable<Double> fileSize() {
        return fileSize;
    }

    /**
     * MIME type of the attached file
     */
    @JsonIgnore
    public JsonNullable<String> fileType() {
        return fileType;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Unique identifier
     */
    public MessagingAttachment withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * Unique identifier
     */
    public MessagingAttachment withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public MessagingAttachment withRemoteId(String remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = JsonNullable.of(remoteId);
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public MessagingAttachment withRemoteId(JsonNullable<String> remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = remoteId;
        return this;
    }

    /**
     * Name of the attached file
     */
    public MessagingAttachment withFileName(String fileName) {
        Utils.checkNotNull(fileName, "fileName");
        this.fileName = JsonNullable.of(fileName);
        return this;
    }

    /**
     * Name of the attached file
     */
    public MessagingAttachment withFileName(JsonNullable<String> fileName) {
        Utils.checkNotNull(fileName, "fileName");
        this.fileName = fileName;
        return this;
    }

    /**
     * Size of the attached file
     */
    public MessagingAttachment withFileSize(double fileSize) {
        Utils.checkNotNull(fileSize, "fileSize");
        this.fileSize = JsonNullable.of(fileSize);
        return this;
    }

    /**
     * Size of the attached file
     */
    public MessagingAttachment withFileSize(JsonNullable<Double> fileSize) {
        Utils.checkNotNull(fileSize, "fileSize");
        this.fileSize = fileSize;
        return this;
    }

    /**
     * MIME type of the attached file
     */
    public MessagingAttachment withFileType(String fileType) {
        Utils.checkNotNull(fileType, "fileType");
        this.fileType = JsonNullable.of(fileType);
        return this;
    }

    /**
     * MIME type of the attached file
     */
    public MessagingAttachment withFileType(JsonNullable<String> fileType) {
        Utils.checkNotNull(fileType, "fileType");
        this.fileType = fileType;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MessagingAttachment other = (MessagingAttachment) o;
        return 
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.remoteId, other.remoteId) &&
            Utils.enhancedDeepEquals(this.fileName, other.fileName) &&
            Utils.enhancedDeepEquals(this.fileSize, other.fileSize) &&
            Utils.enhancedDeepEquals(this.fileType, other.fileType);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            id, remoteId, fileName,
            fileSize, fileType);
    }
    
    @Override
    public String toString() {
        return Utils.toString(MessagingAttachment.class,
                "id", id,
                "remoteId", remoteId,
                "fileName", fileName,
                "fileSize", fileSize,
                "fileType", fileType);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<String> id = JsonNullable.undefined();

        private JsonNullable<String> remoteId = JsonNullable.undefined();

        private JsonNullable<String> fileName = JsonNullable.undefined();

        private JsonNullable<Double> fileSize = JsonNullable.undefined();

        private JsonNullable<String> fileType = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Unique identifier
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * Unique identifier
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }


        /**
         * Provider's unique identifier
         */
        public Builder remoteId(String remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = JsonNullable.of(remoteId);
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(JsonNullable<String> remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = remoteId;
            return this;
        }


        /**
         * Name of the attached file
         */
        public Builder fileName(String fileName) {
            Utils.checkNotNull(fileName, "fileName");
            this.fileName = JsonNullable.of(fileName);
            return this;
        }

        /**
         * Name of the attached file
         */
        public Builder fileName(JsonNullable<String> fileName) {
            Utils.checkNotNull(fileName, "fileName");
            this.fileName = fileName;
            return this;
        }


        /**
         * Size of the attached file
         */
        public Builder fileSize(double fileSize) {
            Utils.checkNotNull(fileSize, "fileSize");
            this.fileSize = JsonNullable.of(fileSize);
            return this;
        }

        /**
         * Size of the attached file
         */
        public Builder fileSize(JsonNullable<Double> fileSize) {
            Utils.checkNotNull(fileSize, "fileSize");
            this.fileSize = fileSize;
            return this;
        }


        /**
         * MIME type of the attached file
         */
        public Builder fileType(String fileType) {
            Utils.checkNotNull(fileType, "fileType");
            this.fileType = JsonNullable.of(fileType);
            return this;
        }

        /**
         * MIME type of the attached file
         */
        public Builder fileType(JsonNullable<String> fileType) {
            Utils.checkNotNull(fileType, "fileType");
            this.fileType = fileType;
            return this;
        }

        public MessagingAttachment build() {

            return new MessagingAttachment(
                id, remoteId, fileName,
                fileSize, fileType);
        }

    }
}
