/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.ConnectorsMeta;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;


public class StackoneListConnectorsMetaResponse implements Response {
    /**
     * HTTP response content type for this operation
     */
    private String contentType;

    /**
     * HTTP response status code for this operation
     */
    private int statusCode;

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    private HttpResponse<InputStream> rawResponse;

    /**
     * The list of connectors meta information was retrieved.
     */
    private Optional<? extends List<ConnectorsMeta>> connectorsMetas;


    private Map<String, List<String>> headers;

    @JsonCreator
    public StackoneListConnectorsMetaResponse(
            String contentType,
            int statusCode,
            HttpResponse<InputStream> rawResponse,
            Optional<? extends List<ConnectorsMeta>> connectorsMetas,
            Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(connectorsMetas, "connectorsMetas");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.connectorsMetas = connectorsMetas;
        this.headers = headers;
    }
    
    public StackoneListConnectorsMetaResponse(
            String contentType,
            int statusCode,
            HttpResponse<InputStream> rawResponse,
            Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse,
            Optional.empty(), headers);
    }

    /**
     * HTTP response content type for this operation
     */
    @JsonIgnore
    public String contentType() {
        return contentType;
    }

    /**
     * HTTP response status code for this operation
     */
    @JsonIgnore
    public int statusCode() {
        return statusCode;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return rawResponse;
    }

    /**
     * The list of connectors meta information was retrieved.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<List<ConnectorsMeta>> connectorsMetas() {
        return (Optional<List<ConnectorsMeta>>) connectorsMetas;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return headers;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * HTTP response content type for this operation
     */
    public StackoneListConnectorsMetaResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    /**
     * HTTP response status code for this operation
     */
    public StackoneListConnectorsMetaResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    public StackoneListConnectorsMetaResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    /**
     * The list of connectors meta information was retrieved.
     */
    public StackoneListConnectorsMetaResponse withConnectorsMetas(List<ConnectorsMeta> connectorsMetas) {
        Utils.checkNotNull(connectorsMetas, "connectorsMetas");
        this.connectorsMetas = Optional.ofNullable(connectorsMetas);
        return this;
    }


    /**
     * The list of connectors meta information was retrieved.
     */
    public StackoneListConnectorsMetaResponse withConnectorsMetas(Optional<? extends List<ConnectorsMeta>> connectorsMetas) {
        Utils.checkNotNull(connectorsMetas, "connectorsMetas");
        this.connectorsMetas = connectorsMetas;
        return this;
    }

    public StackoneListConnectorsMetaResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        StackoneListConnectorsMetaResponse other = (StackoneListConnectorsMetaResponse) o;
        return 
            Utils.enhancedDeepEquals(this.contentType, other.contentType) &&
            Utils.enhancedDeepEquals(this.statusCode, other.statusCode) &&
            Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) &&
            Utils.enhancedDeepEquals(this.connectorsMetas, other.connectorsMetas) &&
            Utils.enhancedDeepEquals(this.headers, other.headers);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            contentType, statusCode, rawResponse,
            connectorsMetas, headers);
    }
    
    @Override
    public String toString() {
        return Utils.toString(StackoneListConnectorsMetaResponse.class,
                "contentType", contentType,
                "statusCode", statusCode,
                "rawResponse", rawResponse,
                "connectorsMetas", connectorsMetas,
                "headers", headers);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String contentType;

        private Integer statusCode;

        private HttpResponse<InputStream> rawResponse;

        private Optional<? extends List<ConnectorsMeta>> connectorsMetas = Optional.empty();

        private Map<String, List<String>> headers;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * HTTP response content type for this operation
         */
        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }


        /**
         * HTTP response status code for this operation
         */
        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }


        /**
         * Raw HTTP response; suitable for custom response parsing
         */
        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }


        /**
         * The list of connectors meta information was retrieved.
         */
        public Builder connectorsMetas(List<ConnectorsMeta> connectorsMetas) {
            Utils.checkNotNull(connectorsMetas, "connectorsMetas");
            this.connectorsMetas = Optional.ofNullable(connectorsMetas);
            return this;
        }

        /**
         * The list of connectors meta information was retrieved.
         */
        public Builder connectorsMetas(Optional<? extends List<ConnectorsMeta>> connectorsMetas) {
            Utils.checkNotNull(connectorsMetas, "connectorsMetas");
            this.connectorsMetas = connectorsMetas;
            return this;
        }


        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public StackoneListConnectorsMetaResponse build() {

            return new StackoneListConnectorsMetaResponse(
                contentType, statusCode, rawResponse,
                connectorsMetas, headers);
        }

    }
}
