/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.AssessmentPackageResult;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class AtsGetAssessmentsPackageResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends AssessmentPackageResult> assessmentPackageResult;
    private Map<String, List<String>> headers;

    @JsonCreator
    public AtsGetAssessmentsPackageResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends AssessmentPackageResult> assessmentPackageResult, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(assessmentPackageResult, "assessmentPackageResult");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.assessmentPackageResult = assessmentPackageResult;
        this.headers = headers;
    }

    public AtsGetAssessmentsPackageResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<AssessmentPackageResult> assessmentPackageResult() {
        return this.assessmentPackageResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public AtsGetAssessmentsPackageResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public AtsGetAssessmentsPackageResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public AtsGetAssessmentsPackageResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public AtsGetAssessmentsPackageResponse withAssessmentPackageResult(AssessmentPackageResult assessmentPackageResult) {
        Utils.checkNotNull(assessmentPackageResult, "assessmentPackageResult");
        this.assessmentPackageResult = Optional.ofNullable(assessmentPackageResult);
        return this;
    }

    public AtsGetAssessmentsPackageResponse withAssessmentPackageResult(Optional<? extends AssessmentPackageResult> assessmentPackageResult) {
        Utils.checkNotNull(assessmentPackageResult, "assessmentPackageResult");
        this.assessmentPackageResult = assessmentPackageResult;
        return this;
    }

    public AtsGetAssessmentsPackageResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtsGetAssessmentsPackageResponse other = (AtsGetAssessmentsPackageResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.assessmentPackageResult, other.assessmentPackageResult) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.assessmentPackageResult, this.headers);
    }

    public String toString() {
        return Utils.toString(AtsGetAssessmentsPackageResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "assessmentPackageResult", this.assessmentPackageResult, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends AssessmentPackageResult> assessmentPackageResult = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder assessmentPackageResult(AssessmentPackageResult assessmentPackageResult) {
            Utils.checkNotNull(assessmentPackageResult, "assessmentPackageResult");
            this.assessmentPackageResult = Optional.ofNullable(assessmentPackageResult);
            return this;
        }

        public Builder assessmentPackageResult(Optional<? extends AssessmentPackageResult> assessmentPackageResult) {
            Utils.checkNotNull(assessmentPackageResult, "assessmentPackageResult");
            this.assessmentPackageResult = assessmentPackageResult;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public AtsGetAssessmentsPackageResponse build() {
            return new AtsGetAssessmentsPackageResponse(this.contentType, this.statusCode, this.rawResponse, this.assessmentPackageResult, this.headers);
        }
    }
}

