/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.InterviewStageResult;
import com.stackone.stackone_client_java.utils.AsyncResponse;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Utils;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class AtsGetApplicationStageResponse
implements AsyncResponse {
    private String contentType;
    private int statusCode;
    private HttpResponse<Blob> rawResponse;
    private Optional<? extends InterviewStageResult> interviewStageResult;
    private Map<String, List<String>> headers;

    @JsonCreator
    public AtsGetApplicationStageResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Optional<? extends InterviewStageResult> interviewStageResult, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(interviewStageResult, "interviewStageResult");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.interviewStageResult = interviewStageResult;
        this.headers = headers;
    }

    public AtsGetApplicationStageResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<Blob> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<InterviewStageResult> interviewStageResult() {
        return this.interviewStageResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public AtsGetApplicationStageResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public AtsGetApplicationStageResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public AtsGetApplicationStageResponse withRawResponse(HttpResponse<Blob> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public AtsGetApplicationStageResponse withInterviewStageResult(InterviewStageResult interviewStageResult) {
        Utils.checkNotNull(interviewStageResult, "interviewStageResult");
        this.interviewStageResult = Optional.ofNullable(interviewStageResult);
        return this;
    }

    public AtsGetApplicationStageResponse withInterviewStageResult(Optional<? extends InterviewStageResult> interviewStageResult) {
        Utils.checkNotNull(interviewStageResult, "interviewStageResult");
        this.interviewStageResult = interviewStageResult;
        return this;
    }

    public AtsGetApplicationStageResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtsGetApplicationStageResponse other = (AtsGetApplicationStageResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.interviewStageResult, other.interviewStageResult) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.interviewStageResult, this.headers);
    }

    public String toString() {
        return Utils.toString(AtsGetApplicationStageResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "interviewStageResult", this.interviewStageResult, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<Blob> rawResponse;
        private Optional<? extends InterviewStageResult> interviewStageResult = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<Blob> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder interviewStageResult(InterviewStageResult interviewStageResult) {
            Utils.checkNotNull(interviewStageResult, "interviewStageResult");
            this.interviewStageResult = Optional.ofNullable(interviewStageResult);
            return this;
        }

        public Builder interviewStageResult(Optional<? extends InterviewStageResult> interviewStageResult) {
            Utils.checkNotNull(interviewStageResult, "interviewStageResult");
            this.interviewStageResult = interviewStageResult;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public AtsGetApplicationStageResponse build() {
            return new AtsGetApplicationStageResponse(this.contentType, this.statusCode, this.rawResponse, this.interviewStageResult, this.headers);
        }
    }
}

