/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class AtsJobValue {
    public static final AtsJobValue PUBLISHED = new AtsJobValue("published");
    public static final AtsJobValue DRAFT = new AtsJobValue("draft");
    public static final AtsJobValue PENDING = new AtsJobValue("pending");
    public static final AtsJobValue INTERNAL = new AtsJobValue("internal");
    public static final AtsJobValue ARCHIVED = new AtsJobValue("archived");
    public static final AtsJobValue CLOSED = new AtsJobValue("closed");
    public static final AtsJobValue OPEN = new AtsJobValue("open");
    public static final AtsJobValue DELETED = new AtsJobValue("deleted");
    public static final AtsJobValue ON_HOLD = new AtsJobValue("on_hold");
    public static final AtsJobValue UNMAPPED_VALUE = new AtsJobValue("unmapped_value");
    private static final Map<String, AtsJobValue> values = AtsJobValue.createValuesMap();
    private static final Map<String, AtsJobValueEnum> enums = AtsJobValue.createEnumsMap();
    private final String value;

    private AtsJobValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AtsJobValue of(String value) {
        Class<AtsJobValue> clazz = AtsJobValue.class;
        synchronized (AtsJobValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new AtsJobValue((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<AtsJobValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AtsJobValue other = (AtsJobValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "AtsJobValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AtsJobValue[] values() {
        Class<AtsJobValue> clazz = AtsJobValue.class;
        synchronized (AtsJobValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new AtsJobValue[0]);
        }
    }

    private static final Map<String, AtsJobValue> createValuesMap() {
        LinkedHashMap<String, AtsJobValue> map = new LinkedHashMap<String, AtsJobValue>();
        map.put("published", PUBLISHED);
        map.put("draft", DRAFT);
        map.put("pending", PENDING);
        map.put("internal", INTERNAL);
        map.put("archived", ARCHIVED);
        map.put("closed", CLOSED);
        map.put("open", OPEN);
        map.put("deleted", DELETED);
        map.put("on_hold", ON_HOLD);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, AtsJobValueEnum> createEnumsMap() {
        HashMap<String, AtsJobValueEnum> map = new HashMap<String, AtsJobValueEnum>();
        map.put("published", AtsJobValueEnum.PUBLISHED);
        map.put("draft", AtsJobValueEnum.DRAFT);
        map.put("pending", AtsJobValueEnum.PENDING);
        map.put("internal", AtsJobValueEnum.INTERNAL);
        map.put("archived", AtsJobValueEnum.ARCHIVED);
        map.put("closed", AtsJobValueEnum.CLOSED);
        map.put("open", AtsJobValueEnum.OPEN);
        map.put("deleted", AtsJobValueEnum.DELETED);
        map.put("on_hold", AtsJobValueEnum.ON_HOLD);
        map.put("unmapped_value", AtsJobValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum AtsJobValueEnum {
        PUBLISHED("published"),
        DRAFT("draft"),
        PENDING("pending"),
        INTERNAL("internal"),
        ARCHIVED("archived"),
        CLOSED("closed"),
        OPEN("open"),
        DELETED("deleted"),
        ON_HOLD("on_hold"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private AtsJobValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<AtsJobValue> {
        protected _Deserializer() {
            super(AtsJobValue.class);
        }

        public AtsJobValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return AtsJobValue.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<AtsJobValue> {
        protected _Serializer() {
            super(AtsJobValue.class);
        }

        public void serialize(AtsJobValue value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

