/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class OverallRecommendation {
    public static final OverallRecommendation STRONG_YES = new OverallRecommendation("strong_yes");
    public static final OverallRecommendation YES = new OverallRecommendation("yes");
    public static final OverallRecommendation NO = new OverallRecommendation("no");
    public static final OverallRecommendation STRONG_NO = new OverallRecommendation("strong_no");
    public static final OverallRecommendation NO_DECISION = new OverallRecommendation("no_decision");
    public static final OverallRecommendation UNMAPPED_VALUE = new OverallRecommendation("unmapped_value");
    private static final Map<String, OverallRecommendation> values = OverallRecommendation.createValuesMap();
    private static final Map<String, OverallRecommendationEnum> enums = OverallRecommendation.createEnumsMap();
    private final String value;

    private OverallRecommendation(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OverallRecommendation of(String value) {
        Class<OverallRecommendation> clazz = OverallRecommendation.class;
        synchronized (OverallRecommendation.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new OverallRecommendation((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<OverallRecommendationEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OverallRecommendation other = (OverallRecommendation)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "OverallRecommendation [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OverallRecommendation[] values() {
        Class<OverallRecommendation> clazz = OverallRecommendation.class;
        synchronized (OverallRecommendation.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new OverallRecommendation[0]);
        }
    }

    private static final Map<String, OverallRecommendation> createValuesMap() {
        LinkedHashMap<String, OverallRecommendation> map = new LinkedHashMap<String, OverallRecommendation>();
        map.put("strong_yes", STRONG_YES);
        map.put("yes", YES);
        map.put("no", NO);
        map.put("strong_no", STRONG_NO);
        map.put("no_decision", NO_DECISION);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, OverallRecommendationEnum> createEnumsMap() {
        HashMap<String, OverallRecommendationEnum> map = new HashMap<String, OverallRecommendationEnum>();
        map.put("strong_yes", OverallRecommendationEnum.STRONG_YES);
        map.put("yes", OverallRecommendationEnum.YES);
        map.put("no", OverallRecommendationEnum.NO);
        map.put("strong_no", OverallRecommendationEnum.STRONG_NO);
        map.put("no_decision", OverallRecommendationEnum.NO_DECISION);
        map.put("unmapped_value", OverallRecommendationEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum OverallRecommendationEnum {
        STRONG_YES("strong_yes"),
        YES("yes"),
        NO("no"),
        STRONG_NO("strong_no"),
        NO_DECISION("no_decision"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private OverallRecommendationEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<OverallRecommendation> {
        protected _Deserializer() {
            super(OverallRecommendation.class);
        }

        public OverallRecommendation deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return OverallRecommendation.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<OverallRecommendation> {
        protected _Serializer() {
            super(OverallRecommendation.class);
        }

        public void serialize(OverallRecommendation value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

