/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.InviteEmployeeResult;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class HrisInviteEmployeeResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends InviteEmployeeResult> inviteEmployeeResult;
    private Map<String, List<String>> headers;

    @JsonCreator
    public HrisInviteEmployeeResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends InviteEmployeeResult> inviteEmployeeResult, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(inviteEmployeeResult, "inviteEmployeeResult");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.inviteEmployeeResult = inviteEmployeeResult;
        this.headers = headers;
    }

    public HrisInviteEmployeeResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<InviteEmployeeResult> inviteEmployeeResult() {
        return this.inviteEmployeeResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public HrisInviteEmployeeResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public HrisInviteEmployeeResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public HrisInviteEmployeeResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public HrisInviteEmployeeResponse withInviteEmployeeResult(InviteEmployeeResult inviteEmployeeResult) {
        Utils.checkNotNull(inviteEmployeeResult, "inviteEmployeeResult");
        this.inviteEmployeeResult = Optional.ofNullable(inviteEmployeeResult);
        return this;
    }

    public HrisInviteEmployeeResponse withInviteEmployeeResult(Optional<? extends InviteEmployeeResult> inviteEmployeeResult) {
        Utils.checkNotNull(inviteEmployeeResult, "inviteEmployeeResult");
        this.inviteEmployeeResult = inviteEmployeeResult;
        return this;
    }

    public HrisInviteEmployeeResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HrisInviteEmployeeResponse other = (HrisInviteEmployeeResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.inviteEmployeeResult, other.inviteEmployeeResult) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.inviteEmployeeResult, this.headers);
    }

    public String toString() {
        return Utils.toString(HrisInviteEmployeeResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "inviteEmployeeResult", this.inviteEmployeeResult, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends InviteEmployeeResult> inviteEmployeeResult = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder inviteEmployeeResult(InviteEmployeeResult inviteEmployeeResult) {
            Utils.checkNotNull(inviteEmployeeResult, "inviteEmployeeResult");
            this.inviteEmployeeResult = Optional.ofNullable(inviteEmployeeResult);
            return this;
        }

        public Builder inviteEmployeeResult(Optional<? extends InviteEmployeeResult> inviteEmployeeResult) {
            Utils.checkNotNull(inviteEmployeeResult, "inviteEmployeeResult");
            this.inviteEmployeeResult = inviteEmployeeResult;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public HrisInviteEmployeeResponse build() {
            return new HrisInviteEmployeeResponse(this.contentType, this.statusCode, this.rawResponse, this.inviteEmployeeResult, this.headers);
        }
    }
}

