/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.MessagingListUsersRequest;
import com.stackone.stackone_client_java.models.operations.async.MessagingListUsersResponse;
import com.stackone.stackone_client_java.operations.MessagingListUsers;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import com.stackone.stackone_client_java.utils.pagination.AsyncPaginator;
import com.stackone.stackone_client_java.utils.pagination.CursorTracker;
import com.stackone.stackone_client_java.utils.reactive.ReactiveUtils;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import org.reactivestreams.FlowAdapters;
import org.reactivestreams.Publisher;

public class MessagingListUsersRequestBuilder {
    private MessagingListUsersRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers();

    public MessagingListUsersRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public MessagingListUsersRequestBuilder request(MessagingListUsersRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public MessagingListUsersRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public MessagingListUsersRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public CompletableFuture<MessagingListUsersResponse> call() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        MessagingListUsers.Async operation = new MessagingListUsers.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler(), this._headers);
        return operation.doRequest(this.request).thenCompose(operation::handleResponse);
    }

    public Publisher<MessagingListUsersResponse> callAsPublisher() {
        MessagingListUsersRequest request = this.request;
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        MessagingListUsers.Async operation = new MessagingListUsers.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler(), this._headers);
        AsyncPaginator<MessagingListUsersRequest, String> asyncPaginator = new AsyncPaginator<MessagingListUsersRequest, String>(request, new CursorTracker<String>("$.next", String.class), MessagingListUsersRequest::withNext, operation::doRequest);
        Flow.Publisher flowPublisher = ReactiveUtils.mapAsync(asyncPaginator, operation::handleResponse);
        return FlowAdapters.toPublisher(flowPublisher);
    }
}

