/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.utils;

import com.stackone.stackone_client_java.utils.reactive.ReactiveUtils;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.concurrent.SubmissionPublisher;
import java.util.concurrent.atomic.AtomicBoolean;

public class Blob
implements HttpRequest.BodyPublisher {
    private final Flow.Publisher<ByteBuffer> publisher;
    private final long contentLength;
    private final AtomicBoolean consumed = new AtomicBoolean(false);

    private Blob(Flow.Publisher<ByteBuffer> publisher, long contentLength) {
        this.publisher = Objects.requireNonNull(publisher, "Publisher cannot be null");
        this.contentLength = contentLength;
    }

    public static Blob from(Path path) throws FileNotFoundException {
        Objects.requireNonNull(path, "Path cannot be null");
        HttpRequest.BodyPublisher bodyPublisher = HttpRequest.BodyPublishers.ofFile(path);
        return new Blob(bodyPublisher, bodyPublisher.contentLength());
    }

    public static Blob from(InputStream inputStream) {
        Objects.requireNonNull(inputStream, "InputStream cannot be null");
        HttpRequest.BodyPublisher bodyPublisher = HttpRequest.BodyPublishers.ofInputStream(() -> inputStream);
        return new Blob(bodyPublisher, -1L);
    }

    public static Blob from(String string) {
        Objects.requireNonNull(string, "String cannot be null");
        HttpRequest.BodyPublisher bodyPublisher = HttpRequest.BodyPublishers.ofString(string, StandardCharsets.UTF_8);
        return new Blob(bodyPublisher, bodyPublisher.contentLength());
    }

    public static Blob from(byte[] data) {
        Objects.requireNonNull(data, "Data cannot be null");
        HttpRequest.BodyPublisher bodyPublisher = HttpRequest.BodyPublishers.ofByteArray(data);
        return new Blob(bodyPublisher, data.length);
    }

    public static Blob from(ByteBuffer buffer) {
        Objects.requireNonNull(buffer, "ByteBuffer cannot be null");
        SubmissionPublisher<ByteBuffer> publisher = new SubmissionPublisher<ByteBuffer>();
        publisher.submit(buffer.duplicate());
        publisher.close();
        return new Blob(publisher, buffer.remaining());
    }

    public static Blob from(List<ByteBuffer> buffers) {
        Objects.requireNonNull(buffers, "ByteBuffer list cannot be null");
        SubmissionPublisher<ByteBuffer> publisher = new SubmissionPublisher<ByteBuffer>();
        long totalLength = 0L;
        for (ByteBuffer buffer : buffers) {
            publisher.submit(buffer.duplicate());
            totalLength += (long)buffer.remaining();
        }
        publisher.close();
        return new Blob(publisher, totalLength);
    }

    public static Blob from(Flow.Publisher<List<ByteBuffer>> sourcePublisher) {
        Objects.requireNonNull(sourcePublisher, "Source publisher cannot be null");
        Flow.Publisher<ByteBuffer> flattenedPublisher = ReactiveUtils.flatten(sourcePublisher);
        return new Blob(flattenedPublisher, -1L);
    }

    public Flow.Publisher<ByteBuffer> asPublisher() {
        return this.ensureNotConsumedAndMark();
    }

    public CompletableFuture<byte[]> toByteArray() {
        Flow.Publisher<ByteBuffer> currentPublisher = this.ensureNotConsumedAndMark();
        Flow.Publisher<List<ByteBuffer>> listPublisher = ReactiveUtils.wrapped(currentPublisher);
        HttpResponse.BodySubscriber<byte[]> bodySubscriber = HttpResponse.BodySubscribers.ofByteArray();
        listPublisher.subscribe(bodySubscriber);
        return bodySubscriber.getBody().toCompletableFuture();
    }

    public CompletableFuture<Path> toFile(Path destinationPath) {
        Objects.requireNonNull(destinationPath, "Destination path cannot be null");
        Flow.Publisher<ByteBuffer> currentPublisher = this.ensureNotConsumedAndMark();
        Flow.Publisher<List<ByteBuffer>> listPublisher = ReactiveUtils.wrapped(currentPublisher);
        HttpResponse.BodySubscriber<Path> bodySubscriber = HttpResponse.BodySubscribers.ofFile(destinationPath);
        listPublisher.subscribe(bodySubscriber);
        return bodySubscriber.getBody().toCompletableFuture();
    }

    public CompletableFuture<InputStream> toInputStream() {
        Flow.Publisher<ByteBuffer> currentPublisher = this.ensureNotConsumedAndMark();
        Flow.Publisher<List<ByteBuffer>> listPublisher = ReactiveUtils.wrapped(currentPublisher);
        HttpResponse.BodySubscriber<InputStream> bodySubscriber = HttpResponse.BodySubscribers.ofInputStream();
        listPublisher.subscribe(bodySubscriber);
        return bodySubscriber.getBody().toCompletableFuture();
    }

    private Flow.Publisher<ByteBuffer> ensureNotConsumedAndMark() {
        if (!this.consumed.compareAndSet(false, true)) {
            throw new IllegalStateException("This Blob instance has already been consumed and cannot be reused.");
        }
        return this.publisher;
    }

    @Override
    public long contentLength() {
        return this.contentLength;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super ByteBuffer> subscriber) {
        this.publisher.subscribe(subscriber);
    }
}

