/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.models.components.LmsUser;
import com.stackone.stackone_client_java.models.components.RawResponse;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;

public class UserResult {
    @JsonProperty(value="data")
    private LmsUser data;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="raw")
    private JsonNullable<? extends List<RawResponse>> raw;

    @JsonCreator
    public UserResult(@JsonProperty(value="data") LmsUser data, @JsonProperty(value="raw") JsonNullable<? extends List<RawResponse>> raw) {
        Utils.checkNotNull(data, "data");
        Utils.checkNotNull(raw, "raw");
        this.data = data;
        this.raw = raw;
    }

    public UserResult(LmsUser data) {
        this(data, (JsonNullable<? extends List<RawResponse>>)JsonNullable.undefined());
    }

    @JsonIgnore
    public LmsUser data() {
        return this.data;
    }

    @JsonIgnore
    public JsonNullable<List<RawResponse>> raw() {
        return this.raw;
    }

    public static Builder builder() {
        return new Builder();
    }

    public UserResult withData(LmsUser data) {
        Utils.checkNotNull(data, "data");
        this.data = data;
        return this;
    }

    public UserResult withRaw(List<RawResponse> raw) {
        Utils.checkNotNull(raw, "raw");
        this.raw = JsonNullable.of(raw);
        return this;
    }

    public UserResult withRaw(JsonNullable<? extends List<RawResponse>> raw) {
        Utils.checkNotNull(raw, "raw");
        this.raw = raw;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserResult other = (UserResult)o;
        return Utils.enhancedDeepEquals(this.data, other.data) && Utils.enhancedDeepEquals(this.raw, other.raw);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.data, this.raw);
    }

    public String toString() {
        return Utils.toString(UserResult.class, "data", this.data, "raw", this.raw);
    }

    public static final class Builder {
        private LmsUser data;
        private JsonNullable<? extends List<RawResponse>> raw = JsonNullable.undefined();

        private Builder() {
        }

        public Builder data(LmsUser data) {
            Utils.checkNotNull(data, "data");
            this.data = data;
            return this;
        }

        public Builder raw(List<RawResponse> raw) {
            Utils.checkNotNull(raw, "raw");
            this.raw = JsonNullable.of(raw);
            return this;
        }

        public Builder raw(JsonNullable<? extends List<RawResponse>> raw) {
            Utils.checkNotNull(raw, "raw");
            this.raw = raw;
            return this;
        }

        public UserResult build() {
            return new UserResult(this.data, this.raw);
        }
    }
}

