/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.AtsDocumentResult;
import com.stackone.stackone_client_java.utils.AsyncResponse;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Utils;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class AtsGetApplicationDocumentResponse
implements AsyncResponse {
    private String contentType;
    private int statusCode;
    private HttpResponse<Blob> rawResponse;
    private Optional<? extends AtsDocumentResult> atsDocumentResult;
    private Map<String, List<String>> headers;

    @JsonCreator
    public AtsGetApplicationDocumentResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Optional<? extends AtsDocumentResult> atsDocumentResult, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(atsDocumentResult, "atsDocumentResult");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.atsDocumentResult = atsDocumentResult;
        this.headers = headers;
    }

    public AtsGetApplicationDocumentResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<Blob> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<AtsDocumentResult> atsDocumentResult() {
        return this.atsDocumentResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public AtsGetApplicationDocumentResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public AtsGetApplicationDocumentResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public AtsGetApplicationDocumentResponse withRawResponse(HttpResponse<Blob> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public AtsGetApplicationDocumentResponse withAtsDocumentResult(AtsDocumentResult atsDocumentResult) {
        Utils.checkNotNull(atsDocumentResult, "atsDocumentResult");
        this.atsDocumentResult = Optional.ofNullable(atsDocumentResult);
        return this;
    }

    public AtsGetApplicationDocumentResponse withAtsDocumentResult(Optional<? extends AtsDocumentResult> atsDocumentResult) {
        Utils.checkNotNull(atsDocumentResult, "atsDocumentResult");
        this.atsDocumentResult = atsDocumentResult;
        return this;
    }

    public AtsGetApplicationDocumentResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtsGetApplicationDocumentResponse other = (AtsGetApplicationDocumentResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.atsDocumentResult, other.atsDocumentResult) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.atsDocumentResult, this.headers);
    }

    public String toString() {
        return Utils.toString(AtsGetApplicationDocumentResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "atsDocumentResult", this.atsDocumentResult, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<Blob> rawResponse;
        private Optional<? extends AtsDocumentResult> atsDocumentResult = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<Blob> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder atsDocumentResult(AtsDocumentResult atsDocumentResult) {
            Utils.checkNotNull(atsDocumentResult, "atsDocumentResult");
            this.atsDocumentResult = Optional.ofNullable(atsDocumentResult);
            return this;
        }

        public Builder atsDocumentResult(Optional<? extends AtsDocumentResult> atsDocumentResult) {
            Utils.checkNotNull(atsDocumentResult, "atsDocumentResult");
            this.atsDocumentResult = atsDocumentResult;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public AtsGetApplicationDocumentResponse build() {
            return new AtsGetApplicationDocumentResponse(this.contentType, this.statusCode, this.rawResponse, this.atsDocumentResult, this.headers);
        }
    }
}

